/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntityBudgie;
import pavocado.exoticbirds.models.ModelBudgie;
import pavocado.exoticbirds.render.RenderBird;

public class RenderBudgie
extends RenderBird<EntityBudgie> {
    private static final ResourceLocation birdTexture1 = new ResourceLocation("exoticbirds:textures/entity/budgerigar/budgie_green.png");
    private static final ResourceLocation birdTexture2 = new ResourceLocation("exoticbirds:textures/entity/budgerigar/budgie_blue.png");
    private static final ResourceLocation birdTexture3 = new ResourceLocation("exoticbirds:textures/entity/budgerigar/budgie_yellow.png");
    private static final ResourceLocation birdTexture4 = new ResourceLocation("exoticbirds:textures/entity/budgerigar/budgie_dark_blue.png");
    private static final ResourceLocation birdTexture5 = new ResourceLocation("exoticbirds:textures/entity/budgerigar/budgie_white.png");

    public RenderBudgie(RenderManager manager) {
        super(manager, new ModelBudgie(), 0.2f);
    }

    protected float handleRotationFloat(EntityBudgie livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    @Override
    public ResourceLocation getEntityTextureForId(int birdId) {
        switch (birdId) {
            case 0: {
                return birdTexture1;
            }
            case 1: {
                return birdTexture2;
            }
            case 2: {
                return birdTexture3;
            }
            case 3: {
                return birdTexture4;
            }
            case 4: {
                return birdTexture5;
            }
        }
        return birdTexture1;
    }
}

