/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntityOstrich;
import pavocado.exoticbirds.models.ModelOstrich;
import pavocado.exoticbirds.render.RenderBird;

public class RenderOstrich
extends RenderBird<EntityOstrich> {
    private static final ResourceLocation maleTexture = new ResourceLocation("exoticbirds:textures/entity/ostrich/ostrich_male.png");
    private static final ResourceLocation femaleTexture = new ResourceLocation("exoticbirds:textures/entity/ostrich/ostrich_female.png");
    private static final ResourceLocation babyTexture = new ResourceLocation("exoticbirds:textures/entity/ostrich/ostrich_chick.png");

    public RenderOstrich(RenderManager manager) {
        super(manager, new ModelOstrich(), 0.5f);
    }

    protected float handleRotationFloat(EntityOstrich livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected ResourceLocation getEntityTexture(EntityOstrich entity) {
        return entity.func_70631_g_() ? babyTexture : this.getEntityTextureForId(entity.getBirdType());
    }

    @Override
    public ResourceLocation getEntityTextureForId(int birdId) {
        switch (birdId) {
            case 0: {
                return maleTexture;
            }
            case 1: {
                return femaleTexture;
            }
        }
        return maleTexture;
    }
}

