/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntityPigeon;
import pavocado.exoticbirds.models.ModelPigeon;
import pavocado.exoticbirds.render.RenderBird;

public class RenderPigeon
extends RenderBird<EntityPigeon> {
    private static final ResourceLocation birdTexture1 = new ResourceLocation("exoticbirds:textures/entity/pigeon/pigeon_wood.png");
    private static final ResourceLocation birdTexture2 = new ResourceLocation("exoticbirds:textures/entity/pigeon/dove.png");
    private static final ResourceLocation birdTexture3 = new ResourceLocation("exoticbirds:textures/entity/pigeon/pigeon_wood.png");

    public RenderPigeon(RenderManager manager) {
        super(manager, new ModelPigeon(), 0.2f);
    }

    protected float handleRotationFloat(EntityPigeon livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected ResourceLocation getEntityTexture(EntityPigeon entity) {
        return this.getEntityTextureForId(entity.getBirdType());
    }

    @Override
    public ResourceLocation getEntityTextureForId(int birdId) {
        switch (birdId) {
            case 0: {
                return birdTexture1;
            }
            case 1: {
                return birdTexture2;
            }
            case 2: {
                return birdTexture3;
            }
        }
        return birdTexture1;
    }
}

