/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds;

import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import pavocado.exoticbirds.entity.Birds.EntityPeafowl;
import pavocado.exoticbirds.entity.Birds.EntityPhoenix;

public abstract class EntityBird
extends EntityAnimal {
    public int noOfTypes;
    public int timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 12000;
    private Item eggType;
    public float startRotation;
    public float destPos;
    public float groundOffset;
    public float wingRotation;
    public float speedBuffer = 1.0f;
    public boolean canFloat = true;
    public boolean gendered = false;
    private Item temptItem;
    private Item breedItem;

    public EntityBird(World worldIn, Item egg, int types, boolean canFloat, boolean gender) {
        super(worldIn);
        this.eggType = egg;
        this.noOfTypes = types;
        this.canFloat = canFloat;
        this.gendered = gender;
    }

    public String getBirdNameUnformatted() {
        if (this.noOfTypes == 1 || this.gendered) {
            return "species." + this.func_70022_Q() + ".name";
        }
        return "species." + this.func_70022_Q() + this.getBirdType() + ".name";
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.wingRotation = this.startRotation;
        this.groundOffset = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E || this.field_70171_ac ? -1 : 4) * 0.3);
        if (this.destPos < 0.0f) {
            this.destPos = 0.0f;
        }
        if (this.destPos > 1.0f) {
            this.destPos = 1.0f;
        }
        if (this.canFloat) {
            if (!this.field_70122_E && this.speedBuffer < 1.0f) {
                this.speedBuffer = 1.0f;
            }
            this.speedBuffer = (float)((double)this.speedBuffer * 0.9);
            if (!this.field_70122_E && this.field_70181_x < 0.0) {
                this.field_70181_x *= 0.6;
            }
            this.startRotation += this.speedBuffer * 2.0f;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0 && this.field_70122_E) {
            if (!(this instanceof EntityPhoenix) && (!this.gendered || this.gendered && this.getBirdType() == 1)) {
                this.func_85030_a("mob.chicken.plop", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_145779_a(this.eggType, 1);
            } else if (this.getBirdType() == 2 && this instanceof EntityPeafowl) {
                this.func_145779_a(Items.field_151043_k, 1);
            }
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 12000;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    public void setBirdType(int birdID) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)birdID));
    }

    public int getBirdType() {
        return this.field_70180_af.func_75683_a(19);
    }

    public void setFoodItems(Item tempt, Item breed) {
        this.temptItem = tempt;
        this.breedItem = breed;
    }

    public Item getTemptedItem() {
        return this.temptItem;
    }

    public Item getBreedItem() {
        return this.breedItem;
    }

    public void func_70069_a(float distance) {
        if (!this.canFloat) {
            super.func_70069_a(distance);
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
        tagCompound.func_74768_a("Type", this.getBirdType());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = tagCompund.func_74762_e("EggLayTime");
        }
        this.setBirdType(tagCompund.func_74762_e("Type"));
    }

    public IEntityLivingData func_110161_a(IEntityLivingData livingdata) {
        livingdata = super.func_110161_a(livingdata);
        this.setBirdType(this.field_70170_p.field_73012_v.nextInt(this.noOfTypes));
        return livingdata;
    }
}

