/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import pavocado.exoticbirds.entity.Birds.EntityBirdTameable;
import pavocado.exoticbirds.entity.EntityAIBirdFollowOwner;
import pavocado.exoticbirds.entity.EntityAILayEggInNest;
import pavocado.exoticbirds.init.ExoticbirdsItems;

public class EntityParrot
extends EntityBirdTameable {
    public boolean isFlyingTamed;
    private EntityPlayer nearestPlayer;
    private ChunkCoordinates spawnPosition;

    public EntityParrot(World worldIn) {
        super(worldIn, ExoticbirdsItems.parrot_egg, 4, true, false);
        this.setFoodItems(Items.field_151014_N, Items.field_151014_N);
        this.func_70105_a(0.5f, 0.85f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILayEggInNest((EntityLiving)this, ExoticbirdsItems.parrot_egg));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIBirdFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Items.field_151014_N, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new Float(this.func_110143_aJ()));
    }

    protected String func_70639_aQ() {
        return "exoticbirds:parrot_chirp";
    }

    protected String func_70621_aR() {
        return "exoticbirds:parrot_hurt";
    }

    protected String func_70673_aS() {
        return "exoticbirds:parrot_hurt";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("mob.chicken.step", 0.15f, 1.0f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack != null && stack.func_77973_b() == Items.field_151014_N;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityParrot entityparrot = new EntityParrot(this.field_70170_p);
        entityparrot.setBirdType(this.getBirdType());
        return entityparrot;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.func_71045_bC();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151057_cb) {
            itemstack.func_111282_a(player, (EntityLivingBase)this);
            return true;
        }
        if (!this.isTamed() && itemstack != null) {
            if (itemstack.func_77973_b() == Items.field_151080_bb) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_71045_bC().field_77994_a;
                }
                if (player.func_71045_bC().field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        this.setTamed(true);
                        this.func_70778_a(null);
                        this.setOwner(player.func_110124_au().toString());
                        this.spawnTamedParticles(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.spawnTamedParticles(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                return true;
            }
            if (itemstack.func_77973_b() == Items.field_151014_N) {
                return false;
            }
        } else if (this.isTamed() && this.getOwner() == player) {
            if (player.func_70093_af()) {
                if (!this.field_70170_p.field_72995_K) {
                    ItemStack parrotstack = new ItemStack(ExoticbirdsItems.shoulder_parrot);
                    if (parrotstack.func_77978_p() == null || !parrotstack.func_77978_p().func_74764_b("parrotInfo")) {
                        parrotstack.func_77982_d(new NBTTagCompound());
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74768_a("birdType", this.getBirdType());
                        nbt.func_74776_a("birdHealth", this.func_110143_aJ());
                        nbt.func_74768_a("birdGrowingAge", this.func_70874_b());
                        if (this.func_94056_bM()) {
                            nbt.func_74778_a("birdName", this.func_94057_bL());
                        } else {
                            nbt.func_74778_a("birdName", "");
                        }
                        if (this.getOwnerName() == null) {
                            nbt.func_74778_a("OwnerUUID", "");
                        } else {
                            nbt.func_74778_a("OwnerUUID", this.getOwnerName());
                        }
                        parrotstack.func_77978_p().func_74782_a("parrotInfo", (NBTBase)nbt);
                    }
                    if (player.func_82169_q(3) == null) {
                        player.func_70062_b(4, parrotstack);
                        this.func_70106_y();
                    } else {
                        player.field_71071_by.func_70441_a(parrotstack);
                        this.func_70106_y();
                    }
                }
            } else if (!this.field_70170_p.field_72995_K && itemstack == null) {
                if (this.isSitting()) {
                    this.aiSit.setSitting(false);
                    this.isFlyingTamed = true;
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"entity.parrot.tamed.fly")));
                } else if (this.isFlyingTamed) {
                    this.isFlyingTamed = false;
                    this.aiSit.setSitting(false);
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"entity.parrot.tamed.walk")));
                } else {
                    this.isFlyingTamed = false;
                    this.aiSit.setSitting(true);
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"entity.parrot.tamed.sit")));
                }
            }
        }
        return super.func_70085_c(player);
    }

    protected void func_70629_bd() {
        this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(this.func_110143_aJ()));
        int i5 = MathHelper.func_76128_c((double)this.field_70165_t);
        int j5 = MathHelper.func_76128_c((double)this.field_70163_u);
        int k5 = MathHelper.func_76128_c((double)this.field_70161_v);
        this.nearestPlayer = this.field_70170_p.func_72890_a((Entity)this, 10.0);
        if (this.nearestPlayer != null && this.isFlyingTamed && !this.isSitting() && this.nearestPlayer == this.getOwner()) {
            this.spawnPosition = new ChunkCoordinates((int)this.nearestPlayer.field_70165_t, (int)(this.nearestPlayer.field_70163_u + (double)this.nearestPlayer.func_70047_e() + (double)this.field_70146_Z.nextInt(10) * 0.1), (int)this.nearestPlayer.field_70161_v);
            double d0 = (double)this.spawnPosition.field_71574_a + 0.5 - this.field_70165_t;
            double d1 = (double)this.spawnPosition.field_71572_b + 0.1 - this.field_70163_u;
            double d2 = (double)this.spawnPosition.field_71573_c + 0.5 - this.field_70161_v;
            if ((double)this.spawnPosition.func_71569_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) > 8.0 && this.nearestPlayer != null) {
                this.field_70159_w += (d0 * 0.5 - this.field_70159_w) * (double)0.1f * 0.4;
                this.field_70181_x += (d1 * (double)0.7f - this.field_70181_x) * (double)0.1f * 0.6;
                this.field_70179_y += (d2 * 0.5 - this.field_70179_y) * (double)0.1f * 0.4;
                float f = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                float f1 = MathHelper.func_76142_g((float)f);
                this.field_70701_bs = 0.1f;
                if ((double)this.spawnPosition.func_71569_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 4.0 && this.nearestPlayer != null) {
                    this.func_70671_ap().func_75651_a((Entity)this.nearestPlayer, 30.0f, (float)this.func_70646_bf());
                } else {
                    this.field_70177_z = f1;
                }
            }
        }
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof EntityParrot)) {
            return false;
        }
        EntityParrot entityparrot = (EntityParrot)otherAnimal;
        if (entityparrot.getBirdType() == this.getBirdType()) {
            return this.func_70880_s() && entityparrot.func_70880_s();
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound tagcompound) {
        super.func_70014_b(tagcompound);
        tagcompound.func_74757_a("TamedFlight", this.isFlyingTamed);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagcompound) {
        super.func_70037_a(tagcompound);
        this.isFlyingTamed = tagcompound.func_74767_n("TamedFlight");
    }

    protected void func_70628_a(boolean fortune, int amount) {
        int j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + amount);
        if (this.func_70027_ad()) {
            this.func_145779_a(ExoticbirdsItems.cooked_birdmeat_small, 1);
        } else {
            this.func_145779_a(ExoticbirdsItems.birdmeat_small, 1);
        }
    }
}

