/*
 * Decompiled with CFR 0.152.
 */
package goldorion.farm_adventure.world.dimension;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import goldorion.farm_adventure.FarmAdventureIIElements;
import goldorion.farm_adventure.block.WaterStoneBlock;
import goldorion.farm_adventure.block.WaterStoneBricksBlock;
import goldorion.farm_adventure.item.WaterDimensionItem;
import goldorion.farm_adventure.procedures.WaterDimensionPlayerEntersDimensionProcedure;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IProperty;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.OverworldChunkGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.carver.CaveWorldCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IC0Transformer;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.common.extensions.IForgeDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@FarmAdventureIIElements.ModElement.Tag
public class WaterDimensionDimension
extends FarmAdventureIIElements.ModElement {
    @ObjectHolder(value="farm_adventure_ii:water_dimension")
    public static final ModDimension dimension = null;
    @ObjectHolder(value="farm_adventure_ii:water_dimension_portal")
    public static final CustomPortalBlock portal = null;
    public static DimensionType type = null;
    private static Biome[] dimensionBiomes;
    private static PointOfInterestType poi;

    public WaterDimensionDimension(FarmAdventureIIElements instance) {
        super(instance, 127);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @SubscribeEvent
    public void registerDimension(RegistryEvent.Register<ModDimension> event) {
        event.getRegistry().register(new CustomModDimension().setRegistryName("water_dimension"));
    }

    @SubscribeEvent
    public void onRegisterDimensionsEvent(RegisterDimensionsEvent event) {
        if (DimensionType.func_193417_a((ResourceLocation)new ResourceLocation("farm_adventure_ii:water_dimension")) == null) {
            DimensionManager.registerDimension((ResourceLocation)new ResourceLocation("farm_adventure_ii:water_dimension"), (ModDimension)dimension, null, (boolean)true);
        }
        type = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation("farm_adventure_ii:water_dimension"));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        dimensionBiomes = new Biome[]{(Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("ocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("frozen_ocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("frozen_river")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("beach")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("deep_ocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("stone_shore")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("snowy_beach")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("warm_ocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("lukewarm_ocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("cold_ocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("deep_warm_ocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("deep_lukewarm_ocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("deep_cold_ocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("deep_frozen_ocean")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("farm_adventure_ii:great_lakes"))};
    }

    @Override
    public void initElements() {
        this.elements.blocks.add(() -> new CustomPortalBlock());
        this.elements.items.add(() -> (Item)new WaterDimensionItem().setRegistryName("water_dimension"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientLoad(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)portal, (RenderType)RenderType.func_228645_f_());
    }

    @SubscribeEvent
    public void registerPointOfInterest(RegistryEvent.Register<PointOfInterestType> event) {
        try {
            Method method = ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_226359_a_", (Class[])new Class[]{String.class, Set.class, Integer.TYPE, Integer.TYPE});
            method.setAccessible(true);
            poi = (PointOfInterestType)method.invoke(null, "water_dimension_portal", Sets.newHashSet((Iterable)ImmutableSet.copyOf((Collection)portal.func_176194_O().func_177619_a())), 0, 1);
            event.getRegistry().register((IForgeRegistryEntry)poi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity entity = event.getPlayer();
        World world = entity.field_70170_p;
        int x = (int)entity.func_226277_ct_();
        int y = (int)entity.func_226278_cu_();
        int z = (int)entity.func_226281_cx_();
        if (event.getTo() == type) {
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", entity);
            WaterDimensionPlayerEntersDimensionProcedure.executeProcedure($_dependencies);
        }
    }

    static {
        poi = null;
    }

    public static class BiomeProviderCustom
    extends BiomeProvider {
        private Layer genBiomes;

        public BiomeProviderCustom(World world) {
            super(new HashSet<Biome>(Arrays.asList(dimensionBiomes)));
            this.genBiomes = this.getBiomeLayer(world.func_72905_C());
            for (final Biome biome : this.field_226837_c_) {
                biome.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)new CaveWorldCarver(ProbabilityConfig::func_214645_a, 256){
                    {
                        super(x0, x1);
                        this.field_222718_j = ImmutableSet.of((Object)WaterStoneBlock.block.func_176223_P().func_177230_c(), (Object)biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c(), (Object)biome.func_205401_q().func_215452_a().func_204109_b().func_177230_c());
                    }
                }, (ICarverConfig)new ProbabilityConfig(0.14285715f)));
            }
        }

        public Biome func_225526_b_(int x, int y, int z) {
            return this.genBiomes.func_215738_a(x, z);
        }

        private Layer getBiomeLayer(long seed) {
            LongFunction<IExtendedNoiseRandom> contextFactory = l -> new LazyAreaLayerContext(25, seed, l);
            IAreaFactory parentLayer = IslandLayer.INSTANCE.func_202823_a(contextFactory.apply(1L));
            IAreaFactory biomeLayer = new BiomeLayerCustom().func_202713_a(contextFactory.apply(200L), parentLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1000L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1001L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1002L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1003L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1004L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1005L), biomeLayer);
            return new Layer(biomeLayer);
        }
    }

    public static class BiomeLayerCustom
    implements IC0Transformer {
        public int func_202726_a(INoiseRandom context, int value) {
            return Registry.field_212624_m.func_148757_b((Object)dimensionBiomes[context.func_202696_a(dimensionBiomes.length)]);
        }
    }

    public static class ChunkProviderModded
    extends OverworldChunkGenerator {
        private static final int SEALEVEL = 63;

        public ChunkProviderModded(IWorld world, BiomeProvider provider) {
            super(world, provider, new OverworldGenSettings(){

                public BlockState func_205532_l() {
                    return WaterStoneBlock.block.func_176223_P();
                }

                public BlockState func_205533_m() {
                    return Blocks.field_150355_j.func_176223_P();
                }
            });
            this.field_222558_e.func_202423_a(5349);
        }

        public int func_222530_f() {
            return 63;
        }

        public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        }
    }

    public static class CustomDimension
    extends Dimension {
        private BiomeProviderCustom biomeProviderCustom = null;

        public CustomDimension(World world, DimensionType type) {
            super(world, type, 0.5f);
            this.field_76576_e = false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public Vec3d func_76562_b(float cangle, float ticks) {
            return new Vec3d(0.752941176471, 0.847058823529, 1.0);
        }

        public ChunkGenerator<?> func_186060_c() {
            if (this.biomeProviderCustom == null) {
                this.biomeProviderCustom = new BiomeProviderCustom(this.field_76579_a);
            }
            return new ChunkProviderModded((IWorld)this.field_76579_a, this.biomeProviderCustom);
        }

        public boolean func_76569_d() {
            return true;
        }

        public boolean func_76567_e() {
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_76568_b(int x, int z) {
            return false;
        }

        public IForgeDimension.SleepResult canSleepAt(PlayerEntity player, BlockPos pos) {
            return IForgeDimension.SleepResult.ALLOW;
        }

        @Nullable
        public BlockPos func_206920_a(ChunkPos chunkPos, boolean checkValid) {
            return null;
        }

        @Nullable
        public BlockPos func_206921_a(int x, int z, boolean checkValid) {
            return null;
        }

        public boolean func_177500_n() {
            return false;
        }

        public float func_76563_a(long worldTime, float partialTicks) {
            double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
            double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
            return (float)(d0 * 2.0 + d1) / 3.0f;
        }
    }

    public static class CustomModDimension
    extends ModDimension {
        public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
            return CustomDimension::new;
        }
    }

    public static class TeleporterDimensionMod
    extends Teleporter {
        private Vec3d lastPortalVec;
        private Direction teleportDirection;
        protected final ServerWorld field_85192_a;
        protected final Random field_77187_a;

        public TeleporterDimensionMod(ServerWorld worldServer, Vec3d lastPortalVec, Direction teleportDirection) {
            super(worldServer);
            this.field_85192_a = worldServer;
            this.field_77187_a = new Random(worldServer.func_72905_C());
            this.lastPortalVec = lastPortalVec;
            this.teleportDirection = teleportDirection;
        }

        public boolean func_85188_a(Entity entityIn) {
            int i = 16;
            double d0 = -1.0;
            int j = MathHelper.func_76128_c((double)entityIn.func_226277_ct_());
            int k = MathHelper.func_76128_c((double)entityIn.func_226278_cu_());
            int l = MathHelper.func_76128_c((double)entityIn.func_226281_cx_());
            int i1 = j;
            int j1 = k;
            int k1 = l;
            int l1 = 0;
            int i2 = this.field_77187_a.nextInt(4);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (int j2 = j - 16; j2 <= j + 16; ++j2) {
                double d1 = (double)j2 + 0.5 - entityIn.func_226277_ct_();
                for (int l2 = l - 16; l2 <= l + 16; ++l2) {
                    double d2 = (double)l2 + 0.5 - entityIn.func_226281_cx_();
                    block2: for (int j3 = this.field_85192_a.func_72940_L() - 1; j3 >= 0; --j3) {
                        if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutable.func_181079_c(j2, j3, l2))) continue;
                        while (j3 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutable.func_181079_c(j2, j3 - 1, l2))) {
                            --j3;
                        }
                        for (int k3 = i2; k3 < i2 + 4; ++k3) {
                            int l3 = k3 % 2;
                            int i4 = 1 - l3;
                            if (k3 % 4 >= 2) {
                                l3 = -l3;
                                i4 = -i4;
                            }
                            for (int j4 = 0; j4 < 3; ++j4) {
                                for (int k4 = 0; k4 < 4; ++k4) {
                                    for (int l4 = -1; l4 < 4; ++l4) {
                                        int i5 = j2 + (k4 - 1) * l3 + j4 * i4;
                                        int j5 = j3 + l4;
                                        int k5 = l2 + (k4 - 1) * i4 - j4 * l3;
                                        blockpos$mutable.func_181079_c(i5, j5, k5);
                                        if (l4 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76220_a() || l4 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutable)) continue block2;
                                    }
                                }
                            }
                            double d5 = (double)j3 + 0.5 - entityIn.func_226278_cu_();
                            double d7 = d1 * d1 + d5 * d5 + d2 * d2;
                            if (!(d0 < 0.0) && !(d7 < d0)) continue;
                            d0 = d7;
                            i1 = j2;
                            j1 = j3;
                            k1 = l2;
                            l1 = k3 % 4;
                        }
                    }
                }
            }
            if (d0 < 0.0) {
                for (int l5 = j - 16; l5 <= j + 16; ++l5) {
                    double d3 = (double)l5 + 0.5 - entityIn.func_226277_ct_();
                    for (int j6 = l - 16; j6 <= l + 16; ++j6) {
                        double d4 = (double)j6 + 0.5 - entityIn.func_226281_cx_();
                        block10: for (int i7 = this.field_85192_a.func_72940_L() - 1; i7 >= 0; --i7) {
                            if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutable.func_181079_c(l5, i7, j6))) continue;
                            while (i7 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutable.func_181079_c(l5, i7 - 1, j6))) {
                                --i7;
                            }
                            for (int l7 = i2; l7 < i2 + 2; ++l7) {
                                int l8 = l7 % 2;
                                int k9 = 1 - l8;
                                for (int i10 = 0; i10 < 4; ++i10) {
                                    for (int k10 = -1; k10 < 4; ++k10) {
                                        int i11 = l5 + (i10 - 1) * l8;
                                        int j11 = i7 + k10;
                                        int k11 = j6 + (i10 - 1) * k9;
                                        blockpos$mutable.func_181079_c(i11, j11, k11);
                                        if (k10 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76220_a() || k10 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutable)) continue block10;
                                    }
                                }
                                double d6 = (double)i7 + 0.5 - entityIn.func_226278_cu_();
                                double d8 = d3 * d3 + d6 * d6 + d4 * d4;
                                if (!(d0 < 0.0) && !(d8 < d0)) continue;
                                d0 = d8;
                                i1 = l5;
                                j1 = i7;
                                k1 = j6;
                                l1 = l7 % 2;
                            }
                        }
                    }
                }
            }
            int i6 = i1;
            int k2 = j1;
            int k6 = k1;
            int l6 = l1 % 2;
            int i3 = 1 - l6;
            if (l1 % 4 >= 2) {
                l6 = -l6;
                i3 = -i3;
            }
            if (d0 < 0.0) {
                k2 = j1 = MathHelper.func_76125_a((int)j1, (int)70, (int)(this.field_85192_a.func_72940_L() - 10));
                for (int j7 = -1; j7 <= 1; ++j7) {
                    for (int i8 = 1; i8 < 3; ++i8) {
                        for (int i9 = -1; i9 < 3; ++i9) {
                            int l9 = i6 + (i8 - 1) * l6 + j7 * i3;
                            int j10 = k2 + i9;
                            int l10 = k6 + (i8 - 1) * i3 - j7 * l6;
                            boolean flag = i9 < 0;
                            blockpos$mutable.func_181079_c(l9, j10, l10);
                            this.field_85192_a.func_175656_a((BlockPos)blockpos$mutable, flag ? WaterStoneBricksBlock.block.func_176223_P().func_177230_c().func_176223_P() : Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
            }
            for (int k7 = -1; k7 < 3; ++k7) {
                for (int j8 = -1; j8 < 4; ++j8) {
                    if (k7 != -1 && k7 != 2 && j8 != -1 && j8 != 3) continue;
                    blockpos$mutable.func_181079_c(i6 + k7 * l6, k2 + j8, k6 + k7 * i3);
                    this.field_85192_a.func_180501_a((BlockPos)blockpos$mutable, WaterStoneBricksBlock.block.func_176223_P().func_177230_c().func_176223_P(), 3);
                }
            }
            BlockState blockstate = (BlockState)portal.func_176223_P().func_206870_a((IProperty)NetherPortalBlock.field_176550_a, (Comparable)(l6 == 0 ? Direction.Axis.Z : Direction.Axis.X));
            for (int k8 = 0; k8 < 2; ++k8) {
                for (int j9 = 0; j9 < 3; ++j9) {
                    blockpos$mutable.func_181079_c(i6 + k8 * l6, k2 + j9, k6 + k8 * i3);
                    this.field_85192_a.func_180501_a((BlockPos)blockpos$mutable, blockstate, 18);
                }
            }
            return true;
        }

        @Nullable
        public BlockPattern.PortalInfo func_222272_a(BlockPos p_222272_1_, Vec3d p_222272_2_, Direction directionIn, double p_222272_4_, double p_222272_6_, boolean p_222272_8_) {
            PointOfInterestManager pointofinterestmanager = this.field_85192_a.func_217443_B();
            pointofinterestmanager.func_226347_a_((IWorldReader)this.field_85192_a, p_222272_1_, 128);
            List list = pointofinterestmanager.func_226353_b_(p_226705_0_ -> p_226705_0_ == poi, p_222272_1_, 128, PointOfInterestManager.Status.ANY).collect(Collectors.toList());
            Optional<PointOfInterest> optional = list.stream().min(Comparator.comparingDouble(p_226706_1_ -> p_226706_1_.func_218261_f().func_177951_i((Vec3i)p_222272_1_)).thenComparingInt(p_226704_0_ -> p_226704_0_.func_218261_f().func_177956_o()));
            return optional.map(p_226707_7_ -> {
                BlockPos blockpos = p_226707_7_.func_218261_f();
                this.field_85192_a.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(blockpos), 3, (Object)blockpos);
                BlockPattern.PatternHelper blockpattern$patternhelper = CustomPortalBlock.createPatternHelper((IWorld)this.field_85192_a, blockpos);
                return blockpattern$patternhelper.func_222504_a(directionIn, blockpos, p_222272_6_, p_222272_2_, p_222272_4_);
            }).orElse(null);
        }

        public boolean func_222268_a(Entity p_222268_1_, float p_222268_2_) {
            Vec3d vec3d = this.lastPortalVec;
            Direction direction = this.teleportDirection;
            BlockPattern.PortalInfo blockpattern$portalinfo = this.func_222272_a(new BlockPos(p_222268_1_), p_222268_1_.func_213322_ci(), direction, vec3d.field_72450_a, vec3d.field_72448_b, p_222268_1_ instanceof PlayerEntity);
            if (blockpattern$portalinfo == null) {
                return false;
            }
            Vec3d vec3d1 = blockpattern$portalinfo.field_222505_a;
            Vec3d vec3d2 = blockpattern$portalinfo.field_222506_b;
            p_222268_1_.func_213317_d(vec3d2);
            p_222268_1_.field_70177_z = p_222268_2_ + (float)blockpattern$portalinfo.field_222507_c;
            p_222268_1_.func_225653_b_(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c);
            return true;
        }
    }

    public static class CustomPortalBlock
    extends NetherPortalBlock {
        public CustomPortalBlock() {
            super(Block.Properties.func_200945_a((Material)Material.field_151567_E).func_200942_a().func_200944_c().func_200943_b(-1.0f).func_200947_a(SoundType.field_185853_f).func_200951_a(0).func_222380_e());
            this.setRegistryName("water_dimension_portal");
        }

        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        }

        public void portalSpawn(World world, BlockPos pos) {
            Size portalsize = this.isValid((IWorld)world, pos);
            if (portalsize != null) {
                portalsize.placePortalBlocks();
            }
        }

        @Nullable
        public Size isValid(IWorld worldIn, BlockPos pos) {
            Size netherportalblock$size = new Size(worldIn, pos, Direction.Axis.X);
            if (netherportalblock$size.isValid() && netherportalblock$size.portalBlockCount == 0) {
                return netherportalblock$size;
            }
            Size netherportalblock$size1 = new Size(worldIn, pos, Direction.Axis.Z);
            return netherportalblock$size1.isValid() && netherportalblock$size1.portalBlockCount == 0 ? netherportalblock$size1 : null;
        }

        public static BlockPattern.PatternHelper createPatternHelper(IWorld p_181089_0_, BlockPos worldIn) {
            Direction.Axis direction$axis = Direction.Axis.Z;
            Size netherportalblock$size = new Size(p_181089_0_, worldIn, Direction.Axis.X);
            LoadingCache loadingcache = BlockPattern.func_181627_a((IWorldReader)p_181089_0_, (boolean)true);
            if (!netherportalblock$size.isValid()) {
                direction$axis = Direction.Axis.X;
                netherportalblock$size = new Size(p_181089_0_, worldIn, Direction.Axis.Z);
            }
            if (!netherportalblock$size.isValid()) {
                return new BlockPattern.PatternHelper(worldIn, Direction.NORTH, Direction.UP, loadingcache, 1, 1, 1);
            }
            int[] aint = new int[Direction.AxisDirection.values().length];
            Direction direction = netherportalblock$size.rightDir.func_176735_f();
            BlockPos blockpos = netherportalblock$size.bottomLeft.func_177981_b(netherportalblock$size.getHeight() - 1);
            for (Direction.AxisDirection direction$axisdirection : Direction.AxisDirection.values()) {
                BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection ? blockpos : blockpos.func_177967_a(netherportalblock$size.rightDir, netherportalblock$size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)direction$axisdirection, (Direction.Axis)direction$axis), Direction.UP, loadingcache, netherportalblock$size.getWidth(), netherportalblock$size.getHeight(), 1);
                for (int i = 0; i < netherportalblock$size.getWidth(); ++i) {
                    for (int j = 0; j < netherportalblock$size.getHeight(); ++j) {
                        CachedBlockInfo cachedblockinfo = blockpattern$patternhelper.func_177670_a(i, j, 1);
                        if (cachedblockinfo.func_177509_a().func_196958_f()) continue;
                        int n = direction$axisdirection.ordinal();
                        aint[n] = aint[n] + 1;
                    }
                }
            }
            Direction.AxisDirection direction$axisdirection1 = Direction.AxisDirection.POSITIVE;
            for (Direction.AxisDirection direction$axisdirection2 : Direction.AxisDirection.values()) {
                if (aint[direction$axisdirection2.ordinal()] >= aint[direction$axisdirection1.ordinal()]) continue;
                direction$axisdirection1 = direction$axisdirection2;
            }
            return new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection1 ? blockpos : blockpos.func_177967_a(netherportalblock$size.rightDir, netherportalblock$size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)direction$axisdirection1, (Direction.Axis)direction$axis), Direction.UP, loadingcache, netherportalblock$size.getWidth(), netherportalblock$size.getHeight(), 1);
        }

        public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
            Direction.Axis direction$axis = facing.func_176740_k();
            Direction.Axis direction$axis1 = (Direction.Axis)stateIn.func_177229_b((IProperty)field_176550_a);
            boolean flag = direction$axis1 != direction$axis && direction$axis.func_176722_c();
            return !flag && facingState.func_177230_c() != this && !new Size(worldIn, currentPos, direction$axis1).func_208508_f() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
            for (int i = 0; i < 4; ++i) {
                double px = (float)pos.func_177958_n() + random.nextFloat();
                double py = (float)pos.func_177956_o() + random.nextFloat();
                double pz = (float)pos.func_177952_p() + random.nextFloat();
                double vx = ((double)random.nextFloat() - 0.5) / 2.0;
                double vy = ((double)random.nextFloat() - 0.5) / 2.0;
                double vz = ((double)random.nextFloat() - 0.5) / 2.0;
                int j = random.nextInt(4) - 1;
                if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                    px = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                    vx = random.nextFloat() * 2.0f * (float)j;
                } else {
                    pz = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                    vz = random.nextFloat() * 2.0f * (float)j;
                }
                world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, px, py, pz, vx, vy, vz);
            }
            if (random.nextInt(110) == 0) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.portal.ambient")), SoundCategory.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
            }
        }

        public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
            if (!world.field_72995_K && !entity.func_184218_aH() && !entity.func_184207_aI() && entity instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                if (player.field_71088_bW > 0) {
                    player.field_71088_bW = 10;
                } else if (player.field_71093_bK != type) {
                    player.field_71088_bW = 10;
                    this.teleportToDimension(player, type);
                } else {
                    player.field_71088_bW = 10;
                    this.teleportToDimension(player, DimensionType.field_223227_a_);
                }
            }
        }

        private void teleportToDimension(ServerPlayerEntity player, DimensionType destinationType) {
            ObfuscationReflectionHelper.setPrivateValue(ServerPlayerEntity.class, (Object)player, (Object)true, (String)"field_184851_cj");
            ServerWorld nextWorld = player.func_184102_h().func_71218_a(destinationType);
            TeleporterDimensionMod teleporter = this.getTeleporterForDimension((Entity)player, player.func_180425_c(), nextWorld);
            player.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(4, 0.0f));
            if (!teleporter.func_222268_a((Entity)player, player.field_70177_z)) {
                teleporter.func_85188_a((Entity)player);
                teleporter.func_222268_a((Entity)player, player.field_70177_z);
            }
            player.func_200619_a(nextWorld, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), player.field_70177_z, player.field_70125_A);
            player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            for (EffectInstance effectinstance : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), effectinstance));
            }
            player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        }

        private TeleporterDimensionMod getTeleporterForDimension(Entity entity, BlockPos pos, ServerWorld nextWorld) {
            BlockPattern.PatternHelper bph = CustomPortalBlock.createPatternHelper((IWorld)entity.field_70170_p, new BlockPos((Vec3i)pos));
            double d0 = bph.func_177669_b().func_176740_k() == Direction.Axis.X ? (double)bph.func_181117_a().func_177952_p() : (double)bph.func_181117_a().func_177958_n();
            double d1 = bph.func_177669_b().func_176740_k() == Direction.Axis.X ? entity.func_226281_cx_() : entity.func_226277_ct_();
            d1 = Math.abs(MathHelper.func_181160_c((double)(d1 - (double)(bph.func_177669_b().func_176746_e().func_176743_c() == Direction.AxisDirection.NEGATIVE ? 1 : 0)), (double)d0, (double)(d0 - (double)bph.func_181118_d())));
            double d2 = MathHelper.func_181160_c((double)(entity.func_226278_cu_() - 1.0), (double)bph.func_181117_a().func_177956_o(), (double)(bph.func_181117_a().func_177956_o() - bph.func_181119_e()));
            return new TeleporterDimensionMod(nextWorld, new Vec3d(d1, d2, 0.0), bph.func_177669_b());
        }

        public static class Size {
            private final IWorld world;
            private final Direction.Axis axis;
            private final Direction rightDir;
            private final Direction leftDir;
            private int portalBlockCount;
            @Nullable
            private BlockPos bottomLeft;
            private int height;
            private int width;

            public Size(IWorld worldIn, BlockPos pos, Direction.Axis axisIn) {
                this.world = worldIn;
                this.axis = axisIn;
                if (axisIn == Direction.Axis.X) {
                    this.leftDir = Direction.EAST;
                    this.rightDir = Direction.WEST;
                } else {
                    this.leftDir = Direction.NORTH;
                    this.rightDir = Direction.SOUTH;
                }
                BlockPos blockpos = pos;
                while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.func_196900_a(worldIn.func_180495_p(pos.func_177977_b()))) {
                    pos = pos.func_177977_b();
                }
                int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
                if (i >= 0) {
                    this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                    this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                    if (this.width < 2 || this.width > 21) {
                        this.bottomLeft = null;
                        this.width = 0;
                    }
                }
                if (this.bottomLeft != null) {
                    this.height = this.calculatePortalHeight();
                }
            }

            protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
                BlockPos blockpos;
                int i;
                for (i = 0; i < 22 && this.func_196900_a(this.world.func_180495_p(blockpos = pos.func_177967_a(directionIn, i))) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == WaterStoneBricksBlock.block.func_176223_P().func_177230_c(); ++i) {
                }
                BlockPos framePos = pos.func_177967_a(directionIn, i);
                return this.world.func_180495_p(framePos).func_177230_c() == WaterStoneBricksBlock.block.func_176223_P().func_177230_c() ? i : 0;
            }

            public int getHeight() {
                return this.height;
            }

            public int getWidth() {
                return this.width;
            }

            protected int calculatePortalHeight() {
                this.height = 0;
                block0: while (this.height < 21) {
                    for (int i = 0; i < this.width; ++i) {
                        BlockPos framePos;
                        BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                        BlockState blockstate = this.world.func_180495_p(blockpos);
                        if (!this.func_196900_a(blockstate)) break block0;
                        Block block = blockstate.func_177230_c();
                        if (block == portal) {
                            ++this.portalBlockCount;
                        }
                        if (i == 0 ? this.world.func_180495_p(framePos = blockpos.func_177972_a(this.leftDir)).func_177230_c() != WaterStoneBricksBlock.block.func_176223_P().func_177230_c() : i == this.width - 1 && this.world.func_180495_p(framePos = blockpos.func_177972_a(this.rightDir)).func_177230_c() != WaterStoneBricksBlock.block.func_176223_P().func_177230_c()) break block0;
                    }
                    ++this.height;
                }
                for (int j = 0; j < this.width; ++j) {
                    BlockPos framePos = this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height);
                    if (this.world.func_180495_p(framePos).func_177230_c() == WaterStoneBricksBlock.block.func_176223_P().func_177230_c()) continue;
                    this.height = 0;
                    break;
                }
                if (this.height <= 21 && this.height >= 3) {
                    return this.height;
                }
                this.bottomLeft = null;
                this.width = 0;
                this.height = 0;
                return 0;
            }

            protected boolean func_196900_a(BlockState pos) {
                Block block = pos.func_177230_c();
                return pos.func_196958_f() || block == Blocks.field_150480_ab || block == portal;
            }

            public boolean isValid() {
                return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
            }

            public void placePortalBlocks() {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                    for (int j = 0; j < this.height; ++j) {
                        this.world.func_180501_a(blockpos.func_177981_b(j), (BlockState)portal.func_176223_P().func_206870_a((IProperty)NetherPortalBlock.field_176550_a, (Comparable)this.axis), 18);
                    }
                }
            }

            private boolean func_196899_f() {
                return this.portalBlockCount >= this.width * this.height;
            }

            public boolean func_208508_f() {
                return this.isValid() && this.func_196899_f();
            }
        }
    }
}

