/*
 * Decompiled with CFR 0.152.
 */
package tk.dczippl.lightestlamp.machine.gasextractor;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IInteractionObject;
import tk.dczippl.lightestlamp.Reference;
import tk.dczippl.lightestlamp.machine.gasextractor.GasExtractorBlock;
import tk.dczippl.lightestlamp.machine.gasextractor.GasExtractorContainer;
import tk.dczippl.lightestlamp.machine.gasextractor.GasExtractorRecipes;

public class GasExtractorTileEntity
extends TileEntityLockable
implements ITickable,
ISidedInventory,
IInteractionObject {
    protected static final int[] slotsTop = new int[]{slotEnum.INPUT_SLOT.ordinal()};
    protected static final int[] slotsBottom = new int[]{slotEnum.CATALYST_SLOT.ordinal()};
    protected static final int[] slotsSides = new int[]{slotEnum.OUTPUT_SLOT.ordinal()};
    protected NonNullList<ItemStack> extractorItemStacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    protected boolean hasBeenCompacting = false;
    protected int timeCanCompact;
    protected int currentItemCompactTime;
    protected int ticksCompactingItemSoFar;
    protected int ticksPerItem;
    protected int argon;
    protected int krypton;
    protected int redstone;
    protected String extractorCustomName;

    public GasExtractorTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public GasExtractorTileEntity() {
        super(Reference.EXTRACTOR_TE);
    }

    public int[] func_180463_a(EnumFacing enumFacing) {
        return new int[0];
    }

    public boolean func_180462_a(int i, ItemStack itemStack, @Nullable EnumFacing enumFacing) {
        return true;
    }

    public boolean func_180461_b(int i, ItemStack itemStack, EnumFacing enumFacing) {
        return true;
    }

    public int func_70302_i_() {
        return this.extractorItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.extractorItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.extractorItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.extractorItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.extractorItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        System.out.println("TileEntityLabTable setInventorySlotContents()");
        boolean isSameItemStackAlreadyInSlot = !stack.func_190926_b() && stack.func_77969_a((ItemStack)this.extractorItemStacks.get(index)) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)this.extractorItemStacks.get(index)));
        this.extractorItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == slotEnum.INPUT_SLOT.ordinal() && !isSameItemStackAlreadyInSlot) {
            this.startCompacting();
        }
        this.func_70296_d();
    }

    protected void startCompacting() {
        this.ticksCompactingItemSoFar = 0;
        this.ticksPerItem = this.timeToCompactOneItem((ItemStack)this.extractorItemStacks.get(slotEnum.INPUT_SLOT.ordinal()));
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentString(this.func_145818_k_() ? this.extractorCustomName : "container.analyzer");
    }

    public boolean func_145818_k_() {
        return this.extractorCustomName != null && this.extractorCustomName.length() > 0;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TextComponentString(this.func_145818_k_() ? this.extractorCustomName : "container.analyzer");
    }

    public void setCustomInventoryName(String parCustomName) {
        this.extractorCustomName = parCustomName;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.extractorItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.extractorItemStacks);
        this.timeCanCompact = compound.func_74765_d("CompactTime");
        this.ticksCompactingItemSoFar = compound.func_74765_d("CookTime");
        this.ticksPerItem = compound.func_74765_d("CookTimeTotal");
        this.argon = compound.func_74765_d("Argon");
        if (compound.func_74764_b("CustomName")) {
            this.extractorCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("CompactTime", (short)this.timeCanCompact);
        compound.func_74777_a("CookTime", (short)this.ticksCompactingItemSoFar);
        compound.func_74777_a("CookTimeTotal", (short)this.ticksPerItem);
        compound.func_74777_a("Argon", (short)this.argon);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.extractorItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.extractorCustomName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    protected void compactingStateChanged(boolean parHasBeenCompacting) {
        this.hasBeenCompacting = true;
        GasExtractorBlock.changeBlockBasedOnCompactingStatus(this.canCompact(), this.field_145850_b, this.field_174879_c);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!((ItemStack)this.extractorItemStacks.get(slotEnum.INPUT_SLOT.ordinal())).func_190926_b()) {
                if (this.canCompact()) {
                    if (!this.hasBeenCompacting) {
                        this.compactingStateChanged(true);
                        this.startCompacting();
                    } else {
                        ++this.ticksCompactingItemSoFar;
                        if (this.ticksCompactingItemSoFar >= this.ticksPerItem) {
                            this.startCompacting();
                            this.compactItem();
                        }
                    }
                } else {
                    if (this.hasBeenCompacting) {
                        this.compactingStateChanged(false);
                    }
                    this.ticksCompactingItemSoFar = 0;
                }
            } else {
                if (this.hasBeenCompacting) {
                    this.compactingStateChanged(false);
                }
                this.ticksCompactingItemSoFar = 0;
            }
        }
    }

    public int timeToCompactOneItem(ItemStack parItemStack) {
        return 40;
    }

    private boolean canCompact() {
        if (this.func_174887_a_(5) == 1 && this.field_145850_b.func_175651_c(this.field_174879_c, EnumFacing.UP) > 0) {
            return false;
        }
        if (this.func_174887_a_(5) == 2 && this.field_145850_b.func_175651_c(this.field_174879_c, EnumFacing.UP) < 1) {
            return false;
        }
        ItemStack stackInOutputSlot = (ItemStack)this.extractorItemStacks.get(slotEnum.OUTPUT_SLOT.ordinal());
        ItemStack stackInInputSlot = (ItemStack)this.extractorItemStacks.get(slotEnum.INPUT_SLOT.ordinal());
        ItemStack stackInCatalystSlot = (ItemStack)this.extractorItemStacks.get(slotEnum.CATALYST_SLOT.ordinal());
        if (stackInInputSlot.func_190926_b()) {
            return false;
        }
        ItemStack itemStackToOutput = GasExtractorRecipes.instance().getResult(stackInInputSlot, stackInCatalystSlot);
        if (itemStackToOutput.func_190926_b()) {
            return false;
        }
        if (stackInOutputSlot.func_190926_b()) {
            if (stackInInputSlot.func_190916_E() >= GasExtractorRecipes.instance().getInputsAmount(stackInInputSlot, stackInCatalystSlot)[0]) {
                return stackInInputSlot.func_190916_E() >= GasExtractorRecipes.instance().getInputsAmount(stackInInputSlot, stackInCatalystSlot)[1];
            }
            return false;
        }
        if (!stackInOutputSlot.func_77969_a(itemStackToOutput)) {
            return false;
        }
        int result = stackInOutputSlot.func_190916_E() + itemStackToOutput.func_190916_E();
        if (result <= this.func_70297_j_() && result <= stackInOutputSlot.func_77976_d()) {
            if (stackInInputSlot.func_190916_E() >= GasExtractorRecipes.instance().getInputsAmount(stackInInputSlot, stackInCatalystSlot)[0]) {
                return stackInInputSlot.func_190916_E() >= GasExtractorRecipes.instance().getInputsAmount(stackInInputSlot, stackInCatalystSlot)[1];
            }
            return false;
        }
        return false;
    }

    public void compactItem() {
        if (this.canCompact()) {
            Random rand = new Random();
            ItemStack itemstack = GasExtractorRecipes.instance().getResult((ItemStack)this.extractorItemStacks.get(slotEnum.INPUT_SLOT.ordinal()), (ItemStack)this.extractorItemStacks.get(slotEnum.CATALYST_SLOT.ordinal()));
            ItemStack extra_itemstack = GasExtractorRecipes.instance().getExtraResult((ItemStack)this.extractorItemStacks.get(slotEnum.INPUT_SLOT.ordinal()), (ItemStack)this.extractorItemStacks.get(slotEnum.CATALYST_SLOT.ordinal()));
            ++this.argon;
            ++this.krypton;
            if (this.extractorItemStacks.get(slotEnum.OUTPUT_SLOT.ordinal()) == ItemStack.field_190927_a) {
                this.extractorItemStacks.set(slotEnum.OUTPUT_SLOT.ordinal(), (Object)itemstack.func_77946_l());
            } else if (((ItemStack)this.extractorItemStacks.get(slotEnum.OUTPUT_SLOT.ordinal())).func_77973_b() == itemstack.func_77973_b()) {
                ((ItemStack)this.extractorItemStacks.get(slotEnum.OUTPUT_SLOT.ordinal())).func_190920_e(((ItemStack)this.extractorItemStacks.get(slotEnum.OUTPUT_SLOT.ordinal())).func_190916_E() + itemstack.func_190916_E());
            }
            if (this.argon >= 20) {
                if (this.extractorItemStacks.get(slotEnum.EXTRA_OUTPUT_SLOT.ordinal()) == ItemStack.field_190927_a) {
                    this.extractorItemStacks.set(slotEnum.EXTRA_OUTPUT_SLOT.ordinal(), (Object)extra_itemstack.func_77946_l());
                    this.argon = 0;
                } else if (((ItemStack)this.extractorItemStacks.get(slotEnum.EXTRA_OUTPUT_SLOT.ordinal())).func_77973_b() == extra_itemstack.func_77973_b()) {
                    ((ItemStack)this.extractorItemStacks.get(slotEnum.EXTRA_OUTPUT_SLOT.ordinal())).func_190920_e(((ItemStack)this.extractorItemStacks.get(slotEnum.EXTRA_OUTPUT_SLOT.ordinal())).func_190916_E() + extra_itemstack.func_190916_E());
                    this.argon = 0;
                }
            }
            if (this.krypton >= 120) {
                this.krypton = 100;
            }
            ItemStack tempItemStack = ((ItemStack)this.extractorItemStacks.get(slotEnum.INPUT_SLOT.ordinal())).func_77946_l();
            try {
                if (rand.nextInt(2) == 1) {
                    ((ItemStack)this.extractorItemStacks.get(slotEnum.INPUT_SLOT.ordinal())).func_190920_e(((ItemStack)this.extractorItemStacks.get(slotEnum.INPUT_SLOT.ordinal())).func_190916_E() - GasExtractorRecipes.instance().getInputsAmount((ItemStack)this.extractorItemStacks.get(slotEnum.INPUT_SLOT.ordinal()), (ItemStack)this.extractorItemStacks.get(slotEnum.CATALYST_SLOT.ordinal()))[0]);
                }
                ((ItemStack)this.extractorItemStacks.get(slotEnum.CATALYST_SLOT.ordinal())).func_190920_e(((ItemStack)this.extractorItemStacks.get(slotEnum.CATALYST_SLOT.ordinal())).func_190916_E() - GasExtractorRecipes.instance().getInputsAmount((ItemStack)this.extractorItemStacks.get(slotEnum.INPUT_SLOT.ordinal()), (ItemStack)this.extractorItemStacks.get(slotEnum.CATALYST_SLOT.ordinal()))[0]);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (((ItemStack)this.extractorItemStacks.get(slotEnum.INPUT_SLOT.ordinal())).func_190916_E() <= 0) {
                this.extractorItemStacks.set(slotEnum.INPUT_SLOT.ordinal(), (Object)ItemStack.field_190927_a);
            }
            if (((ItemStack)this.extractorItemStacks.get(slotEnum.CATALYST_SLOT.ordinal())).func_190916_E() <= 0) {
                this.extractorItemStacks.set(slotEnum.CATALYST_SLOT.ordinal(), (Object)ItemStack.field_190927_a);
            }
        }
    }

    public void func_174889_b(EntityPlayer playerIn) {
    }

    public void func_174886_c(EntityPlayer playerIn) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == slotEnum.INPUT_SLOT.ordinal();
    }

    public String func_174875_k() {
        return "lightestlamp:analyzer";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        System.out.println("TileEntityLabTable createContainer()");
        return new GasExtractorContainer(playerInventory, this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.timeCanCompact;
            }
            case 1: {
                return this.currentItemCompactTime;
            }
            case 2: {
                return this.ticksCompactingItemSoFar;
            }
            case 3: {
                return this.ticksPerItem;
            }
            case 4: {
                return this.argon;
            }
            case 5: {
                return this.redstone;
            }
            case 6: {
                return this.krypton;
            }
        }
        return 10;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.timeCanCompact = value;
                break;
            }
            case 1: {
                this.currentItemCompactTime = value;
                break;
            }
            case 2: {
                this.ticksCompactingItemSoFar = value;
                break;
            }
            case 3: {
                this.ticksPerItem = value;
                break;
            }
            case 4: {
                this.argon = value;
                break;
            }
            case 5: {
                this.redstone = value;
                break;
            }
            case 6: {
                this.krypton = value;
                break;
            }
        }
    }

    public int func_174890_g() {
        return 7;
    }

    public void func_174888_l() {
        this.extractorItemStacks.clear();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public static enum redstoneEnum {
        IGNORE,
        REDSTONE_OFF,
        REDSTONE_ON;

    }

    public static enum slotEnum {
        INPUT_SLOT,
        CATALYST_SLOT,
        OUTPUT_SLOT,
        EXTRA_OUTPUT_SLOT;

    }
}

