/*
 * Decompiled with CFR 0.152.
 */
package tk.dczippl.lightestlamp.machine.gascentrifuge;

import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import tk.dczippl.lightestlamp.Config;
import tk.dczippl.lightestlamp.init.ModContainers;
import tk.dczippl.lightestlamp.init.ModEffect;
import tk.dczippl.lightestlamp.init.ModFluids;
import tk.dczippl.lightestlamp.init.ModTileEntities;
import tk.dczippl.lightestlamp.items.FilterItem;
import tk.dczippl.lightestlamp.machine.gascentrifuge.GasCentrifugeContainer;
import tk.dczippl.lightestlamp.machine.gascentrifuge.GasCentrifugeRecipe;
import tk.dczippl.lightestlamp.util.FluidHandlerWrapper;
import tk.dczippl.lightestlamp.util.IFluidHandlerWrapper;
import tk.dczippl.lightestlamp.util.TheoreticalFluid;

public class GasCentrifugeTile
extends LockableTileEntity
implements ISidedInventory,
ITickableTileEntity,
IFluidHandlerWrapper {
    public FluidTank tank = new FluidTank(4000);
    private static final int[] SLOTS_UP = new int[]{0, 1};
    private static final int[] SLOTS_DOWN = new int[]{2, 3, 4, 5};
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private int ticksBeforeDumping;
    private int burnTime;
    private int fluid;
    private int cookTime;
    private int cookTimeTotal;
    private int redstoneMode;
    private int liquidMode;
    public final IIntArray furnaceData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return GasCentrifugeTile.this.burnTime;
                }
                case 1: {
                    return GasCentrifugeTile.this.redstoneMode;
                }
                case 2: {
                    return GasCentrifugeTile.this.cookTime;
                }
                case 3: {
                    return GasCentrifugeTile.this.cookTimeTotal;
                }
                case 4: {
                    return GasCentrifugeTile.this.liquidMode;
                }
                case 5: {
                    return GasCentrifugeTile.this.tank.getFluidAmount();
                }
                case 6: {
                    return GasCentrifugeTile.this.ticksBeforeDumping;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    GasCentrifugeTile.this.burnTime = value;
                    break;
                }
                case 1: {
                    GasCentrifugeTile.this.redstoneMode = value;
                    break;
                }
                case 2: {
                    GasCentrifugeTile.this.cookTime = value;
                    break;
                }
                case 3: {
                    GasCentrifugeTile.this.cookTimeTotal = value;
                    break;
                }
                case 4: {
                    GasCentrifugeTile.this.liquidMode = value;
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    GasCentrifugeTile.this.ticksBeforeDumping = value;
                }
            }
        }

        public int func_221478_a() {
            return 7;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public GasCentrifugeTile(TileEntityType type) {
        super(type);
    }

    public GasCentrifugeTile() {
        super(ModTileEntities.CENTRIFUGE_TE);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.gascentrifuge", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer((int)8, (int)8));
        buffer.func_179255_a(this.field_174879_c);
        return new GasCentrifugeContainer(ModContainers.GAS_CENTRIFUGE, id, player, (IInventory)this, this.furnaceData, buffer);
    }

    public void setRedstoneMode(int redstoneMode) {
        this.furnaceData.func_221477_a(1, redstoneMode);
    }

    public int getRedstoneMode() {
        return this.furnaceData.func_221476_a(1);
    }

    public void setLiquidMode(int liquidMode) {
        this.furnaceData.func_221477_a(4, liquidMode);
    }

    public int getLiquidMode() {
        return this.furnaceData.func_221476_a(4);
    }

    public void startTicksBeforeDumping() {
        this.furnaceData.func_221477_a(6, 60);
    }

    public static Map<Item, Integer> getBurnTimes() {
        Tag glowstone_blocks;
        Tag refined_glowstones_nugget;
        Tag refined_glowstones_block;
        LinkedHashMap map = Maps.newLinkedHashMap();
        int multiplier = (Integer)Config.GLOWSTONE_FUEL_MULTIPLIER.get() >= 2 ? (Integer)Config.GLOWSTONE_FUEL_MULTIPLIER.get() : 2;
        Tag refined_glowstones = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("forge:ingots/refined_glowstone"));
        if (refined_glowstones != null) {
            GasCentrifugeTile.addItemTagBurnTime(map, (Tag<Item>)refined_glowstones, 60 * multiplier);
        }
        if ((refined_glowstones_block = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("forge:storage_blocks/refined_glowstone"))) != null) {
            GasCentrifugeTile.addItemTagBurnTime(map, (Tag<Item>)refined_glowstones_block, 520 * multiplier);
        }
        if ((refined_glowstones_nugget = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("forge:nuggets/refined_glowstone"))) != null) {
            GasCentrifugeTile.addItemTagBurnTime(map, (Tag<Item>)refined_glowstones_nugget, 5 * multiplier);
        }
        if ((glowstone_blocks = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("forge:storage_blocks/glowstone"))) != null) {
            GasCentrifugeTile.addItemTagBurnTime(map, (Tag<Item>)glowstone_blocks, 360 * multiplier);
        }
        GasCentrifugeTile.addItemTagBurnTime(map, (Tag<Item>)Tags.Items.DUSTS_GLOWSTONE, 40 * multiplier);
        GasCentrifugeTile.addItemBurnTime(map, (IItemProvider)Blocks.field_150426_aN, 160 * multiplier);
        return map;
    }

    private static void addItemTagBurnTime(Map<Item, Integer> map, Tag<Item> itemTag, int p_213992_2_) {
        for (Item item : itemTag.func_199885_a()) {
            map.put(item, p_213992_2_);
        }
    }

    private static void addItemBurnTime(Map<Item, Integer> map, IItemProvider itemProvider, int burnTimeIn) {
        map.put(itemProvider.func_199767_j(), burnTimeIn);
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.cookTimeTotal = compound.func_74762_e("CookTimeTotal");
        this.redstoneMode = compound.func_74762_e("RedstoneMode");
        this.liquidMode = compound.func_74762_e("LiquidMode");
        this.tank.setFluid(new FluidStack((Fluid)ModFluids.BROMINE_FLUID.get(), compound.func_74762_e("WasteAmount")));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        compound.func_74768_a("RedstoneMode", this.redstoneMode);
        compound.func_74768_a("LiquidMode", this.liquidMode);
        compound.func_74768_a("WasteAmount", this.tank.getFluidAmount());
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return compound;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.liquidMode == 2) {
                if (this.ticksBeforeDumping <= 0) {
                    if (this.tank.getFluidAmount() >= 10) {
                        this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177967_a(Direction.NORTH, 4).func_177967_a(Direction.WEST, 4).func_177967_a(Direction.UP, 4), this.field_174879_c.func_177967_a(Direction.SOUTH, 4).func_177967_a(Direction.EAST, 4).func_177967_a(Direction.DOWN, 4))).forEach(entity -> {
                            if (entity instanceof LivingEntity) {
                                ((LivingEntity)entity).func_195064_c(new EffectInstance(ModEffect.BROMINE_POISON, 80, 0));
                            }
                        });
                        this.tank.drain(10, IFluidHandler.FluidAction.EXECUTE);
                    }
                } else {
                    --this.ticksBeforeDumping;
                }
            }
            ItemStack itemstack = (ItemStack)this.items.get(1);
            if (this.isBurning() || !itemstack.func_190926_b() && !((ItemStack)this.items.get(0)).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.burnTime = this.getBurnTime(itemstack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (itemstack.hasContainerItem()) {
                            this.items.set(1, (Object)itemstack.getContainerItem());
                        } else if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                this.items.set(1, (Object)itemstack.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getCookTimeTotal();
                        this.placeItemsInRightSlot();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private int getCookTimeTotal() {
        return 100;
    }

    protected boolean canSmelt() {
        if (!((ItemStack)this.items.get(0)).func_190926_b()) {
            ItemStack[] itemstacks = GasCentrifugeRecipe.getRecipeOutputs((ItemStack)this.items.get(0));
            if (itemstacks[0].func_190926_b() && itemstacks[1].func_190926_b() && itemstacks[2].func_190926_b() && itemstacks[3].func_190926_b()) {
                return false;
            }
            if (this.redstoneMode == 1 && this.field_145850_b.func_175687_A(this.field_174879_c) > 0 || this.redstoneMode == 2 && this.field_145850_b.func_175687_A(this.field_174879_c) < 1) {
                return false;
            }
            ItemStack[] itemstacks1 = new ItemStack[]{(ItemStack)this.items.get(2), (ItemStack)this.items.get(3), (ItemStack)this.items.get(4), (ItemStack)this.items.get(5)};
            boolean[] output0 = new boolean[]{true, true, true, true};
            for (int i = 0; i < itemstacks.length - 1; ++i) {
                ItemStack itemstack = itemstacks[i];
                ItemStack itemstack1 = itemstacks1[i];
                output0[i] = itemstack1.func_190926_b() ? true : (!itemstack1.func_77969_a(itemstack) ? false : (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d() ? true : itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d()));
            }
            return output0[0] && output0[1] && output0[2] && output0[3];
        }
        return false;
    }

    private void placeItemsInRightSlot() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack[] itemstacks = GasCentrifugeRecipe.getRecipeOutputs((ItemStack)this.items.get(0));
            ItemStack itemstack2 = (ItemStack)this.items.get(2);
            ItemStack itemstack3 = (ItemStack)this.items.get(3);
            ItemStack itemstack4 = (ItemStack)this.items.get(4);
            ItemStack itemstack5 = (ItemStack)this.items.get(5);
            TheoreticalFluid theoreticalFluid = GasCentrifugeRecipe.getFluid((ItemStack)this.items.get(0));
            if (itemstack2.func_190926_b()) {
                this.items.set(2, (Object)itemstacks[0].func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstacks[0].func_77973_b()) {
                itemstack2.func_190917_f(itemstacks[0].func_190916_E());
            }
            if (itemstack3.func_190926_b()) {
                this.items.set(3, (Object)itemstacks[1].func_77946_l());
            } else if (itemstack3.func_77973_b() == itemstacks[1].func_77973_b()) {
                itemstack3.func_190917_f(itemstacks[1].func_190916_E());
            }
            if (itemstack4.func_190926_b()) {
                this.items.set(4, (Object)itemstacks[2].func_77946_l());
            } else if (itemstack4.func_77973_b() == itemstacks[2].func_77973_b()) {
                itemstack4.func_190917_f(itemstacks[2].func_190916_E());
            }
            if (itemstack5.func_190926_b()) {
                this.items.set(5, (Object)itemstacks[3].func_77946_l());
            } else if (itemstack5.func_77973_b() == itemstacks[3].func_77973_b()) {
                itemstack5.func_190917_f(itemstacks[3].func_190916_E());
            }
            int unbreaking_lvl = 0;
            for (INBT enchantment : itemstack.func_77986_q()) {
                if (!((CompoundNBT)enchantment).func_74779_i("id").equals("minecraft:unbreaking")) continue;
                unbreaking_lvl = ((CompoundNBT)enchantment).func_74765_d("lvl");
            }
            itemstack.func_196085_b(itemstack.func_77952_i() + (unbreaking_lvl == 0 ? 1 : (new Random().nextInt(unbreaking_lvl + 1) == 1 ? 1 : 0)));
            if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                this.items.set(0, (Object)ItemStack.field_190927_a);
            }
            if (theoreticalFluid != null && (this.tank.getFluidAmount() < 1000 && this.furnaceData.func_221476_a(4) == 0 || this.tank.getFluidAmount() < 4000 && this.furnaceData.func_221476_a(4) == 1)) {
                this.tank.fill(new FluidStack((Fluid)ModFluids.BROMINE_FLUID.get(), theoreticalFluid.amount), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    protected int getBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        return GasCentrifugeTile.getBurnTimes().getOrDefault(item, 0);
    }

    public boolean isFuel(ItemStack p_213991_0_) {
        return this.getBurnTime(p_213991_0_) > 0;
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return SLOTS_UP;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getCookTimeTotal();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean isFilter(ItemStack stack) {
        return stack.func_77973_b() instanceof FilterItem;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return this.isFilter(stack);
        }
        if (index == 1) {
            return this.isFuel(stack);
        }
        return false;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void onCrafting(PlayerEntity player) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(capability, LazyOptional.of(() -> new FluidHandlerWrapper(this, facing)));
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public IFluidTank[] getTankInfo(Direction from) {
        return new IFluidTank[]{this.tank};
    }

    @Override
    public IFluidTank[] getAllTanks() {
        return new IFluidTank[]{this.tank};
    }

    @Override
    public int fill(Direction from, @Nonnull FluidStack resource, IFluidHandler.FluidAction fluidAction) {
        if (this.canFill(from, resource)) {
            return this.tank.fill(resource, fluidAction);
        }
        return 0;
    }

    @Override
    @Nonnull
    public FluidStack drain(Direction from, int maxDrain, IFluidHandler.FluidAction fluidAction) {
        if (this.canDrain(from, FluidStack.EMPTY)) {
            return this.tank.drain(maxDrain, fluidAction);
        }
        return FluidStack.EMPTY;
    }

    @Override
    public boolean canFill(Direction from, @Nonnull FluidStack fluid) {
        return true;
    }

    @Override
    public boolean canDrain(Direction from, @Nonnull FluidStack fluid) {
        return true;
    }
}

