/*
 * Decompiled with CFR 0.152.
 */
package tk.dczippl.lightestlamp.util;

import java.util.BitSet;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;
import tk.dczippl.lightestlamp.init.ModBlocks;

public class WorldGenerator {
    private static final GlowstoneOreFeature GLOWSTONE = new GlowstoneOreFeature();

    public static void setupWorldGeneraton() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome.func_201856_r() != Biome.Category.NETHER) continue;
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)GLOWSTONE, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ModBlocks.NEON_BLOCK.func_176223_P(), 48), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(362, 64, 0, 128)));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)GLOWSTONE, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ModBlocks.ARGON_BLOCK.func_176223_P(), 48), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(284, 64, 0, 128)));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)GLOWSTONE, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ModBlocks.KRYPTON_BLOCK.func_176223_P(), 42), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(248, 86, 0, 128)));
        }
    }

    public static class GlowstoneOreFeature
    extends OreFeature {
        public GlowstoneOreFeature() {
            super(null);
        }

        protected boolean func_207803_a(IWorld worldIn, Random random, OreFeatureConfig config, double p_207803_4_, double p_207803_6_, double p_207803_8_, double p_207803_10_, double p_207803_12_, double p_207803_14_, int p_207803_16_, int p_207803_17_, int p_207803_18_, int p_207803_19_, int p_207803_20_) {
            int i = 0;
            BitSet bitset = new BitSet(p_207803_19_ * p_207803_20_ * p_207803_19_);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            double[] adouble = new double[config.field_202443_c * 4];
            for (int j = 0; j < config.field_202443_c; ++j) {
                float f = (float)j / (float)config.field_202443_c;
                double d0 = MathHelper.func_219803_d((double)f, (double)p_207803_4_, (double)p_207803_6_);
                double d2 = MathHelper.func_219803_d((double)f, (double)p_207803_12_, (double)p_207803_14_);
                double d4 = MathHelper.func_219803_d((double)f, (double)p_207803_8_, (double)p_207803_10_);
                double d6 = random.nextDouble() * (double)config.field_202443_c / 16.0;
                double d7 = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * f)) + 1.0f) * d6 + 1.0) / 2.0;
                adouble[j * 4 + 0] = d0;
                adouble[j * 4 + 1] = d2;
                adouble[j * 4 + 2] = d4;
                adouble[j * 4 + 3] = d7;
            }
            for (int l2 = 0; l2 < config.field_202443_c - 1; ++l2) {
                if (adouble[l2 * 4 + 3] <= 0.0) continue;
                for (int j3 = l2 + 1; j3 < config.field_202443_c; ++j3) {
                    double d14;
                    double d13;
                    double d12;
                    double d15;
                    if (adouble[j3 * 4 + 3] <= 0.0 || !((d15 = adouble[l2 * 4 + 3] - adouble[j3 * 4 + 3]) * d15 > (d12 = adouble[l2 * 4 + 0] - adouble[j3 * 4 + 0]) * d12 + (d13 = adouble[l2 * 4 + 1] - adouble[j3 * 4 + 1]) * d13 + (d14 = adouble[l2 * 4 + 2] - adouble[j3 * 4 + 2]) * d14)) continue;
                    if (d15 > 0.0) {
                        adouble[j3 * 4 + 3] = -1.0;
                        continue;
                    }
                    adouble[l2 * 4 + 3] = -1.0;
                }
            }
            for (int i3 = 0; i3 < config.field_202443_c; ++i3) {
                double d11 = adouble[i3 * 4 + 3];
                if (d11 < 0.0) continue;
                double d1 = adouble[i3 * 4 + 0];
                double d3 = adouble[i3 * 4 + 1];
                double d5 = adouble[i3 * 4 + 2];
                int k = Math.max(MathHelper.func_76128_c((double)(d1 - d11)), p_207803_16_);
                int k3 = Math.max(MathHelper.func_76128_c((double)(d3 - d11)), p_207803_17_);
                int l = Math.max(MathHelper.func_76128_c((double)(d5 - d11)), p_207803_18_);
                int i1 = Math.max(MathHelper.func_76128_c((double)(d1 + d11)), k);
                int j1 = Math.max(MathHelper.func_76128_c((double)(d3 + d11)), k3);
                int k1 = Math.max(MathHelper.func_76128_c((double)(d5 + d11)), l);
                for (int l1 = k; l1 <= i1; ++l1) {
                    double d8 = ((double)l1 + 0.5 - d1) / d11;
                    if (!(d8 * d8 < 1.0)) continue;
                    for (int i2 = k3; i2 <= j1; ++i2) {
                        double d9 = ((double)i2 + 0.5 - d3) / d11;
                        if (!(d8 * d8 + d9 * d9 < 1.0)) continue;
                        for (int j2 = l; j2 <= k1; ++j2) {
                            int k2;
                            double d10 = ((double)j2 + 0.5 - d5) / d11;
                            if (!(d8 * d8 + d9 * d9 + d10 * d10 < 1.0) || bitset.get(k2 = l1 - p_207803_16_ + (i2 - p_207803_17_) * p_207803_19_ + (j2 - p_207803_18_) * p_207803_19_ * p_207803_20_)) continue;
                            bitset.set(k2);
                            blockpos$mutableblockpos.func_181079_c(l1, i2, j2);
                            if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c() != Blocks.field_150426_aN) continue;
                            worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, config.field_202444_d, 2);
                            ++i;
                        }
                    }
                }
            }
            return i > 0;
        }
    }
}

