/*
 * Decompiled with CFR 0.152.
 */
package tk.dczippl.lightestlamp;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tk.dczippl.lightestlamp.Config;
import tk.dczippl.lightestlamp.init.ModBlocks;
import tk.dczippl.lightestlamp.init.ModContainers;
import tk.dczippl.lightestlamp.init.ModEffect;
import tk.dczippl.lightestlamp.init.ModFluids;
import tk.dczippl.lightestlamp.init.ModItems;
import tk.dczippl.lightestlamp.init.ModTileEntities;
import tk.dczippl.lightestlamp.machine.gascentrifuge.GasCentrifugeScreen;
import tk.dczippl.lightestlamp.machine.gascentrifuge.GasCentrifugeTile;
import tk.dczippl.lightestlamp.tile.AbyssalLanternTileEntity;
import tk.dczippl.lightestlamp.tile.AlchemicalLampTileEntity;
import tk.dczippl.lightestlamp.tile.AlfaLampTileEntity;
import tk.dczippl.lightestlamp.tile.AntiLampTileEntity;
import tk.dczippl.lightestlamp.tile.BetaLampTileEntity;
import tk.dczippl.lightestlamp.tile.ClearLampTileEntity;
import tk.dczippl.lightestlamp.tile.ClearSeaLanternTileEntity;
import tk.dczippl.lightestlamp.tile.DeepOceanLanternTileEntity;
import tk.dczippl.lightestlamp.tile.DeepSeaLanternTileEntity;
import tk.dczippl.lightestlamp.tile.DeltaLampTileEntity;
import tk.dczippl.lightestlamp.tile.EpsilonLampTileEntity;
import tk.dczippl.lightestlamp.tile.EtaLampTileEntity;
import tk.dczippl.lightestlamp.tile.GammaLampTileEntity;
import tk.dczippl.lightestlamp.tile.LightAirTileEntity;
import tk.dczippl.lightestlamp.tile.OceanLanternTileEntity;
import tk.dczippl.lightestlamp.tile.OmegaChunkCleanerTileEntity;
import tk.dczippl.lightestlamp.tile.OmegaLampTileEntity;
import tk.dczippl.lightestlamp.tile.ZetaLampTileEntity;
import tk.dczippl.lightestlamp.util.WorldGenerator;
import tk.dczippl.lightestlamp.util.network.Networking;

@Mod(value="lightestlamp")
public class Main {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup main_group = new ItemGroup("lamps"){

        public ItemStack func_78016_d() {
            ItemStack stack = new ItemStack((IItemProvider)ModBlocks.OMEGA_LAMP.get());
            return stack;
        }
    };

    public Main() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.init(modEventBus);
        ModFluids.ITEMS.register(modEventBus);
        ModFluids.FLUIDS.register(modEventBus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        Config.loadConfig(Config.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("lightestlamp-client.toml"));
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("lightestlamp-common.toml"));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.debug(((Block)ModBlocks.ANTI_LAMP.get()).toString());
        Networking.registerMessages();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(ModContainers.GAS_CENTRIFUGE, GasCentrifugeScreen::new);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.JUNGLE_LANTERN.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GLOWING_GLASS_BLOCK.get()), (RenderType)RenderType.func_228643_e_());
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onEntityLivingDeath(LivingDeathEvent event) {
        Random rnd;
        if (event.getSource().func_76355_l().equals("player") && event.getEntityLiving() instanceof IMob && event.getEntityLiving().func_130014_f_().func_242413_ae() == 1.0f && (rnd = new Random()).nextInt(4) == 2) {
            event.getEntityLiving().func_199701_a_(new ItemStack((IItemProvider)ModItems.MOON_SHARD));
        }
    }

    @SubscribeEvent
    public void EntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        boolean disabled = false;
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_175149_v()) {
            disabled = true;
        }
        if (!disabled) {
            BlockPos pos = new BlockPos(entity.func_213303_ch());
            Block b = entity.func_130014_f_().func_180495_p(pos.func_177972_a(Direction.UP)).func_177230_c();
            Block b1 = entity.func_130014_f_().func_180495_p(pos).func_177230_c();
            if (b.equals(ModFluids.BROMINE_FLUID_BLOCK.get())) {
                entity.func_213317_d(new Vector3d(entity.func_213322_ci().field_72450_a, 0.10000001162, entity.func_213322_ci().field_72449_c));
            } else if (b1.equals(ModFluids.BROMINE_FLUID_BLOCK.get())) {
                entity.func_213317_d(new Vector3d(entity.func_213322_ci().field_72450_a, 0.10000001162, entity.func_213322_ci().field_72449_c));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void setFog(EntityViewRenderEvent.FogColors fog) {
        BlockPos pos;
        World w = fog.getInfo().func_216773_g().func_130014_f_();
        BlockState bs = w.func_180495_p(pos = fog.getInfo().func_216780_d());
        Block b = bs.func_177230_c();
        if (b.equals(ModFluids.BROMINE_FLUID_BLOCK.get())) {
            float red = 0.2f;
            float green = 0.05f;
            float blue = 0.05f;
            fog.setRed(red);
            fog.setGreen(green);
            fog.setBlue(blue);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void setFogDensity(EntityViewRenderEvent.FogDensity fog) {
        BlockPos pos;
        World w = fog.getInfo().func_216773_g().func_130014_f_();
        BlockState bs = w.func_180495_p(pos = fog.getInfo().func_216780_d());
        Block b = bs.func_177230_c();
        if (b.equals(ModFluids.BROMINE_FLUID_BLOCK.get())) {
            fog.setDensity(1.0f);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void setFogLength(EntityViewRenderEvent.RenderFogEvent fog) {
        BlockPos pos;
        World w = fog.getInfo().func_216773_g().func_130014_f_();
        BlockState bs = w.func_180495_p(pos = fog.getInfo().func_216780_d());
        Block b = bs.func_177230_c();
        if (b.equals(ModFluids.BROMINE_FLUID_BLOCK.get())) {
            float progress = 1.2f;
            RenderSystem.fogStart((float)((1.0f - progress) * fog.getFarPlaneDistance() * 0.75f));
            RenderSystem.fogEnd((float)(fog.getFarPlaneDistance() * (1.0f - 0.8f * progress)));
        }
    }

    @SubscribeEvent
    public void biomeLoad(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.NETHER) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> OreFeature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, ((Block)ModBlocks.MONAZITE_ORE.get()).func_176223_P(), 3)).func_227228_a_(Placement.field_242899_c.func_227446_a_((IPlacementConfig)WorldGenerator.MONAZITE_BLOCK)));
        }
    }

    public static void repelEntitiesInAABBFromPoint(World world, AxisAlignedBB effectBounds, double x, double y, double z, boolean ignore) {
        List list = world.func_217357_a(Entity.class, effectBounds);
        for (Entity ent : list) {
            if (!(ent instanceof LivingEntity) && !(ent instanceof ProjectileEntity) || !ignore && !(ent instanceof IMob) && !(ent instanceof ProjectileEntity)) continue;
            Vector3d p = new Vector3d(x, y, z);
            Vector3d t = ent.func_213303_ch();
            double distance = p.func_72438_d(t) + 0.1;
            Vector3d r = new Vector3d(t.field_72450_a - p.field_72450_a, t.field_72448_b - p.field_72448_b, t.field_72449_c - p.field_72449_c);
            ent.func_213293_j(r.field_72450_a / 1.5 / distance + ent.func_213322_ci().field_72450_a, r.field_72448_b / 1.5 / distance + ent.func_213322_ci().field_72448_b, r.field_72449_c / 1.5 / distance + ent.func_213322_ci().field_72449_c);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerEffects(RegistryEvent.Register<Effect> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Effect[]{ModEffect.BROMINE_POISON});
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> containerTypeRegistryEvent) {
            containerTypeRegistryEvent.getRegistry().register(ModContainers.GAS_CENTRIFUGE);
        }

        @SubscribeEvent
        public static void registerTE(RegistryEvent.Register<TileEntityType<?>> evt) {
            evt.getRegistry().register(TileEntityType.Builder.func_223042_a(LightAirTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.LIGHT_AIR.get(), (Block)ModBlocks.CHUNK_CLEANER.get()}).func_206865_a(null).setRegistryName("light_air_te"));
            evt.getRegistry().register(TileEntityType.Builder.func_223042_a(AntiLampTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.ANTI_LAMP.get()}).func_206865_a(null).setRegistryName("antilamp_te"));
            TileEntityType clear_te = TileEntityType.Builder.func_223042_a(ClearLampTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.CLEAR_LAMP.get()}).func_206865_a(null);
            clear_te.setRegistryName("lightestlamp", "clear_te");
            ModTileEntities.CLEAR_TE = clear_te;
            evt.getRegistry().register(ModTileEntities.CLEAR_TE);
            TileEntityType type0 = TileEntityType.Builder.func_223042_a(AlfaLampTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.ALPHA_LAMP.get()}).func_206865_a(null);
            type0.setRegistryName("lightestlamp", "alfa_te");
            TileEntityType type1 = TileEntityType.Builder.func_223042_a(BetaLampTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.BETA_LAMP.get()}).func_206865_a(null);
            type1.setRegistryName("lightestlamp", "beta_te");
            TileEntityType type2 = TileEntityType.Builder.func_223042_a(GammaLampTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.GAMMA_LAMP.get()}).func_206865_a(null);
            type2.setRegistryName("lightestlamp", "gamma_te");
            TileEntityType type3 = TileEntityType.Builder.func_223042_a(DeltaLampTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.DELTA_LAMP.get()}).func_206865_a(null);
            type3.setRegistryName("lightestlamp", "delta_te");
            TileEntityType type4 = TileEntityType.Builder.func_223042_a(EpsilonLampTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.EPSILON_LAMP.get()}).func_206865_a(null);
            type4.setRegistryName("lightestlamp", "epsilon_te");
            TileEntityType type5 = TileEntityType.Builder.func_223042_a(ZetaLampTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.ZETA_LAMP.get()}).func_206865_a(null);
            type5.setRegistryName("lightestlamp", "zeta_te");
            TileEntityType type6 = TileEntityType.Builder.func_223042_a(OmegaLampTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.OMEGA_LAMP.get()}).func_206865_a(null);
            type6.setRegistryName("lightestlamp", "omega_te");
            TileEntityType type7 = TileEntityType.Builder.func_223042_a(DeepSeaLanternTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.DEEP_SEA_LANTERN.get()}).func_206865_a(null);
            type7.setRegistryName("lightestlamp", "deep_sea_lantern_te");
            TileEntityType type8 = TileEntityType.Builder.func_223042_a(OceanLanternTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.OCEAN_LANTERN.get()}).func_206865_a(null);
            type8.setRegistryName("lightestlamp", "ocean_lantern_te");
            TileEntityType type9 = TileEntityType.Builder.func_223042_a(ClearSeaLanternTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.CLEAR_SEA_LANTERN.get()}).func_206865_a(null);
            type9.setRegistryName("lightestlamp", "clear_sea_lantern_te");
            TileEntityType type10 = TileEntityType.Builder.func_223042_a(AlchemicalLampTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.ALCHEMICAL_LAMP.get()}).func_206865_a(null);
            type10.setRegistryName("lightestlamp", "alchemical_lamp_te");
            TileEntityType centrifuge_te = TileEntityType.Builder.func_223042_a(GasCentrifugeTile::new, (Block[])new Block[]{(Block)ModBlocks.GAS_EXTRACTOR.get()}).func_206865_a(null);
            centrifuge_te.setRegistryName("lightestlamp", "centrifuge_te");
            TileEntityType eta_te = TileEntityType.Builder.func_223042_a(EtaLampTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.ETA_LAMP.get()}).func_206865_a(null);
            eta_te.setRegistryName("lightestlamp", "eta_te");
            ModTileEntities.ETA_TE = eta_te;
            evt.getRegistry().register(ModTileEntities.ETA_TE);
            TileEntityType deep_ocean_lantern_te = TileEntityType.Builder.func_223042_a(DeepOceanLanternTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.DEEP_OCEAN_LANTERN.get()}).func_206865_a(null);
            deep_ocean_lantern_te.setRegistryName("lightestlamp", "deep_ocean_lantern_te");
            ModTileEntities.DEEPOCEANLANTERN_TE = deep_ocean_lantern_te;
            evt.getRegistry().register(ModTileEntities.DEEPOCEANLANTERN_TE);
            TileEntityType abyssal_lantern_te = TileEntityType.Builder.func_223042_a(AbyssalLanternTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.ABYSSAL_LANTERN.get()}).func_206865_a(null);
            abyssal_lantern_te.setRegistryName("lightestlamp", "abyssal_lantern_te");
            ModTileEntities.ABYSSALLANTERN_TE = abyssal_lantern_te;
            evt.getRegistry().register(ModTileEntities.ABYSSALLANTERN_TE);
            TileEntityType occ_te = TileEntityType.Builder.func_223042_a(OmegaChunkCleanerTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.OCC.get()}).func_206865_a(null);
            occ_te.setRegistryName("lightestlamp", "occ_te");
            ModTileEntities.OCC_TE = occ_te;
            evt.getRegistry().register(ModTileEntities.OCC_TE);
            ModTileEntities.ALFA_TE = type0;
            ModTileEntities.BETA_TE = type1;
            ModTileEntities.GAMMA_TE = type2;
            ModTileEntities.DELTA_TE = type3;
            ModTileEntities.EPSILON_TE = type4;
            ModTileEntities.ZETA_TE = type5;
            ModTileEntities.OMEGA_TE = type6;
            ModTileEntities.DEEPSEALANTERN_TE = type7;
            ModTileEntities.OCEANLANTERN_TE = type8;
            ModTileEntities.CLEARSEALANTERN_TE = type9;
            ModTileEntities.ALCHEMICALLAMP_TE = type10;
            ModTileEntities.CENTRIFUGE_TE = centrifuge_te;
            evt.getRegistry().register(ModTileEntities.ALFA_TE);
            evt.getRegistry().register(ModTileEntities.BETA_TE);
            evt.getRegistry().register(ModTileEntities.GAMMA_TE);
            evt.getRegistry().register(ModTileEntities.DELTA_TE);
            evt.getRegistry().register(ModTileEntities.EPSILON_TE);
            evt.getRegistry().register(ModTileEntities.ZETA_TE);
            evt.getRegistry().register(ModTileEntities.OMEGA_TE);
            evt.getRegistry().register(ModTileEntities.DEEPSEALANTERN_TE);
            evt.getRegistry().register(ModTileEntities.OCEANLANTERN_TE);
            evt.getRegistry().register(ModTileEntities.CLEARSEALANTERN_TE);
            evt.getRegistry().register(ModTileEntities.ALCHEMICALLAMP_TE);
            evt.getRegistry().register(ModTileEntities.CENTRIFUGE_TE);
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            IForgeRegistry registry = itemRegistryEvent.getRegistry();
            ModBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
                Item.Properties properties = new Item.Properties();
                if (block != ModBlocks.LIGHT_AIR.get() && block != ModBlocks.WATERLOGGABLE_LIGHT_AIR.get() && block != ModFluids.BROMINE_FLUID_BLOCK.get()) {
                    properties = properties.func_200916_a(main_group);
                }
                BlockItem blockItem = new BlockItem(block, properties);
                blockItem.setRegistryName(block.getRegistryName());
                registry.register((IForgeRegistryEntry)blockItem);
            });
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.EMPTY_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.NEON_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.ARGON_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.KRYPTON_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.XENON_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.RADON_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.NEON_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.ARGON_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.KRYPTON_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.XENON_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.RADON_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.LANTHANUM_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.ALCHEMICAL_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.NEON_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.ARGON_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.KRYPTON_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.XENON_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.RADON_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.LANTHANUM_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.LANTHANUM_INGOT);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.LANTHANUM_NUGGET);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.CARBON_NANOTUBE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.MOON_SHARD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.CHORUS_FIBER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BROMINE_CRYSTAL);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.STICKANDBOWL);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BASIC_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.NEON_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.ARGON_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.KRYPTON_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.XENON_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.RADON_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BROMINE_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BORON_MESH);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.NETHERITE_MESH);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.DEBUG_STICK);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.GLOWING_DUST_AGGLOMERATIO);
        }
    }
}

