/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty.blocks;

import com.androsa.nifty.NiftyBlock;
import com.androsa.nifty.util.BlockModelHelper;
import com.androsa.nifty.util.ModelUtil;
import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NiftySlab
extends BlockSlab
implements BlockModelHelper {
    public static final PropertyEnum<NiftySlabEnum> VARIANT = PropertyEnum.func_177709_a((String)"variant", NiftySlabEnum.class);
    private final boolean isDouble;
    private final float fallDamage;
    private final Supplier<Item> dropItem;

    public NiftySlab(boolean isDouble, NiftyBlock block) {
        super(block.material, block.color);
        this.func_149672_a(block.sound);
        this.func_149711_c(block.hardness);
        this.func_149752_b(block.resistance);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.setHarvestLevel(block.tool, block.level);
        this.field_149783_u = true;
        IBlockState state = this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)NiftySlabEnum.NORMAL));
        if (!this.func_176552_j()) {
            state = state.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(state);
        this.isDouble = isDouble;
        this.fallDamage = block.multiplier;
        this.dropItem = block.dropItem;
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return NiftySlabEnum.NORMAL;
    }

    public boolean func_176552_j() {
        return this.isDouble;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.dropItem.get();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.dropItem.get());
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_180430_e(fallDistance, this.fallDamage);
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a();
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{VARIANT, field_176554_a});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176552_j() ? this.func_176223_P() : this.func_176223_P().func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.values()[meta % BlockSlab.EnumBlockHalf.values().length]);
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a)).ordinal();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        if (this.func_176552_j()) {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{VARIANT}).func_178442_a(new IProperty[]{field_176554_a}).func_178441_a());
        } else {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{VARIANT}).func_178441_a());
            ModelUtil.registerToState((Block)this, 0, this.func_176223_P());
        }
    }

    public static enum NiftySlabEnum implements IStringSerializable
    {
        NORMAL;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

