/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty.compat;

import com.androsa.nifty.ModBlocks;
import com.androsa.nifty.NiftyBlock;
import com.androsa.nifty.NiftyMod;
import com.androsa.nifty.compat.NiftyBLFence;
import com.androsa.nifty.compat.NiftyBLFenceGate;
import com.androsa.nifty.compat.NiftyBLSlab;
import com.androsa.nifty.compat.NiftyBLStairs;
import com.androsa.nifty.compat.NiftyBLTrapDoor;
import com.androsa.nifty.compat.NiftyTFFence;
import com.androsa.nifty.compat.NiftyTFFenceGate;
import com.androsa.nifty.compat.NiftyTFFieryFence;
import com.androsa.nifty.compat.NiftyTFFieryFenceGate;
import com.androsa.nifty.compat.NiftyTFFierySlab;
import com.androsa.nifty.compat.NiftyTFFieryStairs;
import com.androsa.nifty.compat.NiftyTFFieryTrapDoor;
import com.androsa.nifty.compat.NiftyTFSlab;
import com.androsa.nifty.compat.NiftyTFStairs;
import com.androsa.nifty.compat.NiftyTFTrapDoor;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
public enum NiftyCompat {
    TWILIGHT_FOREST("Twilight Forest"){

        @Override
        protected void registerBlocks(ModBlocks.BlockRegistryHelper blocks) {
            Block ironwood = new Block(Material.field_151575_d, MapColor.field_151663_o);
            Block fiery = new Block(Material.field_151573_f, MapColor.field_151668_h);
            Block steeleaf = new Block(Material.field_151584_j, MapColor.field_151669_i);
            Block arctic = new Block(Material.field_151580_n, MapColor.field_151659_e);
            Block carminite = new Block(Material.field_151571_B, MapColor.field_151667_k);
            blocks.registerBlock("ironwood_stairs", (Block)new NiftyTFStairs(ironwood.func_176223_P(), NiftyBlock.IRONWOOD));
            blocks.registerBlock("fiery_stairs", (Block)new NiftyTFFieryStairs(fiery.func_176223_P()));
            blocks.registerBlock("steeleaf_stairs", (Block)new NiftyTFStairs(steeleaf.func_176223_P(), NiftyBlock.STEELEAF));
            blocks.registerBlock("arctic_fur_stairs", (Block)new NiftyTFStairs(arctic.func_176223_P(), NiftyBlock.ARCTIC));
            blocks.registerBlock("carminite_stairs", (Block)new NiftyTFStairs(carminite.func_176223_P(), NiftyBlock.CARMINITE));
            blocks.registerBlock("ironwood_slab", (Block)new NiftyTFSlab(false, NiftyBlock.IRONWOOD));
            blocks.registerBlock("fiery_slab", (Block)new NiftyTFFierySlab(false));
            blocks.registerBlock("steeleaf_slab", (Block)new NiftyTFSlab(false, NiftyBlock.STEELEAF));
            blocks.registerBlock("arctic_fur_slab", (Block)new NiftyTFSlab(false, NiftyBlock.ARCTIC));
            blocks.registerBlock("carminite_slab", (Block)new NiftyTFSlab(false, NiftyBlock.CARMINITE));
            blocks.registerBlock("double_ironwood_slab", (Block)new NiftyTFSlab(true, NiftyBlock.IRONWOOD));
            blocks.registerBlock("double_fiery_slab", (Block)new NiftyTFFierySlab(true));
            blocks.registerBlock("double_steeleaf_slab", (Block)new NiftyTFSlab(true, NiftyBlock.STEELEAF));
            blocks.registerBlock("double_arctic_fur_slab", (Block)new NiftyTFSlab(true, NiftyBlock.ARCTIC));
            blocks.registerBlock("double_carminite_slab", (Block)new NiftyTFSlab(true, NiftyBlock.CARMINITE));
            blocks.registerBlock("ironwood_fence", (Block)new NiftyTFFence(NiftyBlock.IRONWOOD));
            blocks.registerBlock("fiery_fence", (Block)new NiftyTFFieryFence());
            blocks.registerBlock("steeleaf_fence", (Block)new NiftyTFFence(NiftyBlock.STEELEAF));
            blocks.registerBlock("arctic_fur_fence", (Block)new NiftyTFFence(NiftyBlock.ARCTIC));
            blocks.registerBlock("carminite_fence", (Block)new NiftyTFFence(NiftyBlock.CARMINITE));
            blocks.registerBlock("ironwood_trapdoor", (Block)new NiftyTFTrapDoor(NiftyBlock.IRONWOOD));
            blocks.registerBlock("fiery_trapdoor", (Block)new NiftyTFFieryTrapDoor());
            blocks.registerBlock("steeleaf_trapdoor", (Block)new NiftyTFTrapDoor(NiftyBlock.STEELEAF));
            blocks.registerBlock("arctic_fur_trapdoor", (Block)new NiftyTFTrapDoor(NiftyBlock.ARCTIC));
            blocks.registerBlock("carminite_trapdoor", (Block)new NiftyTFTrapDoor(NiftyBlock.CARMINITE));
            blocks.registerBlock("ironwood_fence_gate", (Block)new NiftyTFFenceGate(() -> ((Block)ironwood).func_176223_P(), NiftyBlock.IRONWOOD));
            blocks.registerBlock("fiery_fence_gate", (Block)new NiftyTFFieryFenceGate(() -> ((Block)fiery).func_176223_P()));
            blocks.registerBlock("steeleaf_fence_gate", (Block)new NiftyTFFenceGate(() -> ((Block)steeleaf).func_176223_P(), NiftyBlock.STEELEAF));
            blocks.registerBlock("arctic_fur_fence_gate", (Block)new NiftyTFFenceGate(() -> ((Block)arctic).func_176223_P(), NiftyBlock.ARCTIC));
            blocks.registerBlock("carminite_fence_gate", (Block)new NiftyTFFenceGate(() -> ((Block)carminite).func_176223_P(), NiftyBlock.CARMINITE));
        }

        @Override
        protected void registerItems(ModBlocks.ItemRegistryHelper items) {
            items.register(new ItemBlock((Block)ModBlocks.ironwood_stairs){

                public int getItemBurnTime(ItemStack stack) {
                    return 0;
                }
            });
            items.registerBlock((Block)ModBlocks.fiery_stairs);
            items.registerBlock((Block)ModBlocks.steeleaf_stairs);
            items.registerBlock((Block)ModBlocks.arctic_fur_stairs);
            items.registerBlock((Block)ModBlocks.carminite_stairs);
            items.register((ItemBlock)new ItemSlab((Block)ModBlocks.ironwood_slab, ModBlocks.ironwood_slab, ModBlocks.double_ironwood_slab){

                public int getItemBurnTime(ItemStack stack) {
                    return 0;
                }
            });
            items.register((ItemBlock)new ItemSlab((Block)ModBlocks.fiery_slab, ModBlocks.fiery_slab, ModBlocks.double_fiery_slab));
            items.register((ItemBlock)new ItemSlab((Block)ModBlocks.steeleaf_slab, ModBlocks.steeleaf_slab, ModBlocks.double_steeleaf_slab));
            items.register((ItemBlock)new ItemSlab((Block)ModBlocks.arctic_fur_slab, ModBlocks.arctic_fur_slab, ModBlocks.double_arctic_fur_slab));
            items.register((ItemBlock)new ItemSlab((Block)ModBlocks.carminite_slab, ModBlocks.carminite_slab, ModBlocks.double_carminite_slab));
            items.register(new ItemBlock((Block)ModBlocks.ironwood_fence){

                public int getItemBurnTime(ItemStack stack) {
                    return 0;
                }
            });
            items.registerBlock((Block)ModBlocks.fiery_fence);
            items.registerBlock((Block)ModBlocks.steeleaf_fence);
            items.registerBlock((Block)ModBlocks.arctic_fur_fence);
            items.registerBlock((Block)ModBlocks.carminite_fence);
            items.register(new ItemBlock((Block)ModBlocks.ironwood_trapdoor){

                public int getItemBurnTime(ItemStack stack) {
                    return 0;
                }
            });
            items.registerBlock((Block)ModBlocks.fiery_trapdoor);
            items.registerBlock((Block)ModBlocks.steeleaf_trapdoor);
            items.registerBlock((Block)ModBlocks.arctic_fur_trapdoor);
            items.registerBlock((Block)ModBlocks.carminite_trapdoor);
            items.register(new ItemBlock((Block)ModBlocks.ironwood_fence_gate){

                public int getItemBurnTime(ItemStack stack) {
                    return 0;
                }
            });
            items.registerBlock((Block)ModBlocks.fiery_fence_gate);
            items.registerBlock((Block)ModBlocks.steeleaf_fence_gate);
            items.registerBlock((Block)ModBlocks.arctic_fur_fence_gate);
            items.registerBlock((Block)ModBlocks.carminite_fence_gate);
        }
    }
    ,
    THE_BETWEENLANDS("The Betweenlands"){

        @Override
        protected void registerBlocks(ModBlocks.BlockRegistryHelper blocks) {
            Block octine = new Block(Material.field_151573_f, MapColor.field_151668_h);
            Block syrmorite = new Block(Material.field_151573_f, MapColor.field_151668_h);
            Block valonite = new Block(Material.field_151573_f, MapColor.field_151668_h);
            Block scabyst = new Block(Material.field_151576_e, MapColor.field_151665_m);
            Block sulfur = new Block(Material.field_151576_e, MapColor.field_151665_m);
            blocks.registerBlock("octine_stairs", new NiftyBLStairs(octine.func_176223_P(), NiftyBlock.OCTINE).func_149715_a(0.875f));
            blocks.registerBlock("syrmorite_stairs", (Block)new NiftyBLStairs(syrmorite.func_176223_P(), NiftyBlock.SYRMORITE));
            blocks.registerBlock("valonite_stairs", (Block)new NiftyBLStairs(valonite.func_176223_P(), NiftyBlock.VALONITE));
            blocks.registerBlock("scabyst_stairs", (Block)new NiftyBLStairs(scabyst.func_176223_P(), NiftyBlock.SCABYST));
            blocks.registerBlock("sulfur_stairs", (Block)new NiftyBLStairs(sulfur.func_176223_P(), NiftyBlock.SULFUR));
            blocks.registerBlock("octine_slab", new NiftyBLSlab(false, NiftyBlock.OCTINE).func_149715_a(0.875f));
            blocks.registerBlock("syrmorite_slab", (Block)new NiftyBLSlab(false, NiftyBlock.SYRMORITE));
            blocks.registerBlock("valonite_slab", (Block)new NiftyBLSlab(false, NiftyBlock.VALONITE));
            blocks.registerBlock("scabyst_slab", (Block)new NiftyBLSlab(false, NiftyBlock.SCABYST));
            blocks.registerBlock("sulfur_slab", (Block)new NiftyBLSlab(false, NiftyBlock.SULFUR));
            blocks.registerBlock("double_octine_slab", new NiftyBLSlab(true, NiftyBlock.OCTINE).func_149715_a(0.875f));
            blocks.registerBlock("double_syrmorite_slab", (Block)new NiftyBLSlab(true, NiftyBlock.SYRMORITE));
            blocks.registerBlock("double_valonite_slab", (Block)new NiftyBLSlab(true, NiftyBlock.VALONITE));
            blocks.registerBlock("double_scabyst_slab", (Block)new NiftyBLSlab(true, NiftyBlock.SCABYST));
            blocks.registerBlock("double_sulfur_slab", (Block)new NiftyBLSlab(true, NiftyBlock.SULFUR));
            blocks.registerBlock("octine_fence", new NiftyBLFence(NiftyBlock.OCTINE).func_149715_a(0.875f));
            blocks.registerBlock("syrmorite_fence", (Block)new NiftyBLFence(NiftyBlock.SYRMORITE));
            blocks.registerBlock("valonite_fence", (Block)new NiftyBLFence(NiftyBlock.VALONITE));
            blocks.registerBlock("scabyst_fence", (Block)new NiftyBLFence(NiftyBlock.SCABYST));
            blocks.registerBlock("sulfur_fence", (Block)new NiftyBLFence(NiftyBlock.SULFUR));
            blocks.registerBlock("octine_trapdoor", new NiftyBLTrapDoor(NiftyBlock.OCTINE).func_149715_a(0.875f));
            blocks.registerBlock("valonite_trapdoor", (Block)new NiftyBLTrapDoor(NiftyBlock.VALONITE));
            blocks.registerBlock("sulfur_trapdoor", (Block)new NiftyBLTrapDoor(NiftyBlock.SULFUR));
            blocks.registerBlock("octine_fence_gate", new NiftyBLFenceGate(() -> ((Block)octine).func_176223_P(), NiftyBlock.OCTINE).func_149715_a(0.875f));
            blocks.registerBlock("syrmorite_fence_gate", (Block)new NiftyBLFenceGate(() -> ((Block)syrmorite).func_176223_P(), NiftyBlock.SYRMORITE));
            blocks.registerBlock("valonite_fence_gate", (Block)new NiftyBLFenceGate(() -> ((Block)valonite).func_176223_P(), NiftyBlock.VALONITE));
            blocks.registerBlock("scabyst_fence_gate", (Block)new NiftyBLFenceGate(() -> ((Block)scabyst).func_176223_P(), NiftyBlock.SCABYST));
            blocks.registerBlock("sulfur_fence_gate", (Block)new NiftyBLFenceGate(() -> ((Block)sulfur).func_176223_P(), NiftyBlock.SULFUR));
        }

        @Override
        protected void registerItems(ModBlocks.ItemRegistryHelper items) {
            items.registerBlock((Block)ModBlocks.octine_stairs);
            items.registerBlock((Block)ModBlocks.syrmorite_stairs);
            items.registerBlock((Block)ModBlocks.valonite_stairs);
            items.registerBlock((Block)ModBlocks.scabyst_stairs);
            items.registerBlock((Block)ModBlocks.sulfur_stairs);
            items.register((ItemBlock)new ItemSlab((Block)ModBlocks.octine_slab, ModBlocks.octine_slab, ModBlocks.double_octine_slab));
            items.register((ItemBlock)new ItemSlab((Block)ModBlocks.syrmorite_slab, ModBlocks.syrmorite_slab, ModBlocks.double_syrmorite_slab));
            items.register((ItemBlock)new ItemSlab((Block)ModBlocks.valonite_slab, ModBlocks.valonite_slab, ModBlocks.double_valonite_slab));
            items.register((ItemBlock)new ItemSlab((Block)ModBlocks.scabyst_slab, ModBlocks.scabyst_slab, ModBlocks.double_scabyst_slab));
            items.register((ItemBlock)new ItemSlab((Block)ModBlocks.sulfur_slab, ModBlocks.sulfur_slab, ModBlocks.double_sulfur_slab));
            items.registerBlock((Block)ModBlocks.octine_fence);
            items.registerBlock((Block)ModBlocks.syrmorite_fence);
            items.registerBlock((Block)ModBlocks.valonite_fence);
            items.registerBlock((Block)ModBlocks.scabyst_fence);
            items.registerBlock((Block)ModBlocks.sulfur_fence);
            items.registerBlock((Block)ModBlocks.octine_trapdoor);
            items.registerBlock((Block)ModBlocks.valonite_trapdoor);
            items.registerBlock((Block)ModBlocks.sulfur_trapdoor);
            items.registerBlock((Block)ModBlocks.octine_fence_gate);
            items.registerBlock((Block)ModBlocks.syrmorite_fence_gate);
            items.registerBlock((Block)ModBlocks.valonite_fence_gate);
            items.registerBlock((Block)ModBlocks.scabyst_fence_gate);
            items.registerBlock((Block)ModBlocks.sulfur_fence_gate);
        }
    };

    private final String mod;
    private boolean active = true;

    protected void registerBlocks(ModBlocks.BlockRegistryHelper blocks) {
    }

    protected void registerItems(ModBlocks.ItemRegistryHelper items) {
    }

    public boolean isActivated() {
        return this.active;
    }

    private NiftyCompat(String mod) {
        this.mod = mod;
    }

    public static void initCompatBlocks(ModBlocks.BlockRegistryHelper blocks) {
        for (NiftyCompat compat : NiftyCompat.values()) {
            if (!compat.isActivated()) continue;
            try {
                compat.registerBlocks(blocks);
            }
            catch (Exception e) {
                compat.active = false;
                NiftyMod.logger.error("An error has occurred during mod compat for " + compat.mod + ".");
                NiftyMod.logger.catching(e.fillInStackTrace());
            }
        }
    }

    public static void initCompatItems(ModBlocks.ItemRegistryHelper items) {
        for (NiftyCompat compat : NiftyCompat.values()) {
            if (!compat.isActivated()) continue;
            try {
                compat.registerItems(items);
            }
            catch (Exception e) {
                compat.active = false;
                NiftyMod.logger.error("An error has occurred during mod compat for " + compat.mod + ".");
                NiftyMod.logger.catching(e.fillInStackTrace());
            }
        }
    }
}

