/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty.blocks.ice;

import com.androsa.nifty.NiftyBlock;
import com.androsa.nifty.blocks.NiftyStairs;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class NiftyIceStairs
extends NiftyStairs {
    private final float sliperiness;
    private final boolean canMelt;

    public NiftyIceStairs(NiftyBlock block, float slip, boolean melt) {
        super(block);
        this.sliperiness = slip;
        this.canMelt = melt;
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return this.sliperiness;
    }

    public boolean func_149653_t(BlockState state) {
        return this.canMelt;
    }

    public BlockRenderLayer func_180664_k() {
        return this.canMelt ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (this.canMelt && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) == 0) {
            if (worldIn.field_73011_w.func_177500_n()) {
                worldIn.func_217377_a(pos, false);
                return;
            }
            Material material = worldIn.func_180495_p(pos.func_177977_b()).func_185904_a();
            if (material.func_76230_c() || material.func_76224_d()) {
                worldIn.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            }
        }
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (this.canMelt && worldIn.func_175642_b(LightType.BLOCK, pos) > 11 - state.func_200016_a((IBlockReader)worldIn, pos)) {
            this.turnIntoWater(worldIn, pos);
        }
    }

    protected void turnIntoWater(World world, BlockPos pos) {
        if (world.field_73011_w.func_177500_n()) {
            world.func_217377_a(pos, false);
        } else {
            world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            world.func_190524_a(pos, Blocks.field_150355_j, pos);
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return type == EntityType.field_200786_Z;
    }
}

