/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty.blocks.path;

import com.androsa.nifty.ModBlocks;
import com.androsa.nifty.NiftyBlock;
import com.androsa.nifty.blocks.NiftyStairs;
import com.androsa.nifty.blocks.path.NiftyPathSlab;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NiftyPathStairs
extends NiftyStairs {
    protected static final VoxelShape AABB_SLAB_TOP = NiftyPathSlab.TOP_SHAPE;
    protected static final VoxelShape AABB_SLAB_BOTTOM = NiftyPathSlab.BOTTOM_SHAPE;
    protected static final VoxelShape NWD_CORNER = Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SWD_CORNER = Block.func_208617_a((double)0.0, (double)1.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.func_208617_a((double)0.0, (double)7.0, (double)0.0, (double)8.0, (double)15.0, (double)8.0);
    protected static final VoxelShape SWU_CORNER = Block.func_208617_a((double)0.0, (double)7.0, (double)8.0, (double)8.0, (double)15.0, (double)16.0);
    protected static final VoxelShape NED_CORNER = Block.func_208617_a((double)8.0, (double)1.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SED_CORNER = Block.func_208617_a((double)8.0, (double)1.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.func_208617_a((double)8.0, (double)7.0, (double)0.0, (double)16.0, (double)15.0, (double)8.0);
    protected static final VoxelShape SEU_CORNER = Block.func_208617_a((double)8.0, (double)7.0, (double)8.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape[] SLAB_TOP_SHAPES = NiftyPathStairs.makeShapes(AABB_SLAB_TOP, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = NiftyPathStairs.makeShapes(AABB_SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] metaInt = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    public NiftyPathStairs() {
        super(NiftyBlock.PATH);
    }

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(meta -> NiftyPathStairs.combineShapes(meta, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (state.func_177229_b((IProperty)field_176308_b) == Half.TOP ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[metaInt[this.getShapeMeta(state)]];
    }

    private int getShapeMeta(BlockState state) {
        return ((StairsShape)state.func_177229_b((IProperty)field_176310_M)).ordinal() * 4 + ((Direction)state.func_177229_b((IProperty)field_176309_a)).func_176736_b();
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult result) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof HoeItem) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            worldIn.func_180501_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)((Block)ModBlocks.grass_stairs.get()).func_176223_P().func_206870_a((IProperty)field_176309_a, blockstate.func_177229_b((IProperty)field_176309_a))).func_206870_a((IProperty)field_176310_M, blockstate.func_177229_b((IProperty)field_176310_M))).func_206870_a((IProperty)field_176308_b, blockstate.func_177229_b((IProperty)field_176308_b))).func_206870_a((IProperty)field_204513_t, blockstate.func_177229_b((IProperty)field_204513_t)), 3);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            itemstack.func_222118_a(1, (LivingEntity)playerIn, user -> user.func_213334_d(hand));
            return true;
        }
        return super.func_220051_a(state, worldIn, pos, playerIn, hand, result);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

