/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty;

import java.util.function.Supplier;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ToolType;

public class NiftyBuilder {
    public final String name;
    public Material material = Material.field_151576_e;
    public MaterialColor color = this.material.func_151565_r();
    public SoundType sound = SoundType.field_185851_d;
    public float hardness = 0.0f;
    public float resistance = 0.0f;
    public ToolType harvestTool = null;
    public int harvestLevel = 0;
    public float fallMultiplier = 1.0f;
    public float slipperiness = 0.6f;
    public int[] burnTime = new int[]{0, 0, 0, 0, 0, 0};
    public boolean isBase = false;
    public boolean canOpen = false;
    public boolean hasPower = false;
    public boolean doesTick = false;
    public boolean hasConfig = false;
    public boolean isDirt = false;
    public boolean isGrass = false;
    public boolean isPath = false;
    public boolean isIce = false;
    public Supplier<ForgeConfigSpec.BooleanValue> booleanValue = null;

    public NiftyBuilder(String name) {
        this.name = name;
    }

    public NiftyBuilder properties(Material material) {
        this.material = material;
        this.color = material.func_151565_r();
        return this;
    }

    public NiftyBuilder properties(Material material, MaterialColor color) {
        this.material = material;
        this.color = color;
        return this;
    }

    public NiftyBuilder sound(SoundType sound) {
        this.sound = sound;
        return this;
    }

    public NiftyBuilder hardness(float amount) {
        this.hardness = amount;
        return this;
    }

    public NiftyBuilder hardnessAndResistance(float amount) {
        this.hardness = amount;
        this.resistance = amount;
        return this;
    }

    public NiftyBuilder hardnessAndResistance(float hard, float resist) {
        this.hardness = hard;
        this.resistance = resist;
        return this;
    }

    public NiftyBuilder tool(ToolType tool) {
        this.harvestTool = tool;
        return this;
    }

    public NiftyBuilder tool(ToolType tool, int level) {
        this.harvestTool = tool;
        this.harvestLevel = level;
        return this;
    }

    public NiftyBuilder fall(float amount) {
        this.fallMultiplier = amount;
        return this;
    }

    public NiftyBuilder slip(float amount) {
        this.slipperiness = amount;
        return this;
    }

    public NiftyBuilder burnTime(int door, int fence, int gate, int slab, int stairs, int trap) {
        this.burnTime = new int[]{door, fence, gate, slab, stairs, trap};
        return this;
    }

    public NiftyBuilder isBeaconBase() {
        this.isBase = true;
        return this;
    }

    public NiftyBuilder canOpen() {
        this.canOpen = true;
        return this;
    }

    public NiftyBuilder hasPower() {
        this.hasPower = true;
        return this;
    }

    public NiftyBuilder ticks() {
        this.doesTick = true;
        return this;
    }

    public NiftyBuilder isDirtMaterial() {
        this.isDirt = true;
        return this;
    }

    public NiftyBuilder isGrassMaterial() {
        this.isGrass = true;
        return this;
    }

    public NiftyBuilder isPathMaterial() {
        this.isPath = true;
        return this;
    }

    public NiftyBuilder isIceMaterial() {
        this.isIce = true;
        return this;
    }

    public NiftyBuilder config(Supplier<ForgeConfigSpec.BooleanValue> entry) {
        this.booleanValue = entry;
        this.hasConfig = true;
        return this;
    }
}

