/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty.blocks;

import com.androsa.nifty.ModBlocks;
import com.androsa.nifty.NiftyBuilder;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class NiftyDoor
extends DoorBlock {
    protected static final VoxelShape PATH_SOUTH_AABB_TOP = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)3.0);
    protected static final VoxelShape PATH_NORTH_AABB_TOP = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape PATH_WEST_AABB_TOP = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape PATH_EAST_AABB_TOP = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)15.0, (double)16.0);
    private final NiftyBuilder builder;
    protected boolean isReplacing = false;

    public NiftyDoor(Block.Properties props, NiftyBuilder builder) {
        super(props);
        this.builder = builder;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (this.builder.isPath) {
            boolean flag1;
            Direction direction = (Direction)state.func_177229_b((IProperty)field_176520_a);
            boolean flag = (Boolean)state.func_177229_b((IProperty)field_176519_b) == false;
            boolean bl = flag1 = state.func_177229_b((IProperty)field_176521_M) == DoorHingeSide.RIGHT;
            if (state.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.UPPER) {
                switch (direction) {
                    default: {
                        return flag ? PATH_EAST_AABB_TOP : (flag1 ? PATH_NORTH_AABB_TOP : PATH_SOUTH_AABB_TOP);
                    }
                    case SOUTH: {
                        return flag ? PATH_SOUTH_AABB_TOP : (flag1 ? PATH_EAST_AABB_TOP : PATH_WEST_AABB_TOP);
                    }
                    case WEST: {
                        return flag ? PATH_WEST_AABB_TOP : (flag1 ? PATH_SOUTH_AABB_TOP : PATH_NORTH_AABB_TOP);
                    }
                    case NORTH: 
                }
                return flag ? PATH_NORTH_AABB_TOP : (flag1 ? PATH_WEST_AABB_TOP : PATH_EAST_AABB_TOP);
            }
            switch (direction) {
                default: {
                    return flag ? field_185657_C : (flag1 ? field_185659_g : field_185658_f);
                }
                case SOUTH: {
                    return flag ? field_185658_f : (flag1 ? field_185657_C : field_185656_B);
                }
                case WEST: {
                    return flag ? field_185656_B : (flag1 ? field_185658_f : field_185659_g);
                }
                case NORTH: 
            }
            return flag ? field_185659_g : (flag1 ? field_185656_B : field_185657_C);
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_225503_b_(fallDistance, this.builder.fallMultiplier);
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return this.builder.hasPower;
    }

    @Deprecated
    public int func_180641_l(BlockState state, World worldIn, BlockPos pos) {
        return this.builder.hasPower && (Boolean)state.func_177229_b((IProperty)field_176522_N) != false ? 10 : 0;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        worldIn.func_175666_e(pos, (Block)this);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.builder.isDirt && !itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_196106_bc) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            if (blockstate.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.LOWER) {
                this.setBlocks((Supplier<? extends Block>)ModBlocks.grass_door, worldIn, pos, pos.func_177984_a(), DoubleBlockHalf.UPPER);
            } else {
                this.setBlocks((Supplier<? extends Block>)ModBlocks.grass_door, worldIn, pos, pos.func_177977_b(), DoubleBlockHalf.LOWER);
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.builder.isGrass && !itemstack.func_190926_b()) {
            if (itemstack.func_77973_b() instanceof HoeItem) {
                BlockState blockstate = worldIn.func_180495_p(pos);
                if (blockstate.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.LOWER) {
                    this.setBlocks((Supplier<? extends Block>)ModBlocks.dirt_door, worldIn, pos, pos.func_177984_a(), DoubleBlockHalf.UPPER);
                } else {
                    this.setBlocks((Supplier<? extends Block>)ModBlocks.dirt_door, worldIn, pos, pos.func_177977_b(), DoubleBlockHalf.LOWER);
                }
                worldIn.func_184133_a(null, pos, SoundEvents.field_187581_bW, SoundCategory.BLOCKS, 1.0f, 1.0f);
                itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
            if (itemstack.func_77973_b() instanceof ShovelItem) {
                BlockState blockstate = worldIn.func_180495_p(pos);
                if (blockstate.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.LOWER) {
                    this.setBlocks((Supplier<? extends Block>)ModBlocks.path_door, worldIn, pos, pos.func_177984_a(), DoubleBlockHalf.UPPER);
                } else {
                    this.setBlocks((Supplier<? extends Block>)ModBlocks.path_door, worldIn, pos, pos.func_177977_b(), DoubleBlockHalf.LOWER);
                }
                worldIn.func_184133_a(null, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
        }
        if (this.builder.isPath && !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof HoeItem) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            if (blockstate.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.LOWER) {
                this.setBlocks((Supplier<? extends Block>)ModBlocks.grass_door, worldIn, pos, pos.func_177984_a(), DoubleBlockHalf.UPPER);
            } else {
                this.setBlocks((Supplier<? extends Block>)ModBlocks.grass_door, worldIn, pos, pos.func_177977_b(), DoubleBlockHalf.LOWER);
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
            return ActionResultType.SUCCESS;
        }
        return this.performNormally(state, worldIn, pos, player);
    }

    public ActionResultType performNormally(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        if (!this.builder.canOpen) {
            return ActionResultType.PASS;
        }
        state = (BlockState)state.func_177231_a((IProperty)field_176519_b);
        worldIn.func_180501_a(pos, state, 10);
        worldIn.func_217378_a(player, (Boolean)state.func_177229_b((IProperty)field_176519_b) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        return ActionResultType.SUCCESS;
    }

    private void setBlocks(Supplier<? extends Block> block, World world, BlockPos selectPos, BlockPos nearPos, DoubleBlockHalf half) {
        BlockState blockstate = world.func_180495_p(selectPos);
        this.isReplacing = true;
        world.func_217377_a(selectPos, false);
        world.func_180501_a(nearPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.get().func_176223_P().func_206870_a((IProperty)field_176520_a, blockstate.func_177229_b((IProperty)field_176520_a))).func_206870_a((IProperty)field_176519_b, blockstate.func_177229_b((IProperty)field_176519_b))).func_206870_a((IProperty)field_176521_M, blockstate.func_177229_b((IProperty)field_176521_M))).func_206870_a((IProperty)field_176522_N, blockstate.func_177229_b((IProperty)field_176522_N))).func_206870_a((IProperty)field_176523_O, (Comparable)half), 3);
        world.func_180501_a(selectPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.get().func_176223_P().func_206870_a((IProperty)field_176520_a, blockstate.func_177229_b((IProperty)field_176520_a))).func_206870_a((IProperty)field_176519_b, blockstate.func_177229_b((IProperty)field_176519_b))).func_206870_a((IProperty)field_176521_M, blockstate.func_177229_b((IProperty)field_176521_M))).func_206870_a((IProperty)field_176522_N, blockstate.func_177229_b((IProperty)field_176522_N))).func_206870_a((IProperty)field_176523_O, blockstate.func_177229_b((IProperty)field_176523_O)), 3);
        this.isReplacing = false;
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f || this.field_149764_J == Material.field_151576_e ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f || this.field_149764_J == Material.field_151576_e ? 1005 : 1006;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (this.builder.hasConfig) {
            ForgeConfigSpec.BooleanValue val = this.builder.booleanValue.get();
            if (val == null) {
                throw new NullPointerException(this.builder.name + " expected a config value but found null.");
            }
            if (((Boolean)val.get()).booleanValue()) {
                super.func_176208_a(world, pos, state, player);
            }
        }
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (this.builder.isIce) {
            this.isReplacing = true;
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) == 0) {
                if (worldIn.field_73011_w.func_177500_n()) {
                    worldIn.func_217377_a(pos, false);
                    return;
                }
                Material material = worldIn.func_180495_p(pos.func_177977_b()).func_185904_a();
                if (material.func_76230_c() || material.func_76224_d()) {
                    worldIn.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
                }
            }
            this.isReplacing = false;
        }
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.builder.isIce && worldIn.func_226658_a_(LightType.BLOCK, pos) > 11 - state.func_200016_a((IBlockReader)worldIn, pos)) {
            this.turnIntoWater((World)worldIn, pos);
        }
    }

    protected void turnIntoWater(World world, BlockPos pos) {
        if (world.field_73011_w.func_177500_n()) {
            world.func_217377_a(pos, false);
        } else if (world.func_180495_p(pos).func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.LOWER) {
            world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            world.func_190524_a(pos, Blocks.field_150355_j, pos);
        } else {
            world.func_175656_a(pos.func_177972_a(Direction.DOWN), Blocks.field_150355_j.func_176223_P());
            world.func_190524_a(pos.func_177972_a(Direction.DOWN), Blocks.field_150355_j, pos.func_177972_a(Direction.DOWN));
        }
    }
}

