/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty.blocks;

import com.androsa.nifty.ModBlocks;
import com.androsa.nifty.NiftyBuilder;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class NiftyFenceGate
extends FenceGateBlock {
    protected static final VoxelShape PATH_HITBOX_ZAXIS = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)15.0, (double)10.0);
    protected static final VoxelShape PATH_HITBOX_XAXIS = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)15.0, (double)16.0);
    protected static final VoxelShape PATH_HITBOX_ZAXIS_INWALL = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0);
    protected static final VoxelShape PATH_HITBOX_XAXIS_INWALL = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)12.0, (double)16.0);
    protected static final VoxelShape PATH_COLLISION_BOX_ZAXIS = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)23.0, (double)10.0);
    protected static final VoxelShape PATH_COLLISION_BOX_XAXIS = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)23.0, (double)16.0);
    protected static final VoxelShape PATH_RENDER_BOX_Z = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)4.0, (double)7.0, (double)2.0, (double)15.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)14.0, (double)4.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    protected static final VoxelShape PATH_RENDER_BOX_X = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)4.0, (double)0.0, (double)9.0, (double)15.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)4.0, (double)14.0, (double)9.0, (double)15.0, (double)16.0));
    protected static final VoxelShape PATH_RENDER_BOX_INWALL_Z = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)1.0, (double)7.0, (double)2.0, (double)12.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)14.0, (double)1.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0));
    protected static final VoxelShape PATH_RENDER_BOX_INWALL_X = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)1.0, (double)0.0, (double)9.0, (double)12.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)1.0, (double)14.0, (double)9.0, (double)12.0, (double)16.0));
    private final NiftyBuilder builder;

    public NiftyFenceGate(Block.Properties props, NiftyBuilder builder) {
        super(props);
        this.builder = builder;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (this.builder.isPath) {
            if (((Boolean)state.func_177229_b((IProperty)field_176467_M)).booleanValue()) {
                return ((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == Direction.Axis.X ? PATH_HITBOX_XAXIS_INWALL : PATH_HITBOX_ZAXIS_INWALL;
            }
            return ((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == Direction.Axis.X ? PATH_HITBOX_XAXIS : PATH_HITBOX_ZAXIS;
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (this.builder.isPath) {
            if (((Boolean)state.func_177229_b((IProperty)field_176466_a)).booleanValue()) {
                return VoxelShapes.func_197880_a();
            }
            return ((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == Direction.Axis.Z ? PATH_COLLISION_BOX_ZAXIS : PATH_COLLISION_BOX_XAXIS;
        }
        return super.func_220071_b(state, worldIn, pos, context);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        if (this.builder.isPath) {
            if (((Boolean)state.func_177229_b((IProperty)field_176467_M)).booleanValue()) {
                return ((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == Direction.Axis.X ? PATH_RENDER_BOX_INWALL_X : PATH_RENDER_BOX_INWALL_Z;
            }
            return ((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == Direction.Axis.X ? PATH_RENDER_BOX_X : PATH_RENDER_BOX_Z;
        }
        return super.func_196247_c(state, worldIn, pos);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_225503_b_(fallDistance, this.builder.fallMultiplier);
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return this.builder.hasPower;
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader blockReader, BlockPos pos, Direction side) {
        return this.builder.hasPower ? 3 : 0;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.builder.isDirt && !itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_196106_bc) {
            this.setBlock(worldIn, pos, (Supplier<? extends Block>)ModBlocks.grass_fence_gate);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.builder.isGrass) {
            if (itemstack.func_77973_b() instanceof HoeItem) {
                this.setBlock(worldIn, pos, (Supplier<? extends Block>)ModBlocks.dirt_fence_gate);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187581_bW, SoundCategory.BLOCKS, 1.0f, 1.0f);
                itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
            if (itemstack.func_77973_b() instanceof ShovelItem) {
                this.setBlock(worldIn, pos, (Supplier<? extends Block>)ModBlocks.path_fence_gate);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
            }
        }
        if (this.builder.isPath && !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof HoeItem) {
            this.setBlock(worldIn, pos, (Supplier<? extends Block>)ModBlocks.grass_fence_gate);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
            return ActionResultType.SUCCESS;
        }
        return this.performNormally(state, worldIn, pos, player);
    }

    private ActionResultType performNormally(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        if (!this.builder.hasPower) {
            return ActionResultType.PASS;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176466_a)).booleanValue()) {
            state = (BlockState)state.func_206870_a((IProperty)field_176466_a, (Comparable)Boolean.FALSE);
            worldIn.func_180501_a(pos, state, 10);
        } else {
            Direction enumfacing = player.func_174811_aO();
            if (state.func_177229_b((IProperty)field_185512_D) == enumfacing.func_176734_d()) {
                state = (BlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)enumfacing);
            }
            state = (BlockState)state.func_206870_a((IProperty)field_176466_a, (Comparable)Boolean.TRUE);
            worldIn.func_180501_a(pos, state, 10);
        }
        worldIn.func_217378_a(player, (Boolean)state.func_177229_b((IProperty)field_176466_a) != false ? 1008 : 1014, pos, 0);
        return ActionResultType.SUCCESS;
    }

    private void setBlock(World world, BlockPos pos, Supplier<? extends Block> block) {
        BlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)block.get().func_176223_P().func_206870_a((IProperty)field_185512_D, state.func_177229_b((IProperty)field_185512_D))).func_206870_a((IProperty)field_176466_a, state.func_177229_b((IProperty)field_176466_a))).func_206870_a((IProperty)field_176465_b, state.func_177229_b((IProperty)field_176465_b))).func_206870_a((IProperty)field_176467_M, state.func_177229_b((IProperty)field_176467_M)));
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (this.builder.hasConfig) {
            ForgeConfigSpec.BooleanValue val = this.builder.booleanValue.get();
            if (val == null) {
                throw new NullPointerException(this.builder.name + " expected a config value but found null.");
            }
            if (((Boolean)val.get()).booleanValue()) {
                super.func_176208_a(world, pos, state, player);
            }
        }
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (this.builder.isIce && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) == 0) {
            if (worldIn.field_73011_w.func_177500_n()) {
                worldIn.func_217377_a(pos, false);
                return;
            }
            Material material = worldIn.func_180495_p(pos.func_177977_b()).func_185904_a();
            if (material.func_76230_c() || material.func_76224_d()) {
                worldIn.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            }
        }
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.builder.isIce && worldIn.func_226658_a_(LightType.BLOCK, pos) > 11 - state.func_200016_a((IBlockReader)worldIn, pos)) {
            this.turnIntoWater((World)worldIn, pos);
        }
    }

    protected void turnIntoWater(World world, BlockPos pos) {
        if (world.field_73011_w.func_177500_n()) {
            world.func_217377_a(pos, false);
        } else {
            world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            world.func_190524_a(pos, Blocks.field_150355_j, pos);
        }
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return this.builder.isIce ? PushReaction.NORMAL : super.func_149656_h(state);
    }
}

