/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty.blocks;

import com.androsa.nifty.ModBlocks;
import com.androsa.nifty.NiftyBuilder;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class NiftyTrapDoor
extends TrapDoorBlock {
    protected static final VoxelShape PATH_EAST_OPEN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PATH_WEST_OPEN_AABB = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PATH_SOUTH_OPEN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape PATH_NORTH_OPEN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PATH_BOTTOM_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape PATH_TOP_AABB = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private final NiftyBuilder builder;

    public NiftyTrapDoor(Block.Properties props, NiftyBuilder builder) {
        super(props);
        this.builder = builder;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (this.builder.isPath) {
            if (!((Boolean)state.func_177229_b((IProperty)field_176283_b)).booleanValue()) {
                return state.func_177229_b((IProperty)field_176285_M) == Half.TOP ? PATH_TOP_AABB : PATH_BOTTOM_AABB;
            }
            switch ((Direction)state.func_177229_b((IProperty)field_185512_D)) {
                default: {
                    return PATH_NORTH_OPEN_AABB;
                }
                case SOUTH: {
                    return PATH_SOUTH_OPEN_AABB;
                }
                case WEST: {
                    return PATH_WEST_OPEN_AABB;
                }
                case EAST: 
            }
            return PATH_EAST_OPEN_AABB;
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_225503_b_(fallDistance, this.builder.fallMultiplier);
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return this.builder.hasPower;
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader blockReader, BlockPos pos, Direction side) {
        return this.builder.hasPower ? 5 : 0;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.builder.isDirt && !itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_196106_bc) {
            this.setBlock(worldIn, pos, (Supplier<? extends Block>)ModBlocks.grass_trapdoor);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.builder.isGrass && !itemstack.func_190926_b()) {
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof HoeItem) {
                this.setBlock(worldIn, pos, (Supplier<? extends Block>)ModBlocks.dirt_trapdoor);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187581_bW, SoundCategory.BLOCKS, 1.0f, 1.0f);
                itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ShovelItem) {
                this.setBlock(worldIn, pos, (Supplier<? extends Block>)ModBlocks.path_trapdoor);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
        }
        if (this.builder.isPath && !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof HoeItem) {
            this.setBlock(worldIn, pos, (Supplier<? extends Block>)ModBlocks.grass_trapdoor);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            itemstack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
            return ActionResultType.SUCCESS;
        }
        return this.performNormally(state, worldIn, pos, player);
    }

    private ActionResultType performNormally(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (!this.builder.canOpen) {
            return ActionResultType.PASS;
        }
        state = (BlockState)state.func_177231_a((IProperty)field_176283_b);
        world.func_180501_a(pos, state, 2);
        if (((Boolean)state.func_177229_b((IProperty)field_204614_t)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        this.func_185731_a(player, world, pos, (Boolean)state.func_177229_b((IProperty)field_176283_b));
        return ActionResultType.SUCCESS;
    }

    private void setBlock(World world, BlockPos pos, Supplier<? extends Block> block) {
        BlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)block.get().func_176223_P().func_206870_a((IProperty)field_196381_c, state.func_177229_b((IProperty)field_196381_c))).func_206870_a((IProperty)field_176283_b, state.func_177229_b((IProperty)field_176283_b))).func_206870_a((IProperty)field_176285_M, state.func_177229_b((IProperty)field_176285_M))).func_206870_a((IProperty)field_204614_t, state.func_177229_b((IProperty)field_204614_t)));
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        BlockState state = worldIn.func_180495_p(pos);
        if (!(((Boolean)state.func_177229_b((IProperty)field_176283_b)).booleanValue() || this.field_149764_J != Material.field_151571_B && this.field_149764_J != Material.field_151584_j && this.field_149764_J != Material.field_151580_n && this.field_149764_J != Material.field_151578_c && this.field_149764_J != Material.field_151577_b)) {
            state = (BlockState)state.func_177231_a((IProperty)field_176283_b);
            worldIn.func_180501_a(pos, state, 2);
            this.func_185731_a(null, worldIn, pos, (Boolean)state.func_177229_b((IProperty)field_176283_b));
        }
    }

    protected void func_185731_a(@Nullable PlayerEntity player, World worldIn, BlockPos pos, boolean state) {
        if (state) {
            int i = this.field_149764_J == Material.field_151573_f ? 1037 : 1007;
            worldIn.func_217378_a(player, i, pos, 0);
        } else {
            int j = this.field_149764_J == Material.field_151573_f ? 1036 : 1013;
            worldIn.func_217378_a(player, j, pos, 0);
        }
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (this.builder.hasConfig) {
            ForgeConfigSpec.BooleanValue val = this.builder.booleanValue.get();
            if (val == null) {
                throw new NullPointerException(this.builder.name + " expected a config value but found null.");
            }
            if (((Boolean)val.get()).booleanValue()) {
                super.func_176208_a(world, pos, state, player);
            }
        }
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (this.builder.isIce && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) == 0) {
            if (worldIn.field_73011_w.func_177500_n()) {
                worldIn.func_217377_a(pos, false);
                return;
            }
            Material material = worldIn.func_180495_p(pos.func_177977_b()).func_185904_a();
            if (material.func_76230_c() || material.func_76224_d()) {
                worldIn.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            }
        }
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.builder.isIce && worldIn.func_226658_a_(LightType.BLOCK, pos) > 11 - state.func_200016_a((IBlockReader)worldIn, pos)) {
            this.turnIntoWater((World)worldIn, pos);
        }
    }

    protected void turnIntoWater(World world, BlockPos pos) {
        if (world.field_73011_w.func_177500_n()) {
            world.func_217377_a(pos, false);
        } else {
            world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            world.func_190524_a(pos, Blocks.field_150355_j, pos);
        }
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState state) {
        return this.builder.isIce ? PushReaction.NORMAL : super.func_149656_h(state);
    }
}

