/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty.data.conditions;

import com.androsa.nifty.NiftyConfig;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigCondition
implements ICondition {
    private final String config;

    public ConfigCondition(String config) {
        this.config = config;
    }

    public ResourceLocation getID() {
        return new ResourceLocation("nifty", "config");
    }

    public boolean test() {
        for (ConfigType type : ConfigType.values()) {
            if (!type.getConfigName().equals(this.config)) continue;
            return type.getConfig();
        }
        return false;
    }

    public String toString() {
        return "config";
    }

    private static enum ConfigType {
        IRON(() -> NiftyConfig.showIronBlocks),
        GOLD(() -> NiftyConfig.showGoldBlocks),
        DIAMOND(() -> NiftyConfig.showDiamondBlocks),
        EMERALD(() -> NiftyConfig.showEmeraldBlocks),
        LAPIS(() -> NiftyConfig.showLapisBlocks),
        OBSIDIAN(() -> NiftyConfig.showObsidianBlocks),
        COAL(() -> NiftyConfig.showCoalBlocks),
        REDSTONE(() -> NiftyConfig.showRedstoneBlocks),
        CLAY(() -> NiftyConfig.showClayBlocks),
        DIRT(() -> NiftyConfig.showDirtBlocks),
        GRASS(() -> NiftyConfig.showGrassBlocks),
        HAY(() -> NiftyConfig.showHayBlocks),
        PATH(() -> NiftyConfig.showPathBlocks),
        BRICK(() -> NiftyConfig.showBrickBlocks),
        QUARTZ(() -> NiftyConfig.showQuartzBlocks),
        BONE(() -> NiftyConfig.showBoneBlocks),
        NETHER_BRICK(() -> NiftyConfig.showNetherBrickBlocks),
        RED_NETHER_BRICK(() -> NiftyConfig.showRedNetherBrickBlocks),
        SNOW(() -> NiftyConfig.showSnowBlocks),
        ICE(() -> NiftyConfig.showIceBlocks),
        PACKED_ICE(() -> NiftyConfig.showPackedIceBlocks),
        BLUE_ICE(() -> NiftyConfig.showBlueIceBlocks);

        private Supplier<ForgeConfigSpec.BooleanValue> configValue;

        private ConfigType(Supplier<ForgeConfigSpec.BooleanValue> config) {
            this.configValue = config;
        }

        public String getConfigName() {
            return (String)this.configValue.get().getPath().get(0);
        }

        public boolean getConfig() {
            return (Boolean)this.configValue.get().get();
        }
    }

    public static class Serializer
    implements IConditionSerializer<ConfigCondition> {
        public void write(JsonObject json, ConfigCondition value) {
            json.addProperty("config", value.config);
        }

        public ConfigCondition read(JsonObject json) {
            return new ConfigCondition(JSONUtils.func_151200_h((JsonObject)json, (String)"config"));
        }

        public ResourceLocation getID() {
            return new ResourceLocation("nifty", "config");
        }
    }
}

