/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty.data.provider;

import com.androsa.nifty.data.provider.NiftyBlockModelProvider;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelFile;

public abstract class NiftyBlockStateProvider
extends BlockStateProvider {
    private final NiftyBlockModelProvider blockModels;

    public NiftyBlockStateProvider(DataGenerator generator, String modid, ExistingFileHelper helper) {
        super(generator, modid, helper);
        this.blockModels = new NiftyBlockModelProvider(generator, helper){

            protected void registerModels() {
            }

            public String func_200397_b() {
                return NiftyBlockStateProvider.this.func_200397_b();
            }
        };
    }

    @Nonnull
    public String func_200397_b() {
        return "Nifty Blockstates and Block Models";
    }

    public NiftyBlockModelProvider models() {
        return this.blockModels;
    }

    protected ResourceLocation locationVanilla(String name) {
        return new ResourceLocation("block/" + name);
    }

    protected ResourceLocation locationNifty(String name) {
        return new ResourceLocation("nifty", "block/" + name);
    }

    public void stairsBasic(Supplier<? extends StairsBlock> block, String name) {
        this.stairsBlock(block.get(), this.locationVanilla(name));
    }

    public void stairsMissing(Supplier<? extends StairsBlock> block) {
        this.stairsBlock(block.get(), this.locationNifty("missingno"));
    }

    public void stairsColumn(Supplier<? extends StairsBlock> block, String side, String end) {
        this.stairsBlock(block.get(), this.locationVanilla(side), this.locationVanilla(end), this.locationVanilla(end));
    }

    public void slabBasic(Supplier<? extends SlabBlock> block, String name) {
        this.slabBlock(block.get(), this.locationVanilla(name), this.locationVanilla(name));
    }

    public void slabMissing(Supplier<? extends SlabBlock> block) {
        this.slabBlock(block.get(), this.locationNifty("missingno"), this.locationNifty("missingno"));
    }

    public void slabModel(Supplier<? extends SlabBlock> block, String model, String name) {
        this.slabBlock(block.get(), this.locationVanilla(model), this.locationVanilla(name));
    }

    public void slabColumn(Supplier<? extends SlabBlock> block, String blockname, String side, String end) {
        this.slabBlock(block.get(), this.locationVanilla(blockname), this.locationVanilla(side), this.locationVanilla(end), this.locationVanilla(end));
    }

    public void fenceBasic(Supplier<? extends FenceBlock> block, String name) {
        this.fenceBlock(block.get(), this.locationVanilla(name));
    }

    public void fenceMissing(Supplier<? extends FenceBlock> block) {
        this.fenceBlock(block.get(), this.locationNifty("missingno"));
    }

    public void fenceColumn(Supplier<? extends FenceBlock> block, String side, String top) {
        String baseName = block.get().getRegistryName().toString();
        this.fourWayBlock((FourWayBlock)block.get(), (ModelFile)this.models().fencePostColumn(baseName + "_post", this.locationVanilla(side), this.locationVanilla(top)), (ModelFile)this.models().fenceSide(baseName + "_side", this.locationVanilla(side)));
    }

    public void trapdoorBasic(Supplier<? extends TrapDoorBlock> block, String name) {
        this.trapdoorBlock(block.get(), this.locationNifty(name + "_trapdoor"), true);
    }

    public void trapdoorMissing(Supplier<? extends TrapDoorBlock> block) {
        this.trapdoorBlock(block.get(), this.locationNifty("missingno"), false);
    }

    public void trapdoorVanilla(Supplier<? extends TrapDoorBlock> block, String name) {
        this.trapdoorBlock(block.get(), this.locationVanilla(name), false);
    }

    public void fenceGateBasic(Supplier<? extends FenceGateBlock> block, String name) {
        this.fenceGateBlock(block.get(), this.locationVanilla(name));
    }

    public void fenceGateMissing(Supplier<? extends FenceGateBlock> block) {
        this.fenceGateBlock(block.get(), this.locationNifty("missingno"));
    }

    public void fenceGateColumn(Supplier<? extends FenceGateBlock> block, String side, String top) {
        BlockModelBuilder gate = this.models().fenceGateColumn(block.get().getRegistryName().toString(), this.locationVanilla(side), this.locationVanilla(top));
        BlockModelBuilder gateOpen = this.models().fenceGateOpenColumn(block.get().getRegistryName().toString() + "_open", this.locationVanilla(side), this.locationVanilla(top));
        BlockModelBuilder gateWall = this.models().fenceGateWallColumn(block.get().getRegistryName().toString() + "_wall", this.locationVanilla(side), this.locationVanilla(top));
        BlockModelBuilder gateWallOpen = this.models().fenceGateWallOpenColumn(block.get().getRegistryName().toString() + "_wall_open", this.locationVanilla(side), this.locationVanilla(top));
        this.fenceGateBlock(block.get(), (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)gateWall, (ModelFile)gateWallOpen);
    }

    public void doorBasic(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlock(block.get(), this.locationNifty(name + "_door_bottom"), this.locationNifty(name + "_door_top"));
    }

    public void doorMissing(Supplier<? extends DoorBlock> block) {
        this.doorBlock(block.get(), this.locationNifty("missingno"), this.locationNifty("missingno"));
    }

    public void doorBasicVanilla(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlock(block.get(), this.locationVanilla(name), this.locationVanilla(name));
    }
}

