/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class IceGolemEntity
extends GolemEntity
implements IShearable {
    private static final DataParameter<Boolean> PUMPKIN_EQUIPPED = EntityDataManager.func_187226_a(IceGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected boolean canMelt = true;

    public IceGolemEntity(EntityType<? extends IceGolemEntity> entity, World world) {
        super(entity, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, target -> target instanceof IMob));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PUMPKIN_EQUIPPED, (Object)true);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("Pumpkin", this.isPumpkinEquipped());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("Pumpkin")) {
            this.setPumpkinEquipped(nbt.func_74767_n("Pumpkin"));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)this.func_226278_cu_());
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockPos blockPos = new BlockPos(i, 0, k);
            BlockPos blockPos2 = new BlockPos(i, j, k);
            if (this.field_70170_p.func_226691_t_(blockPos).func_225486_c(blockPos2) > 1.0f) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
        }
    }

    public boolean isPumpkinEquipped() {
        return (Boolean)this.field_70180_af.func_187225_a(PUMPKIN_EQUIPPED);
    }

    public void setPumpkinEquipped(boolean equipped) {
        this.field_70180_af.func_187227_b(PUMPKIN_EQUIPPED, (Object)equipped);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187799_fB;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187565_bO;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187561_bM;
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        return this.isPumpkinEquipped();
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        this.setPumpkinEquipped(false);
        return new ArrayList<ItemStack>();
    }

    public float func_213307_e(Pose pose) {
        return 1.7f;
    }
}

