/*
 * Decompiled with CFR 0.152.
 */
package com.androsa.nifty.entity.model;

import com.androsa.nifty.entity.AbstractGolemEntity;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractGolemModel<T extends AbstractGolemEntity>
extends SegmentedModel<T> {
    public ModelRenderer legL;
    public ModelRenderer legR;
    public ModelRenderer body;
    public ModelRenderer torso;
    public ModelRenderer armL;
    public ModelRenderer armR;
    public ModelRenderer head;
    private boolean useTimer;

    public AbstractGolemModel(int width, int height, boolean useTimer) {
        this.field_78090_t = width;
        this.field_78089_u = height;
        this.useTimer = useTimer;
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void setAngles(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.legL.field_78795_f = -1.5f * this.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
        this.legR.field_78795_f = 1.5f * this.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
        this.legL.field_78796_g = 0.0f;
        this.legR.field_78796_g = 0.0f;
    }

    public void setLivingAnimations(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        int attack = ((AbstractGolemEntity)((Object)entity)).getAttackTimer();
        if (attack > 0 && this.useTimer) {
            this.armR.field_78795_f = -2.0f + 1.5f * this.triangleWave((float)attack - partialTicks, 10.0f);
            this.armL.field_78795_f = -2.0f + 1.5f * this.triangleWave((float)attack - partialTicks, 10.0f);
        } else {
            this.swingArms(limbSwing, limbSwingAmount);
        }
    }

    protected void swingArms(float limbSwing, float limbSwingAmount) {
        this.armR.field_78795_f = (-0.2f + 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
        this.armL.field_78795_f = (-0.2f - 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
    }

    protected float triangleWave(float limbSwing, float amount) {
        return (Math.abs(limbSwing % amount - amount * 0.5f) - amount * 0.25f) / (amount * 0.25f);
    }
}

