/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.arl.block.BlockMod;
import vazkii.quark.automation.entity.EntityGravisand;
import vazkii.quark.base.block.IQuarkBlock;

public class BlockGravisand
extends BlockMod
implements IQuarkBlock {
    public BlockGravisand() {
        super("gravisand", Material.field_151595_p, new String[0]);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185855_h);
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkRedstone(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkRedstone(worldIn, pos);
    }

    private void checkRedstone(World worldIn, BlockPos pos) {
        boolean powered = worldIn.func_175640_z(pos);
        if (powered) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return 15;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && this.checkFallable(worldIn, pos)) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                BlockPos offPos = pos.func_177972_a(face);
                IBlockState offState = worldIn.func_180495_p(offPos);
                if (offState.func_177230_c() != this) continue;
                worldIn.func_175684_a(offPos, (Block)this, this.func_149738_a(worldIn));
            }
        }
    }

    private boolean checkFallable(World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            if (this.tryFall(worldIn, pos, EnumFacing.DOWN)) {
                return true;
            }
            return this.tryFall(worldIn, pos, EnumFacing.UP);
        }
        return false;
    }

    private boolean tryFall(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos target = pos.func_177972_a(facing);
        if ((worldIn.func_175623_d(target) || BlockGravisand.canFallThrough(worldIn.func_180495_p(target))) && pos.func_177956_o() >= 0) {
            EntityGravisand entity = new EntityGravisand(worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos), facing.func_96559_d());
            worldIn.func_72838_d((Entity)entity);
            return true;
        }
        return false;
    }

    public static boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150321_G || block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }
}

