/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.module;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import vazkii.quark.automation.base.ChainHandler;
import vazkii.quark.automation.block.IronChainBlock;
import vazkii.quark.automation.client.render.ChainRenderer;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.SyncChainMessage;

@LoadModule(category=ModuleCategory.AUTOMATION, hasSubscriptions=true)
public class ChainLinkageModule
extends Module {
    @Config(description="Can vehicle-linking chains be used for crafting chain armor?", flag="chain_craft_armor")
    public static boolean craftsArmor = true;
    public static Block chain;
    private static final IntObjectMap<UUID> AWAIT_MAP;

    @Override
    public void construct() {
        chain = new IronChainBlock(this);
    }

    public static void queueChainUpdate(int vehicle, UUID other) {
        if (other != null && !other.equals(SyncChainMessage.NULL_UUID)) {
            AWAIT_MAP.put(vehicle, (Object)other);
        }
    }

    public static void onEntityUpdate(Entity vehicle) {
        if (ChainHandler.canBeLinkedTo(vehicle)) {
            ChainHandler.adjustVehicle(vehicle);
        }
    }

    public static void drop(Entity vehicle) {
        if (ChainHandler.getLinked(vehicle) != null) {
            vehicle.func_70099_a(new ItemStack((IItemProvider)chain), 0.0f);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        Entity link = ChainHandler.getLinked(entity);
        boolean sneaking = player.func_70093_af();
        ArrayList<Entity> linkedToPlayer = new ArrayList<Entity>();
        for (Entity linkCandidate : entity.field_70170_p.func_217357_a(Entity.class, player.func_174813_aQ().func_186662_g(8.0))) {
            if (ChainHandler.getLinked(linkCandidate) != player) continue;
            linkedToPlayer.add(linkCandidate);
        }
        if (ChainHandler.canBeLinked(entity) && linkedToPlayer.isEmpty() && !stack.func_190926_b() && stack.func_77973_b() == chain.func_199767_j() && link == null) {
            if (!entity.field_70170_p.field_72995_K) {
                ChainHandler.setLink(entity, player.func_110124_au(), true);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        } else if (link == player) {
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        } else if (ChainHandler.canBeLinked(entity) && !linkedToPlayer.isEmpty()) {
            if (!entity.field_70170_p.field_72995_K) {
                for (Entity linked : linkedToPlayer) {
                    ChainHandler.setLink(linked, entity.func_110124_au(), true);
                }
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        } else if (link != null && sneaking) {
            if (!entity.field_70170_p.field_72995_K) {
                if (!player.func_184812_l_()) {
                    entity.func_70099_a(new ItemStack((IItemProvider)chain), 0.0f);
                }
                ChainHandler.setLink(entity, null, true);
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientUpdateTick(TickEvent.ClientTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.START) {
            ChainRenderer.updateTick();
        }
    }

    @SubscribeEvent
    public void onVehicleSeen(PlayerEvent.StartTracking event) {
        if (ChainHandler.canBeLinked(event.getTarget()) && event.getPlayer() instanceof ServerPlayerEntity) {
            QuarkNetwork.sendToPlayer(new SyncChainMessage(event.getTarget().func_145782_y(), ChainHandler.getLink(event.getTarget())), (ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onVehicleArrive(EntityJoinWorldEvent event) {
        Entity target = event.getEntity();
        if (event.getWorld().field_72995_K && ChainHandler.canBeLinked(target)) {
            int id = target.func_145782_y();
            if (AWAIT_MAP.containsKey(id)) {
                target.getPersistentData().func_186854_a("Quark:VehicleLink", (UUID)AWAIT_MAP.get(id));
            }
            AWAIT_MAP.remove(id);
        }
    }

    static {
        AWAIT_MAP = new IntObjectHashMap();
    }
}

