/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.quark.api.IQuarkButtonIgnored;
import vazkii.quark.base.Quark;
import vazkii.quark.base.client.ModKeybindHandler;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.handler.InventoryTransferHandler;
import vazkii.quark.base.module.Module;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="quark", value={Dist.CLIENT})
public final class InventoryButtonHandler {
    private static final Multimap<ButtonTargetType, ButtonProviderHolder> providers = Multimaps.newSetMultimap(new HashMap(), TreeSet::new);

    @SubscribeEvent
    public static void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (GeneralConfig.printScreenClassnames) {
            Quark.LOG.info("Opened screen {}", (Object)event.getGui().getClass().getName());
        }
        if (event.getGui() instanceof ContainerScreen && !(event.getGui() instanceof IQuarkButtonIgnored) && !GeneralConfig.ignoredScreens.contains(event.getGui().getClass().getName())) {
            Minecraft mc = Minecraft.func_71410_x();
            ContainerScreen screen = (ContainerScreen)event.getGui();
            if (screen instanceof InventoryScreen) {
                InventoryButtonHandler.applyProviders(event, ButtonTargetType.PLAYER_INVENTORY, screen, s -> s.field_75224_c == mc.field_71439_g.field_71071_by && s.getSlotIndex() == 17);
            } else if (InventoryTransferHandler.accepts(screen.func_212873_a_(), (PlayerEntity)mc.field_71439_g)) {
                InventoryButtonHandler.applyProviders(event, ButtonTargetType.CONTAINER_INVENTORY, screen, s -> s.field_75224_c != mc.field_71439_g.field_71071_by && s.getSlotIndex() == 8);
                InventoryButtonHandler.applyProviders(event, ButtonTargetType.CONTAINER_PLAYER_INVENTORY, screen, s -> s.field_75224_c == mc.field_71439_g.field_71071_by && s.getSlotIndex() == 17);
            }
        }
    }

    private static Collection<ButtonProviderHolder> forGui(Screen gui) {
        HashSet<ButtonProviderHolder> holders = new HashSet<ButtonProviderHolder>();
        if (gui instanceof ContainerScreen) {
            ContainerScreen screen = (ContainerScreen)gui;
            if (gui instanceof InventoryScreen) {
                holders.addAll(providers.get((Object)ButtonTargetType.PLAYER_INVENTORY));
            } else {
                Minecraft mc = Minecraft.func_71410_x();
                if (InventoryTransferHandler.accepts(screen.func_212873_a_(), (PlayerEntity)mc.field_71439_g)) {
                    holders.addAll(providers.get((Object)ButtonTargetType.CONTAINER_INVENTORY));
                    holders.addAll(providers.get((Object)ButtonTargetType.CONTAINER_PLAYER_INVENTORY));
                }
            }
        }
        return holders;
    }

    @SubscribeEvent
    public static void mouseInputEvent(GuiScreenEvent.MouseClickedEvent.Pre pressed) {
        Screen gui = pressed.getGui();
        if (gui instanceof ContainerScreen) {
            ContainerScreen screen = (ContainerScreen)gui;
            Collection<ButtonProviderHolder> holders = InventoryButtonHandler.forGui((Screen)screen);
            for (ButtonProviderHolder holder : holders) {
                if (holder.keybind == null || !holder.keybind.func_197984_a(pressed.getButton()) || !holder.keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI)) continue;
                holder.pressed.accept(screen);
            }
        }
    }

    @SubscribeEvent
    public static void keyboardInputEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Post pressed) {
        Screen gui = pressed.getGui();
        if (gui instanceof ContainerScreen) {
            ContainerScreen screen = (ContainerScreen)gui;
            Collection<ButtonProviderHolder> holders = InventoryButtonHandler.forGui((Screen)screen);
            for (ButtonProviderHolder holder : holders) {
                if (holder.keybind == null || !holder.keybind.func_197976_a(pressed.getKeyCode(), pressed.getScanCode()) || !holder.keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI)) continue;
                holder.pressed.accept(screen);
            }
        }
    }

    private static void applyProviders(GuiScreenEvent.InitGuiEvent.Post event, ButtonTargetType type, ContainerScreen<?> screen, Predicate<Slot> slotPred) {
        Collection holders = providers.get((Object)type);
        if (!holders.isEmpty()) {
            for (Slot slot : screen.func_212873_a_().field_75151_b) {
                if (!slotPred.test(slot)) continue;
                int x = slot.field_75223_e + 6;
                int y = slot.field_75221_f - 13;
                for (ButtonProviderHolder holder : holders) {
                    Button button = holder.getButton(screen, x, y);
                    if (button == null) continue;
                    event.addWidget((Widget)button);
                    x -= 12;
                }
                return;
            }
        }
    }

    public static void addButtonProvider(Module module, ButtonTargetType type, int priority, KeyBinding binding, Consumer<ContainerScreen<?>> onKeybind, ButtonProvider provider) {
        providers.put((Object)type, (Object)new ButtonProviderHolder(module, priority, provider, binding, onKeybind));
    }

    public static void addButtonProvider(Module module, ButtonTargetType type, int priority, String keybindName, Consumer<ContainerScreen<?>> onKeybind, ButtonProvider provider) {
        InventoryButtonHandler.addButtonProvider(module, type, priority, ModKeybindHandler.init(keybindName, null, "quark.gui.keygroup.inv"), onKeybind, provider);
    }

    public static void addButtonProvider(Module module, ButtonTargetType type, int priority, ButtonProvider provider) {
        providers.put((Object)type, (Object)new ButtonProviderHolder(module, priority, provider));
    }

    private static class ButtonProviderHolder
    implements Comparable<ButtonProviderHolder> {
        private final int priority;
        private final Module module;
        private final ButtonProvider provider;
        private final KeyBinding keybind;
        private final Consumer<ContainerScreen<?>> pressed;

        public ButtonProviderHolder(Module module, int priority, ButtonProvider provider, KeyBinding keybind, Consumer<ContainerScreen<?>> onPressed) {
            this.module = module;
            this.priority = priority;
            this.provider = provider;
            this.keybind = keybind;
            this.pressed = onPressed;
        }

        public ButtonProviderHolder(Module module, int priority, ButtonProvider provider) {
            this(module, priority, provider, null, screen -> {});
        }

        @Override
        public int compareTo(@Nonnull ButtonProviderHolder o) {
            return this.priority - o.priority;
        }

        public Button getButton(ContainerScreen<?> parent, int x, int y) {
            return this.module.enabled ? this.provider.provide(parent, x, y) : null;
        }
    }

    public static interface ButtonProvider {
        public Button provide(ContainerScreen<?> var1, int var2, int var3);
    }

    public static enum ButtonTargetType {
        PLAYER_INVENTORY,
        CONTAINER_INVENTORY,
        CONTAINER_PLAYER_INVENTORY;

    }
}

