/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.module;

import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.DoubleDoorMessage;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class DoubleDoorOpeningModule
extends Module {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (!event.getWorld().field_72995_K || event.getPlayer().func_70093_af() || event.isCanceled() || event.getResult() == Event.Result.DENY || event.getUseBlock() == Event.Result.DENY) {
            return;
        }
        World world = event.getWorld();
        if (world.func_180495_p(pos = event.getPos()).func_177230_c() instanceof DoorBlock) {
            DoubleDoorOpeningModule.openDoor(world, pos);
            QuarkNetwork.sendToServer(new DoubleDoorMessage(pos));
        }
    }

    public static void openDoor(World world, BlockPos pos) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(DoubleDoorOpeningModule.class) || world == null) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        Direction direction = (Direction)state.func_177229_b((IProperty)DoorBlock.field_176520_a);
        boolean isOpen = (Boolean)state.func_177229_b((IProperty)DoorBlock.field_176519_b);
        DoorHingeSide isMirrored = (DoorHingeSide)state.func_177229_b((IProperty)DoorBlock.field_176521_M);
        BlockPos mirrorPos = pos.func_177972_a(isMirrored == DoorHingeSide.RIGHT ? direction.func_176735_f() : direction.func_176746_e());
        BlockPos doorPos = state.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER ? mirrorPos : mirrorPos.func_177977_b();
        BlockState other = world.func_180495_p(doorPos);
        if (state.func_185904_a() != Material.field_151573_f && other.func_177230_c() == state.func_177230_c() && other.func_177229_b((IProperty)DoorBlock.field_176520_a) == direction && (Boolean)other.func_177229_b((IProperty)DoorBlock.field_176519_b) == isOpen && other.func_177229_b((IProperty)DoorBlock.field_176521_M) != isMirrored) {
            BlockState newState = (BlockState)other.func_177231_a((IProperty)DoorBlock.field_176519_b);
            world.func_175656_a(doorPos, newState);
        }
    }
}

