/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.client.emote;

import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.aurelienribon.tweenengine.Timeline;
import vazkii.aurelienribon.tweenengine.TweenManager;
import vazkii.quark.vanity.client.emote.EmoteDescriptor;
import vazkii.quark.vanity.client.emote.EmoteState;

@OnlyIn(value=Dist.CLIENT)
public abstract class EmoteBase {
    public static final float PI_F = (float)Math.PI;
    public final EmoteDescriptor desc;
    private final TweenManager emoteManager;
    private final BipedModel<?> model;
    private final BipedModel<?> armorModel;
    private final BipedModel<?> armorLegsModel;
    private final EmoteState state;
    private final PlayerEntity player;
    public float timeDone;
    public float totalTime;
    public float animatedTime;
    private long lastMs;

    public EmoteBase(EmoteDescriptor desc, PlayerEntity player, BipedModel<?> model, BipedModel<?> armorModel, BipedModel<?> armorLegsModel) {
        this.desc = desc;
        this.emoteManager = new TweenManager();
        this.state = new EmoteState(this);
        this.model = model;
        this.armorModel = armorModel;
        this.armorLegsModel = armorLegsModel;
        this.player = player;
    }

    public void startAllTimelines() {
        this.startTimeline(this.player, this.model);
        this.startTimeline(this.player, this.armorModel);
        this.startTimeline(this.player, this.armorLegsModel);
        this.lastMs = System.currentTimeMillis();
    }

    void startTimeline(PlayerEntity player, BipedModel<?> model) {
        Timeline timeline = (Timeline)this.getTimeline(player, model).start(this.emoteManager);
        this.totalTime = timeline.getFullDuration();
    }

    public abstract Timeline getTimeline(PlayerEntity var1, BipedModel<?> var2);

    public abstract boolean usesBodyPart(int var1);

    public void rotateAndOffset() {
        this.state.rotateAndOffset(this.player);
    }

    public void update() {
        this.state.load(this.model);
        this.state.load(this.armorModel);
        this.state.load(this.armorLegsModel);
        long currTime = System.currentTimeMillis();
        long timeDiff = currTime - this.lastMs;
        this.animatedTime += (float)timeDiff;
        this.emoteManager.update(timeDiff);
        this.state.save(this.model);
        this.lastMs = currTime;
        this.timeDone += (float)timeDiff;
    }

    public boolean isDone() {
        return this.timeDone >= this.totalTime || this.player.field_70733_aJ > 0.0f || this.player.field_70737_aN > 0;
    }
}

