/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import vazkii.quark.base.world.generator.multichunk.ClusterBasedGenerator;
import vazkii.quark.world.config.UndergroundBiomeConfig;

public class UndergroundBiomeGenerator
extends ClusterBasedGenerator {
    public final UndergroundBiomeConfig info;

    public UndergroundBiomeGenerator(UndergroundBiomeConfig info, String name) {
        super(info.dimensions, info, (long)name.hashCode());
        this.info = info;
    }

    @Override
    public int getFeatureRadius() {
        return this.info.horizontalSize + this.info.horizontalVariation;
    }

    @Override
    public BlockPos[] getSourcesInChunk(Random random, ChunkGenerator<? extends GenerationSettings> generator, BlockPos chunkCorner) {
        if (this.info.rarity > 0 && random.nextInt(this.info.rarity) == 0) {
            return new BlockPos[]{chunkCorner.func_177982_a(random.nextInt(16), this.info.minYLevel + random.nextInt(this.info.maxYLevel - this.info.minYLevel), random.nextInt(16))};
        }
        return new BlockPos[0];
    }

    @Override
    public ClusterBasedGenerator.IGenerationContext createContext(BlockPos src, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos chunkCorner, IWorld world) {
        return new Context(world, src, generator, random, this.info);
    }

    @Override
    public boolean isSourceValid(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, BlockPos pos) {
        Biome biome = this.getBiome(generator, pos);
        return this.info.biomes.canSpawn(biome);
    }

    public String toString() {
        return "UndergroundBiomeGenerator[" + this.info.biomeObj + "]";
    }

    public static class Context
    implements ClusterBasedGenerator.IFinishableContext {
        public final IWorld world;
        public final BlockPos source;
        public final ChunkGenerator<? extends GenerationSettings> generator;
        public final Random random;
        public final UndergroundBiomeConfig info;
        public final List<BlockPos> floorList = new LinkedList<BlockPos>();
        public final List<BlockPos> ceilingList = new LinkedList<BlockPos>();
        public final List<BlockPos> insideList = new LinkedList<BlockPos>();
        public final Map<BlockPos, Direction> wallMap = new HashMap<BlockPos, Direction>();

        public Context(IWorld world, BlockPos source, ChunkGenerator<? extends GenerationSettings> generator, Random random, UndergroundBiomeConfig info) {
            this.world = world;
            this.source = source;
            this.generator = generator;
            this.random = random;
            this.info = info;
        }

        @Override
        public void consume(BlockPos pos) {
            this.info.biomeObj.fill(this, pos);
        }

        @Override
        public void finish() {
            this.floorList.forEach(pos -> this.info.biomeObj.finalFloorPass(this, (BlockPos)pos));
            this.ceilingList.forEach(pos -> this.info.biomeObj.finalCeilingPass(this, (BlockPos)pos));
            this.wallMap.keySet().forEach(pos -> this.info.biomeObj.finalWallPass(this, (BlockPos)pos));
            this.insideList.forEach(pos -> this.info.biomeObj.finalInsidePass(this, (BlockPos)pos));
        }
    }
}

