/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.quartzchests;

import dev.latvian.mods.quartzchests.QuartzChestsCommon;
import dev.latvian.mods.quartzchests.block.QuartzChestBlock;
import dev.latvian.mods.quartzchests.block.QuartzChestsBlocks;
import dev.latvian.mods.quartzchests.block.entity.QuartzChestEntity;
import dev.latvian.mods.quartzchests.client.QuartzChestsClient;
import dev.latvian.mods.quartzchests.gui.QuartzChestContainer;
import dev.latvian.mods.quartzchests.net.QuartzChestsNet;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;

@Mod(value="quartzchests")
public class QuartzChests {
    public static final String MOD_ID = "quartzchests";
    public final QuartzChests instance = this;
    public final QuartzChestsCommon proxy = (QuartzChestsCommon)DistExecutor.runForDist(() -> () -> new QuartzChestsClient(), () -> () -> new QuartzChestsCommon());

    public QuartzChests() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, this::registerBlockEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, this::registerContainers);
        this.proxy.init();
    }

    private void init(FMLCommonSetupEvent event) {
        QuartzChestsNet.init();
    }

    private void registerBlocks(RegistryEvent.Register<Block> event) {
        Block.Properties properties = Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151677_p);
        properties.func_200943_b(2.0f);
        properties.func_200947_a(SoundType.field_185848_a);
        event.getRegistry().register(new QuartzChestBlock(properties).setRegistryName("chest"));
    }

    private void registerItems(RegistryEvent.Register<Item> event) {
        Item.Properties properties = new Item.Properties().func_200916_a(ItemGroup.field_78031_c).func_200917_a(16);
        this.proxy.setQuartzChestTESIR(properties);
        event.getRegistry().register(new BlockItem(QuartzChestsBlocks.CHEST, properties).setRegistryName("chest"));
        Item.Properties upgradeProperties = new Item.Properties().func_200916_a(ItemGroup.field_78026_f);
        event.getRegistry().register(new Item(upgradeProperties).setRegistryName("upgrade"));
        event.getRegistry().register(new Item(upgradeProperties).setRegistryName("keep_inventory_upgrade"));
        event.getRegistry().register(new Item(upgradeProperties).setRegistryName("glowing_text_upgrade"));
        event.getRegistry().register(new Item(upgradeProperties).setRegistryName("bold_text_upgrade"));
        event.getRegistry().register(new Item(upgradeProperties).setRegistryName("italic_text_upgrade"));
    }

    private void registerBlockEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(QuartzChestEntity::new, (Block[])new Block[]{QuartzChestsBlocks.CHEST}).func_206865_a(null).setRegistryName("chest"));
    }

    private void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().register(new ContainerType((ContainerType.IFactory)((IContainerFactory)QuartzChestContainer::new)).setRegistryName("chest"));
    }
}

