/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.quartzchests.client;

import com.mojang.blaze3d.platform.GlStateManager;
import dev.latvian.mods.quartzchests.block.QuartzChestsBlocks;
import dev.latvian.mods.quartzchests.block.entity.ColorType;
import dev.latvian.mods.quartzchests.block.entity.QuartzChestEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class QuartzChestRenderer
extends TileEntityRenderer<QuartzChestEntity> {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("quartzchests", "textures/block/chest_base.png");
    private static final ResourceLocation TEXTURE_BORDERS = new ResourceLocation("quartzchests", "textures/block/chest_borders.png");
    private final QuartzChestModel baseModel = new QuartzChestModel();
    private final QuartzChestModel bordersModel = new QuartzChestModel();

    public void render(QuartzChestEntity chest, double x, double y, double z, float partialTicks, int destroyStage) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockState state = chest.func_145830_o() ? chest.func_195044_w() : (BlockState)QuartzChestsBlocks.CHEST.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotatef((float)(((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D)).func_185119_l() + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (chest.func_145830_o()) {
            double angle = MathHelper.func_219803_d((double)partialTicks, (double)chest.prevLidAngle, (double)chest.lidAngle);
            angle = 1.0 - angle;
            angle = 1.0 - angle * angle * angle;
            ((QuartzChestModel)this.baseModel).top.field_78795_f = ((QuartzChestModel)this.bordersModel).top.field_78795_f = -((float)(angle * Math.PI / 2.0));
        } else {
            ((QuartzChestModel)this.bordersModel).top.field_78795_f = 0.0f;
            ((QuartzChestModel)this.baseModel).top.field_78795_f = 0.0f;
        }
        this.func_147499_a(destroyStage >= 0 ? field_178460_a[destroyStage] : TEXTURE_BASE);
        int cc = chest.colors[ColorType.CHEST.index];
        GlStateManager.color4f((float)((float)(cc >> 16 & 0xFF) / 255.0f), (float)((float)(cc >> 8 & 0xFF) / 255.0f), (float)((float)(cc & 0xFF) / 255.0f), (float)1.0f);
        this.baseModel.renderAll();
        if (destroyStage < 0) {
            this.func_147499_a(TEXTURE_BORDERS);
            int bc = chest.colors[ColorType.BORDER.index];
            GlStateManager.color4f((float)((float)(bc >> 16 & 0xFF) / 255.0f), (float)((float)(bc >> 8 & 0xFF) / 255.0f), (float)((float)(bc & 0xFF) / 255.0f), (float)1.0f);
            this.bordersModel.renderAll();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!chest.func_145830_o() || ((QuartzChestModel)this.baseModel).top.field_78795_f == 0.0f) {
                if (chest.textGlow && chest.func_145830_o()) {
                    this.func_190053_a(true);
                }
                GlStateManager.disableLighting();
                GlStateManager.enableBlend();
                GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.depthMask((boolean)true);
                GlStateManager.enableAlphaTest();
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)0.5f, (float)0.22f, (float)0.062f);
                String label = chest.label;
                if (chest.textBold) {
                    label = TextFormatting.BOLD + label;
                }
                if (chest.textItalic) {
                    label = TextFormatting.ITALIC + label;
                }
                int sw1 = this.func_147498_b().func_78256_a(label);
                float f1 = 1.0f / (float)Math.max(sw1 + 30, 64);
                GlStateManager.scalef((float)f1, (float)f1, (float)1.0f);
                this.func_147498_b().func_211126_b(label, (float)(-sw1) / 2.0f, 0.0f, 0xFF000000 | chest.colors[ColorType.TEXT.index]);
                GlStateManager.popMatrix();
                if (chest.textGlow && chest.func_145830_o()) {
                    this.func_190053_a(false);
                }
            }
            if (!chest.icon.func_190926_b()) {
                GlStateManager.pushMatrix();
                try {
                    Block b = Block.func_149634_a((Item)chest.icon.func_77973_b());
                    if (b == Blocks.field_150350_a) {
                        GlStateManager.translatef((float)0.5f, (float)0.67f, (float)0.04f);
                        float iS = 0.4f;
                        GlStateManager.scalef((float)(-iS), (float)(-iS), (float)iS);
                    } else {
                        GlStateManager.translatef((float)0.5f, (float)0.67f, (float)0.15f);
                        float iS = 0.7f;
                        GlStateManager.scalef((float)(-iS), (float)(-iS), (float)iS);
                    }
                    mc.func_175599_af().func_181564_a(chest.icon, ItemCameraTransforms.TransformType.FIXED);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GlStateManager.popMatrix();
            }
        }
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    private static class QuartzChestModel
    extends Model {
        private final RendererModel top = new RendererModel((Model)this, 0, 0).func_78787_b(64, 64);
        private final RendererModel bottom;

        public QuartzChestModel() {
            this.top.func_78790_a(0.0f, -5.0f, -14.0f, 14, 5, 14, 0.0f);
            this.top.field_78800_c = 1.0f;
            this.top.field_78797_d = 7.0f;
            this.top.field_78798_e = 15.0f;
            this.bottom = new RendererModel((Model)this, 0, 19).func_78787_b(64, 64);
            this.bottom.func_78790_a(0.0f, 0.0f, 0.0f, 14, 10, 14, 0.0f);
            this.bottom.field_78800_c = 1.0f;
            this.bottom.field_78797_d = 6.0f;
            this.bottom.field_78798_e = 1.0f;
        }

        public void renderAll() {
            this.top.func_78785_a(0.0625f);
            this.bottom.func_78785_a(0.0625f);
        }
    }
}

