/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.quartzchests.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import dev.latvian.mods.quartzchests.block.QuartzChestsBlocks;
import dev.latvian.mods.quartzchests.block.entity.ColorType;
import dev.latvian.mods.quartzchests.gui.QuartzChestContainer;
import dev.latvian.mods.quartzchests.gui.QuartzChestScreen;
import dev.latvian.mods.quartzchests.net.QuartzChestsNet;
import dev.latvian.mods.quartzchests.net.SetColorMessage;
import java.util.Arrays;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.glfw.GLFW;

public class ColorSelectorScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("quartzchests", "textures/gui/color_selector.png");
    private static final ResourceLocation HUE_TEXTURE = new ResourceLocation("quartzchests", "textures/gui/color_selector_hue.png");
    public final ColorType type;
    private TextFieldWidget colorField;
    public final QuartzChestScreen parent;
    private int xSize = 234;
    private int ySize = 107;
    private ItemStack preview;
    private int prevColor;
    private float[] rgb;
    private float[] hsb;
    private float[] rgbMinS;
    private float[] rgbMaxS;
    private float[] rgbMinB;
    private float[] rgbMaxB;
    private double prevMouseX;

    public ColorSelectorScreen(QuartzChestScreen s, ColorType t) {
        super((ITextComponent)new TranslationTextComponent(t.translationKey, new Object[0]));
        this.parent = s;
        this.type = t;
        this.preview = new ItemStack((IItemProvider)QuartzChestsBlocks.CHEST);
        this.prevColor = ((QuartzChestContainer)s.func_212873_a_()).chest.colors[t.index];
        this.rgb = new float[3];
        this.hsb = new float[3];
        this.rgbMinS = new float[3];
        this.rgbMaxS = new float[3];
        this.rgbMinB = new float[3];
        this.rgbMaxB = new float[3];
    }

    protected void init() {
        super.init();
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.minecraft.field_195559_v.func_197967_a(true);
        this.colorField = new TextFieldWidget(this.font, x + 11, y + 20, 116, 9, this.title.getString());
        this.colorField.func_146205_d(true);
        this.colorField.func_146193_g(-1);
        this.colorField.func_146204_h(-1);
        this.colorField.func_146185_a(false);
        this.colorField.func_146203_f(50);
        this.colorField.func_146193_g(0xFF000000 | ((QuartzChestContainer)this.parent.func_212873_a_()).chest.colors[this.type.index]);
        this.colorField.func_212954_a(this::setColor);
        this.children.add(this.colorField);
        this.addButton((Widget)new Button(x + 9, y + 79, 41, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), b -> {
            this.setColor(this.prevColor, false);
            this.minecraft.func_147108_a((Screen)this.parent);
        }));
        this.addButton((Widget)new Button(x + 51, y + 79, 37, 20, "Def", b -> this.setColor(this.type.defaultColor, true)));
        this.addButton((Widget)new Button(x + 89, y + 79, 41, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> this.minecraft.func_147108_a((Screen)this.parent)));
        this.setColor(((QuartzChestContainer)this.parent.func_212873_a_()).chest.colors[this.type.index], true);
    }

    private void convertHSBtoRGB(float[] hsb, float[] rgb) {
        if (hsb[1] <= 0.0f) {
            rgb[1] = rgb[2] = hsb[2];
            rgb[0] = rgb[2];
            return;
        }
        float h = (hsb[0] - (float)Math.floor(hsb[0])) * 6.0f;
        float f = h - (float)Math.floor(h);
        float p = hsb[2] * (1.0f - hsb[1]);
        float q = hsb[2] * (1.0f - hsb[1] * f);
        float t = hsb[2] * (1.0f - hsb[1] * (1.0f - f));
        switch ((int)h) {
            case 0: {
                rgb[0] = hsb[2];
                rgb[1] = t;
                rgb[2] = p;
                return;
            }
            case 1: {
                rgb[0] = q;
                rgb[1] = hsb[2];
                rgb[2] = p;
                return;
            }
            case 2: {
                rgb[0] = p;
                rgb[1] = hsb[2];
                rgb[2] = t;
                return;
            }
            case 3: {
                rgb[0] = p;
                rgb[1] = q;
                rgb[2] = hsb[2];
                return;
            }
            case 4: {
                rgb[0] = t;
                rgb[1] = p;
                rgb[2] = hsb[2];
                return;
            }
            case 5: {
                rgb[0] = hsb[2];
                rgb[1] = p;
                rgb[2] = q;
            }
        }
    }

    private void convertRGBtoHSB(float[] rgb, float[] hsb) {
        float cmin;
        float cmax = Math.max(rgb[0], rgb[1]);
        if (rgb[2] > cmax) {
            cmax = rgb[2];
        }
        if (rgb[2] < (cmin = Math.min(rgb[0], rgb[1]))) {
            cmin = rgb[2];
        }
        hsb[2] = cmax;
        hsb[1] = cmax != 0.0f ? (cmax - cmin) / cmax : 0.0f;
        if (hsb[1] == 0.0f) {
            hsb[0] = 0.0f;
        } else {
            float redc = (cmax - rgb[0]) / (cmax - cmin);
            float greenc = (cmax - rgb[1]) / (cmax - cmin);
            float bluec = (cmax - rgb[2]) / (cmax - cmin);
            hsb[0] = rgb[0] == cmax ? bluec - greenc : (rgb[1] == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            hsb[0] = hsb[0] / 6.0f;
            if (hsb[0] < 0.0f) {
                hsb[0] = hsb[0] + 1.0f;
            }
        }
    }

    private int getRGB(float[] rgb) {
        return 0xFF000000 | (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
    }

    private void setRGB(int c, float[] rgb) {
        rgb[0] = (float)(c >> 16 & 0xFF) / 255.0f;
        rgb[1] = (float)(c >> 8 & 0xFF) / 255.0f;
        rgb[2] = (float)(c & 0xFF) / 255.0f;
    }

    public void setColor(int color, boolean updateText) {
        if (updateText) {
            this.colorField.func_146180_a(String.format("#%06X", 0xFFFFFF & color));
            return;
        }
        this.colorField.func_146193_g(0xFF000000 | color);
        ((QuartzChestContainer)this.parent.func_212873_a_()).chest.colors[this.type.index] = color;
        CompoundNBT data = new CompoundNBT();
        ((QuartzChestContainer)this.parent.func_212873_a_()).chest.writeVisualData(data);
        this.preview.func_77983_a("BlockEntityTag", (INBT)data);
        this.setRGB(color, this.rgb);
        this.convertRGBtoHSB(this.rgb, this.hsb);
        float[] hsbMinS = Arrays.copyOf(this.hsb, 3);
        float[] hsbMaxS = Arrays.copyOf(this.hsb, 3);
        float[] hsbMinB = Arrays.copyOf(this.hsb, 3);
        float[] hsbMaxB = Arrays.copyOf(this.hsb, 3);
        hsbMinS[1] = 0.0f;
        hsbMaxS[1] = 1.0f;
        hsbMinB[2] = 0.0f;
        hsbMaxB[2] = 1.0f;
        this.convertHSBtoRGB(hsbMinS, this.rgbMinS);
        this.convertHSBtoRGB(hsbMaxS, this.rgbMaxS);
        this.convertHSBtoRGB(hsbMinB, this.rgbMinB);
        this.convertHSBtoRGB(hsbMaxB, this.rgbMaxB);
        QuartzChestsNet.MAIN.sendToServer((Object)new SetColorMessage(((QuartzChestContainer)this.parent.func_212873_a_()).chest.func_174877_v(), this.type, color));
    }

    public void setColor(String color) {
        if (color.length() == 7 && color.startsWith("#")) {
            try {
                this.setColor(0xFFFFFF & Integer.parseInt(color.substring(1), 16), false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removed() {
        super.removed();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void onClose() {
        this.minecraft.field_71439_g.func_71053_j();
    }

    public boolean keyPressed(int keyCode, int scanCode, int other) {
        if (this.colorField.isFocused()) {
            if (keyCode == 257) {
                this.colorField.func_146195_b(false);
            } else if (keyCode != 256) {
                this.colorField.keyPressed(keyCode, scanCode, other);
                return true;
            }
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode == 256 || this.minecraft.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, other);
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (button == 0 && this.checkHSBMouse(mx, my)) {
            return true;
        }
        return super.mouseClicked(mx, my, button);
    }

    public boolean checkHSBMouse(double mx, double my) {
        this.prevMouseX = mx;
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        if (mx >= (double)(x + 10) && mx < (double)(x + 129)) {
            float value = MathHelper.func_76131_a((float)((float)((mx - ((double)x + 10.0)) / 118.0)), (float)0.0f, (float)1.0f);
            if (my >= (double)(y + 33) && my < (double)(y + 44)) {
                this.hsb[0] = value;
                this.convertHSBtoRGB(this.hsb, this.rgb);
                this.setColor(this.getRGB(this.rgb), true);
                return true;
            }
            if (my >= (double)(y + 47) && my < (double)(y + 58)) {
                this.hsb[1] = value;
                this.convertHSBtoRGB(this.hsb, this.rgb);
                this.setColor(this.getRGB(this.rgb), true);
                return true;
            }
            if (my >= (double)(y + 61) && my < (double)(y + 72)) {
                this.hsb[2] = value;
                this.convertHSBtoRGB(this.hsb, this.rgb);
                this.setColor(this.getRGB(this.rgb), true);
                return true;
            }
        }
        return false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        this.blit(x, y, 0, 0, this.xSize, this.ySize);
        if (this.prevMouseX != (double)mouseX && GLFW.glfwGetMouseButton((long)this.minecraft.field_195558_d.func_198092_i(), (int)0) == 1) {
            this.checkHSBMouse(mouseX, mouseY);
        }
        this.minecraft.func_110434_K().func_110577_a(HUE_TEXTURE);
        ColorSelectorScreen.innerBlit((int)(x + 10), (int)(x + 129), (int)(y + 33), (int)(y + 44), (int)0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.disableAlphaTest();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)(x + 10), (double)(y + 58), 0.0).func_181666_a(this.rgbMinS[0], this.rgbMinS[1], this.rgbMinS[2], 1.0f).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 129), (double)(y + 58), 0.0).func_181666_a(this.rgbMaxS[0], this.rgbMaxS[1], this.rgbMaxS[2], 1.0f).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 129), (double)(y + 47), 0.0).func_181666_a(this.rgbMaxS[0], this.rgbMaxS[1], this.rgbMaxS[2], 1.0f).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 10), (double)(y + 47), 0.0).func_181666_a(this.rgbMinS[0], this.rgbMinS[1], this.rgbMinS[2], 1.0f).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 10), (double)(y + 72), 0.0).func_181666_a(this.rgbMinB[0], this.rgbMinB[1], this.rgbMinB[2], 1.0f).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 129), (double)(y + 72), 0.0).func_181666_a(this.rgbMaxB[0], this.rgbMaxB[1], this.rgbMaxB[2], 1.0f).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 129), (double)(y + 61), 0.0).func_181666_a(this.rgbMaxB[0], this.rgbMaxB[1], this.rgbMaxB[2], 1.0f).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 10), (double)(y + 61), 0.0).func_181666_a(this.rgbMinB[0], this.rgbMinB[1], this.rgbMinB[2], 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableTexture();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        this.blit(x + 10 + (int)(119.0f * this.hsb[0]), y + 33, 0, 108, 1, 11);
        this.blit(x + 10 + (int)(119.0f * this.hsb[1]), y + 47, 0, 108, 1, 11);
        this.blit(x + 10 + (int)(119.0f * this.hsb[2]), y + 61, 0, 108, 1, 11);
        super.render(mouseX, mouseY, partialTicks);
        this.colorField.render(mouseX, mouseY, partialTicks);
        String t = this.title.func_150254_d();
        this.font.func_211126_b(t, (float)(x + 9), (float)(y + 7), 0x404040);
        RenderHelper.func_74520_c();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x + 149.0f), (float)((float)y + 23.0f), (float)16.0f);
        GlStateManager.scalef((float)4.0f, (float)4.0f, (float)1.0f);
        this.blitOffset = 200;
        this.itemRenderer.field_77023_b = 200.0f;
        FontRenderer f = this.preview.func_77973_b().getFontRenderer(this.preview);
        if (f == null) {
            f = this.font;
        }
        this.itemRenderer.func_180450_b(this.preview, 0, 0);
        this.itemRenderer.func_180453_a(f, this.preview, 0, 0, "");
        this.blitOffset = 0;
        this.itemRenderer.field_77023_b = 0.0f;
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableLighting();
        GlStateManager.enableDepthTest();
        RenderHelper.func_74519_b();
    }
}

