/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.quartzchests.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import dev.latvian.mods.quartzchests.block.QuartzChestsBlocks;
import dev.latvian.mods.quartzchests.block.entity.ColorType;
import dev.latvian.mods.quartzchests.gui.ColorSelectorScreen;
import dev.latvian.mods.quartzchests.gui.QuartzChestContainer;
import dev.latvian.mods.quartzchests.net.QuartzChestsNet;
import dev.latvian.mods.quartzchests.net.SetColorMessage;
import dev.latvian.mods.quartzchests.net.SetIconMessage;
import dev.latvian.mods.quartzchests.net.SetLabelMessage;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class QuartzChestScreen
extends ContainerScreen<QuartzChestContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("quartzchests", "textures/gui/chest.png");
    private TextFieldWidget labelField;
    private Button chestColorButton;
    private Button borderColorButton;
    private Button textColorButton;
    private Button iconButton;

    public QuartzChestScreen(QuartzChestContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 176;
        this.field_147000_g = 222;
    }

    protected void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        this.labelField = new TextFieldWidget(this.font, this.field_147003_i + 9, this.field_147009_r + 6, 69, 9, I18n.func_135052_a((String)"block.quartzchests.chest.label", (Object[])new Object[0]));
        this.labelField.func_146180_a(((QuartzChestContainer)this.field_147002_h).chest.label);
        this.labelField.func_146205_d(true);
        this.labelField.func_146193_g(-1);
        this.labelField.func_146204_h(-1);
        this.labelField.func_146185_a(false);
        this.labelField.func_146203_f(50);
        this.labelField.func_212954_a(this::setLabel);
        this.children.add(this.labelField);
        this.chestColorButton = this.addColorButton(ColorType.CHEST, this.field_147003_i + 118, this.field_147009_r + 4);
        this.borderColorButton = this.addColorButton(ColorType.BORDER, this.field_147003_i + 131, this.field_147009_r + 4);
        this.textColorButton = this.addColorButton(ColorType.TEXT, this.field_147003_i + 144, this.field_147009_r + 4);
        this.iconButton = this.addSmallButton(this.field_147003_i + 157, this.field_147009_r + 4, b -> {
            if (!this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_77973_b() != QuartzChestsBlocks.CHEST.func_199767_j()) {
                QuartzChestsNet.MAIN.sendToServer((Object)new SetIconMessage(((QuartzChestContainer)this.field_147002_h).chest.func_174877_v(), this.minecraft.field_71439_g.field_71071_by.func_70445_o()));
            } else if (QuartzChestScreen.hasShiftDown()) {
                QuartzChestsNet.MAIN.sendToServer((Object)new SetIconMessage(((QuartzChestContainer)this.field_147002_h).chest.func_174877_v(), ItemStack.field_190927_a));
            }
        });
    }

    public Button addSmallButton(int x, int y, Button.IPressable click) {
        return (Button)this.addButton((Widget)new Button(x, y, 12, 12, "", click){

            public void renderButton(int mouseX, int mouseY, float partialTicks) {
            }
        });
    }

    public Button addColorButton(ColorType type, int x, int y) {
        return this.addSmallButton(x, y, b -> {
            if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_77973_b() instanceof DyeItem) {
                QuartzChestsNet.MAIN.sendToServer((Object)new SetColorMessage(((QuartzChestContainer)this.field_147002_h).chest.func_174877_v(), type, ((DyeItem)this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_77973_b()).func_195962_g().getColorValue()));
            } else {
                this.minecraft.func_147108_a((Screen)new ColorSelectorScreen(this, type));
            }
        });
    }

    public void setLabel(String label) {
        QuartzChestsNet.MAIN.sendToServer((Object)new SetLabelMessage(((QuartzChestContainer)this.field_147002_h).chest.func_174877_v(), label));
    }

    public void resize(Minecraft mc, int w, int h) {
        String s = this.labelField.func_146179_b();
        this.init(mc, w, h);
        this.labelField.func_146180_a(s);
    }

    public void removed() {
        super.removed();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int other) {
        if (this.labelField.isFocused()) {
            if (keyCode == 257) {
                this.labelField.func_146195_b(false);
            } else if (keyCode != 256) {
                this.labelField.keyPressed(keyCode, scanCode, other);
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, other);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        GlStateManager.disableLighting();
        this.labelField.render(mouseX, mouseY, partialTicks);
        if (this.chestColorButton.isHovered()) {
            this.renderTooltip(Collections.singletonList(I18n.func_135052_a((String)"block.quartzchests.chest.chest_color", (Object[])new Object[0])), mouseX, mouseY);
        }
        if (this.borderColorButton.isHovered()) {
            this.renderTooltip(Collections.singletonList(I18n.func_135052_a((String)"block.quartzchests.chest.border_color", (Object[])new Object[0])), mouseX, mouseY);
        }
        if (this.textColorButton.isHovered()) {
            this.renderTooltip(Collections.singletonList(I18n.func_135052_a((String)"block.quartzchests.chest.text_color", (Object[])new Object[0])), mouseX, mouseY);
        }
        if (this.iconButton.isHovered()) {
            this.renderTooltip(Collections.singletonList(I18n.func_135052_a((String)"block.quartzchests.chest.icon", (Object[])new Object[0])), mouseX, mouseY);
        }
        if (!((QuartzChestContainer)this.field_147002_h).chest.icon.func_190926_b()) {
            RenderHelper.func_74520_c();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)((float)this.field_147003_i + 159.0f), (float)((float)this.field_147009_r + 6.0f), (float)16.0f);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
            this.blitOffset = 200;
            this.itemRenderer.field_77023_b = 200.0f;
            FontRenderer f = ((QuartzChestContainer)this.field_147002_h).chest.icon.func_77973_b().getFontRenderer(((QuartzChestContainer)this.field_147002_h).chest.icon);
            if (f == null) {
                f = this.font;
            }
            this.itemRenderer.func_180450_b(((QuartzChestContainer)this.field_147002_h).chest.icon, 0, 0);
            this.itemRenderer.func_180453_a(f, ((QuartzChestContainer)this.field_147002_h).chest.icon, 0, 0, "");
            this.blitOffset = 0;
            this.itemRenderer.field_77023_b = 0.0f;
            GlStateManager.popMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableLighting();
            GlStateManager.enableDepthTest();
            RenderHelper.func_74519_b();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int i = 0; i < ColorType.VALUES.length; ++i) {
            int c = ((QuartzChestContainer)this.field_147002_h).chest.colors[i];
            GlStateManager.color4f((float)((float)(c >> 16 & 0xFF) / 255.0f), (float)((float)(c >> 8 & 0xFF) / 255.0f), (float)((float)(c & 0xFF) / 255.0f), (float)1.0f);
            this.blit(this.field_147003_i + 118 + i * 13, this.field_147009_r + 4, 177, 0, 12, 12);
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

