/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.quartzchests.block;

import dev.latvian.mods.quartzchests.block.entity.ColorType;
import dev.latvian.mods.quartzchests.block.entity.QuartzChestEntity;
import dev.latvian.mods.quartzchests.gui.QuartzChestContainer;
import dev.latvian.mods.quartzchests.item.QuartzChestsItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.NameTagItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class QuartzChestBlock
extends HorizontalBlock {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    private QuartzChestEntity dummy;

    public QuartzChestBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new QuartzChestEntity();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    @Deprecated
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, BlockStateProperties.field_208198_y});
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool == ToolType.PICKAXE || tool == ToolType.AXE;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (world.field_72995_K || player.func_175149_v()) {
            return ActionResultType.SUCCESS;
        }
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof QuartzChestEntity) {
            final QuartzChestEntity chest = (QuartzChestEntity)entity;
            ItemStack stack = player.func_184586_b(hand);
            Item item = stack.func_77973_b();
            if (item instanceof NameTagItem && stack.func_82837_s()) {
                chest.label = stack.func_200301_q().getString();
                chest.func_70296_d();
                world.markAndNotifyBlock(pos, null, state, state, 11);
                return ActionResultType.SUCCESS;
            }
            if (item instanceof DyeItem) {
                if (!chest.label.isEmpty() && rayTraceResult.func_216354_b() == state.func_177229_b((IProperty)field_185512_D) && rayTraceResult.func_216347_e().field_72448_b - (double)pos.func_177956_o() > 0.6) {
                    chest.colors[ColorType.TEXT.index] = 0xFF000000 | ((DyeItem)item).func_195962_g().getColorValue();
                } else {
                    chest.colors[ColorType.CHEST.index] = 0xFF000000 | ((DyeItem)item).func_195962_g().getColorValue();
                }
                chest.func_70296_d();
                world.markAndNotifyBlock(pos, null, state, state, 11);
                return ActionResultType.SUCCESS;
            }
            if (item == QuartzChestsItems.KEEP_INVENTORY_UPGRADE) {
                if (!chest.keepInventory) {
                    chest.keepInventory = true;
                    chest.func_70296_d();
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            if (item == QuartzChestsItems.GLOWING_TEXT_UPGRADE) {
                if (!chest.textGlow) {
                    chest.textGlow = true;
                    chest.func_70296_d();
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            if (item == QuartzChestsItems.BOLD_TEXT_UPGRADE) {
                if (!chest.textBold) {
                    chest.textBold = true;
                    chest.func_70296_d();
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            if (item == QuartzChestsItems.ITALIC_TEXT_UPGRADE) {
                if (!chest.textItalic) {
                    chest.textItalic = true;
                    chest.func_70296_d();
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return chest.func_145748_c_();
                }

                public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                    return new QuartzChestContainer(id, playerInventory, chest);
                }
            }, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof QuartzChestEntity) {
            QuartzChestEntity chest = (QuartzChestEntity)entity;
            if (!world.field_72995_K && player.func_184812_l_()) {
                CompoundNBT data = new CompoundNBT();
                chest.writeData(data);
                if (!data.isEmpty()) {
                    ItemStack stack = new ItemStack((IItemProvider)this);
                    stack.func_77983_a("BlockEntityTag", (INBT)data);
                    ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                    itemEntity.func_174869_p();
                    world.func_217376_c((Entity)itemEntity);
                }
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    @Deprecated
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof QuartzChestEntity) {
                QuartzChestEntity chest = (QuartzChestEntity)entity;
                if (!chest.keepInventory) {
                    for (int i = 0; i < chest.inventory.getSlots(); ++i) {
                        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)chest.inventory.getStackInSlot(i));
                        chest.inventory.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                }
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity entity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (entity instanceof QuartzChestEntity) {
            QuartzChestEntity chest = (QuartzChestEntity)entity;
            if (chest.keepInventory) {
                builder = builder.func_216017_a(CONTENTS, (context, callback) -> {
                    for (int i = 0; i < chest.inventory.getSlots(); ++i) {
                        callback.accept(chest.inventory.getStackInSlot(i));
                    }
                });
            }
        }
        return super.func_220076_a(state, builder);
    }

    @Deprecated
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        CompoundNBT data;
        super.func_190948_a(stack, world, tooltip, flag);
        if (this.dummy == null) {
            this.dummy = new QuartzChestEntity();
        }
        this.dummy.readData((data = stack.func_179543_a("BlockEntityTag")) == null ? new CompoundNBT() : data);
        tooltip.add(new StringTextComponent("").func_150257_a(new TranslationTextComponent("block.quartzchests.chest.label", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150258_a(": ")).func_150257_a(this.dummy.func_145748_c_().func_211708_a(TextFormatting.YELLOW)));
        for (ColorType type : ColorType.VALUES) {
            tooltip.add(new StringTextComponent("").func_150257_a(new TranslationTextComponent(type.translationKey, new Object[0]).func_211708_a(TextFormatting.GRAY).func_150258_a(": ")).func_150257_a(new StringTextComponent(String.format("#%06X", this.dummy.colors[type.index])).func_211708_a(TextFormatting.YELLOW)));
        }
        tooltip.add(new StringTextComponent("").func_150257_a(new TranslationTextComponent("block.quartzchests.chest.icon", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150258_a(": ")).func_150257_a(this.dummy.icon.func_200301_q().func_212638_h().func_211708_a(TextFormatting.YELLOW)));
        if (this.dummy.keepInventory && data != null) {
            tooltip.add(new StringTextComponent("").func_150257_a(new TranslationTextComponent("block.quartzchests.chest.slots_used", new Object[]{data.func_150295_c("items", 10).size(), 54}).func_211708_a(TextFormatting.DARK_GRAY)));
        }
        if (this.dummy.keepInventory || this.dummy.textGlow || this.dummy.textBold || this.dummy.textItalic) {
            tooltip.add(new TranslationTextComponent("block.quartzchests.chest.upgrades", new Object[0]).func_211708_a(TextFormatting.AQUA));
            if (this.dummy.keepInventory) {
                tooltip.add(new StringTextComponent("+ ").func_211708_a(TextFormatting.GREEN).func_150257_a((ITextComponent)new TranslationTextComponent("item.quartzchests.keep_inventory_upgrade", new Object[0])));
            }
            if (this.dummy.textGlow) {
                tooltip.add(new StringTextComponent("+ ").func_211708_a(TextFormatting.GREEN).func_150257_a((ITextComponent)new TranslationTextComponent("item.quartzchests.glowing_text_upgrade", new Object[0])));
            }
            if (this.dummy.textBold) {
                tooltip.add(new StringTextComponent("+ ").func_211708_a(TextFormatting.GREEN).func_150257_a((ITextComponent)new TranslationTextComponent("item.quartzchests.bold_text_upgrade", new Object[0])));
            }
            if (this.dummy.textItalic) {
                tooltip.add(new StringTextComponent("+ ").func_211708_a(TextFormatting.GREEN).func_150257_a((ITextComponent)new TranslationTextComponent("item.quartzchests.italic_text_upgrade", new Object[0])));
            }
        }
    }
}

