/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.block.RediscoveredBlocks;
import com.legacy.rediscovered.client.RediscoveredClientEvents;
import com.legacy.rediscovered.client.RediscoveredEntityRendering;
import com.legacy.rediscovered.entity.RediscoveredEntityTypes;
import com.legacy.rediscovered.event.RediscoveredEvents;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="rediscovered")
public class RediscoveredMod {
    public static final String NAME = "Rediscovered Mod";
    public static final String MODID = "rediscovered";

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }

    public static String find(String key) {
        return new String("rediscovered:" + key);
    }

    public RediscoveredMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, RediscoveredConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RediscoveredConfig.SERVER_SPEC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonInit);
    }

    private void commonInit(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (!biome.getRegistryName().func_110624_b().equalsIgnoreCase("minecraft") || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.VOID)) continue;
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, RediscoveredBlocks.ruby_ore.func_176223_P(), 4), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(2, 0, 0, 32)));
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                biome.func_76747_a(EntityClassification.WATER_CREATURE).add(new Biome.SpawnListEntry(RediscoveredEntityTypes.FISH, 10, 3, 6));
            }
            if (!RediscoveredConfig.undeadHorsesAgressive || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) continue;
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(RediscoveredEntityTypes.VANILLA_SPAWNER, 1, 1, 2));
        }
        MinecraftForge.EVENT_BUS.register((Object)new RediscoveredEvents());
    }

    public void clientInit(FMLClientSetupEvent event) {
        RediscoveredEntityRendering.init();
        MinecraftForge.EVENT_BUS.register((Object)new RediscoveredClientEvents());
    }
}

