/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.render.model.FishModel;
import com.legacy.rediscovered.entity.FishEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FishRenderer
extends MobRenderer<FishEntity, FishModel<FishEntity>> {
    private static final ResourceLocation FISH_LOCATION = RediscoveredMod.locate("textures/entity/fish.png");

    public FishRenderer(EntityRendererManager p_i48864_1_) {
        super(p_i48864_1_, new FishModel(), 0.3f);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(FishEntity entity) {
        return FISH_LOCATION;
    }

    protected void applyRotations(FishEntity entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_77043_a((LivingEntity)entityLiving, ageInTicks, rotationYaw, partialTicks);
        GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translatef((float)0.1f, (float)-1.2f, (float)-0.3f);
        float f = 4.3f * MathHelper.func_76126_a((float)(0.6f * ageInTicks));
        GlStateManager.rotatef((float)f, (float)0.0f, (float)0.0f, (float)0.0f);
        if (!entityLiving.func_70090_H()) {
            GlStateManager.translatef((float)1.3f, (float)1.4f, (float)0.0f);
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.translatef((float)-0.05f, (float)-0.05f, (float)0.0f);
        }
    }
}

