/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.RediscoveredRegistry;
import com.legacy.rediscovered.entity.BeastBoyEntity;
import com.legacy.rediscovered.entity.BlackSteveEntity;
import com.legacy.rediscovered.entity.FishEntity;
import com.legacy.rediscovered.entity.PurpleArrowEntity;
import com.legacy.rediscovered.entity.RanaEntity;
import com.legacy.rediscovered.entity.RedDragonEntity;
import com.legacy.rediscovered.entity.ScarecrowEntity;
import com.legacy.rediscovered.entity.SteveEntity;
import com.legacy.rediscovered.entity.pigman.MeleePigmanEntity;
import com.legacy.rediscovered.entity.pigman.PigmanEntity;
import com.legacy.rediscovered.entity.pigman.RangedPigmanEntity;
import com.legacy.rediscovered.entity.util.MountableBlockEntity;
import com.legacy.rediscovered.entity.util.SpawnerEntity;
import com.legacy.rediscovered.world.dimension.RediscoveredDimensions;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="rediscovered")
public class RediscoveredEntityTypes {
    public static final EntityType<FishEntity> FISH = RediscoveredEntityTypes.buildEntity("fish", EntityType.Builder.func_220322_a(FishEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(0.5f, 0.3f));
    public static final EntityType<PigmanEntity> PIGMAN = RediscoveredEntityTypes.buildEntity("pigman", EntityType.Builder.func_220322_a(PigmanEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.9f));
    public static final EntityType<MeleePigmanEntity> MELEE_PIGMAN = RediscoveredEntityTypes.buildEntity("melee_pigman", EntityType.Builder.func_220322_a(MeleePigmanEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.9f));
    public static final EntityType<RangedPigmanEntity> RANGED_PIGMAN = RediscoveredEntityTypes.buildEntity("ranged_pigman", EntityType.Builder.func_220322_a(RangedPigmanEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.9f));
    public static final EntityType<SteveEntity> STEVE = RediscoveredEntityTypes.buildEntity("steve", EntityType.Builder.func_220322_a(SteveEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.9f));
    public static final EntityType<RanaEntity> RANA = RediscoveredEntityTypes.buildEntity("rana", EntityType.Builder.func_220322_a(RanaEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.9f));
    public static final EntityType<BlackSteveEntity> BLACK_STEVE = RediscoveredEntityTypes.buildEntity("black_steve", EntityType.Builder.func_220322_a(BlackSteveEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.9f));
    public static final EntityType<BeastBoyEntity> BEAST_BOY = RediscoveredEntityTypes.buildEntity("beast_boy", EntityType.Builder.func_220322_a(BeastBoyEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.9f));
    public static final EntityType<RedDragonEntity> RED_DRAGON = RediscoveredEntityTypes.buildEntity("red_dragon", EntityType.Builder.func_220322_a(RedDragonEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(8.0f, 4.5f));
    public static final EntityType<ScarecrowEntity> SCARECROW = RediscoveredEntityTypes.buildEntity("scarecrow", EntityType.Builder.func_220322_a(ScarecrowEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.3f, 1.975f));
    public static final EntityType<SpawnerEntity> VANILLA_SPAWNER = RediscoveredEntityTypes.buildEntity("spawner", EntityType.Builder.func_220322_a(SpawnerEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.0f, 2.0f));
    public static final EntityType<PurpleArrowEntity> PURPLE_ARROW = RediscoveredEntityTypes.buildEntity("purple_arrow", EntityType.Builder.func_220322_a(PurpleArrowEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(PurpleArrowEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.5f, 0.5f));
    public static final EntityType<MountableBlockEntity> MOUNTABLE_BLOCK = RediscoveredEntityTypes.buildEntity("mountable_block", EntityType.Builder.func_220322_a(MountableBlockEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(MountableBlockEntity::new).func_220321_a(1.0f, 1.0f));

    public static void init(RegistryEvent.Register<EntityType<?>> event) {
        RediscoveredRegistry.register(event.getRegistry(), "fish", FISH);
        RediscoveredRegistry.register(event.getRegistry(), "pigman", PIGMAN);
        RediscoveredRegistry.register(event.getRegistry(), "melee_pigman", MELEE_PIGMAN);
        RediscoveredRegistry.register(event.getRegistry(), "ranged_pigman", RANGED_PIGMAN);
        RediscoveredRegistry.register(event.getRegistry(), "steve", STEVE);
        RediscoveredRegistry.register(event.getRegistry(), "rana", RANA);
        RediscoveredRegistry.register(event.getRegistry(), "black_steve", BLACK_STEVE);
        RediscoveredRegistry.register(event.getRegistry(), "beast_boy", BEAST_BOY);
        RediscoveredRegistry.register(event.getRegistry(), "red_dragon", RED_DRAGON);
        RediscoveredRegistry.register(event.getRegistry(), "scarecrow", SCARECROW);
        RediscoveredRegistry.register(event.getRegistry(), "spawner", VANILLA_SPAWNER);
        RediscoveredRegistry.register(event.getRegistry(), "purple_arrow", PURPLE_ARROW);
        RediscoveredRegistry.register(event.getRegistry(), "mountable_block", MOUNTABLE_BLOCK);
        RediscoveredEntityTypes.registerSpawnConditions();
    }

    private static <T extends Entity> EntityType<T> buildEntity(String key, EntityType.Builder<T> builder) {
        return builder.func_206830_a(RediscoveredMod.find(key));
    }

    public static boolean monsterSpawnConditions(EntityType<? extends MobEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && !worldIn.func_201672_e().func_72935_r() && worldIn.func_201675_m().func_186058_p() != RediscoveredDimensions.skylandsType() || worldIn.func_175659_aa() != Difficulty.PEACEFUL && worldIn.func_201675_m().func_186058_p() == RediscoveredDimensions.skylandsType() && pos.func_177956_o() < 100 && randomIn.nextInt(350) == 0;
    }

    public static boolean mobSpawnConditions(EntityType<? extends MobEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return MobEntity.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    private static void registerSpawnConditions() {
        EntitySpawnPlacementRegistry.func_209343_a(PIGMAN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, RediscoveredEntityTypes::mobSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(STEVE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, RediscoveredEntityTypes::mobSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(RANA, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, RediscoveredEntityTypes::mobSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(BLACK_STEVE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, RediscoveredEntityTypes::monsterSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(BEAST_BOY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, RediscoveredEntityTypes::monsterSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(MELEE_PIGMAN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, RediscoveredEntityTypes::monsterSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(RANGED_PIGMAN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, RediscoveredEntityTypes::monsterSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(RED_DRAGON, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, RediscoveredEntityTypes::monsterSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(FISH, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AbstractFishEntity::func_223363_b);
        EntitySpawnPlacementRegistry.func_209343_a(VANILLA_SPAWNER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, RediscoveredEntityTypes::monsterSpawnConditions);
    }
}

