/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity;

import com.legacy.rediscovered.entity.RediscoveredEntityTypes;
import com.legacy.rediscovered.item.RediscoveredItems;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ScarecrowEntity
extends LivingEntity {
    public static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(ScarecrowEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final Predicate<Entity> IS_RIDEABLE_MINECART = p_200617_0_ -> p_200617_0_ instanceof AbstractMinecartEntity && ((AbstractMinecartEntity)p_200617_0_).canBeRidden();
    private boolean canInteract;
    public long punchCooldown;

    public ScarecrowEntity(EntityType<? extends ScarecrowEntity> p_i50225_1_, World p_i50225_2_) {
        super(p_i50225_1_, p_i50225_2_);
        this.field_70138_W = 0.0f;
    }

    public ScarecrowEntity(World worldIn, double posX, double posY, double posZ) {
        this(RediscoveredEntityTypes.SCARECROW, worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    public void func_213323_x_() {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    private boolean func_213814_A() {
        return !this.hasMarker() && !this.func_189652_ae();
    }

    public boolean func_70613_aW() {
        return super.func_70613_aW() && this.func_213814_A();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Invisible", this.func_82150_aj());
        compound.func_74757_a("Small", this.isSmall());
        if (this.hasMarker()) {
            compound.func_74757_a("Marker", this.hasMarker());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_82142_c(compound.func_74767_n("Invisible"));
        this.setSmall(compound.func_74767_n("Small"));
        this.setMarker(compound.func_74767_n("Marker"));
        this.field_70145_X = !this.func_213814_A();
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), IS_RIDEABLE_MINECART);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(this.func_70068_e(entity) <= 0.2)) continue;
            entity.func_70108_f((Entity)this);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (DamageSource.field_76380_i.equals(source)) {
                this.func_70106_y();
                return false;
            }
            if (!(this.func_180431_b(source) || this.canInteract || this.hasMarker())) {
                if (source.func_94541_c()) {
                    this.func_213816_g(source);
                    this.func_70106_y();
                    return false;
                }
                if (DamageSource.field_76372_a.equals(source)) {
                    if (this.func_70027_ad()) {
                        this.func_213817_e(source, 0.15f);
                    } else {
                        this.func_70015_d(5);
                    }
                    return false;
                }
                if (DamageSource.field_76370_b.equals(source) && this.func_110143_aJ() > 0.5f) {
                    this.func_213817_e(source, 4.0f);
                    return false;
                }
                boolean flag = source.func_76364_f() instanceof AbstractArrowEntity;
                boolean flag1 = flag && ((AbstractArrowEntity)source.func_76364_f()).func_213874_s() > 0;
                boolean flag2 = "player".equals(source.func_76355_l());
                if (!flag2 && !flag) {
                    return false;
                }
                if (source.func_76346_g() instanceof PlayerEntity && !((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75099_e) {
                    return false;
                }
                if (source.func_180136_u()) {
                    this.playBrokenSound();
                    this.playParticles();
                    this.func_70106_y();
                    return flag1;
                }
                long i = this.field_70170_p.func_82737_E();
                if (i - this.punchCooldown > 5L && !flag) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)32);
                    this.punchCooldown = i;
                } else {
                    this.func_213815_f(source);
                    this.playParticles();
                    this.func_70106_y();
                }
                return true;
            }
            if (source.func_76364_f() instanceof CreatureEntity) {
                this.func_213815_f(source);
                this.playParticles();
                this.func_70106_y();
                return false;
            }
            return false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 32) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187707_l, this.func_184176_by(), 0.3f, 1.0f, false);
                this.punchCooldown = this.field_70170_p.func_82737_E();
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void playParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196662_n.func_176223_P()), this.field_70165_t, this.field_70163_u + (double)this.func_213302_cg() / 1.5, this.field_70161_v, 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    private void func_213817_e(DamageSource p_213817_1_, float p_213817_2_) {
        float f = this.func_110143_aJ();
        if ((f -= p_213817_2_) <= 0.5f) {
            this.func_213816_g(p_213817_1_);
            this.func_70106_y();
        } else {
            this.func_70606_j(f);
        }
    }

    private void func_213815_f(DamageSource p_213815_1_) {
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)new BlockPos((Entity)this), (ItemStack)new ItemStack((IItemProvider)RediscoveredItems.scarecrow));
        this.func_213816_g(p_213815_1_);
    }

    private void func_213816_g(DamageSource p_213816_1_) {
        this.playBrokenSound();
        this.func_213345_d(p_213816_1_);
    }

    private void playBrokenSound() {
        this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187701_j, this.func_184176_by(), 1.0f, 1.0f);
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.field_70760_ar = this.field_70126_B;
        this.field_70761_aq = this.field_70177_z;
        return 0.0f;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * (this.func_70631_g_() ? 0.5f : 0.9f);
    }

    public double func_70033_W() {
        return this.hasMarker() ? 0.0 : (double)0.1f;
    }

    public void func_213352_e(Vec3d p_213352_1_) {
        if (this.func_213814_A()) {
            super.func_213352_e(p_213352_1_);
        }
    }

    public void func_181013_g(float offset) {
        this.field_70760_ar = this.field_70126_B = offset;
        this.field_70758_at = this.field_70759_as = offset;
    }

    public void func_70034_d(float rotation) {
        this.field_70760_ar = this.field_70126_B = rotation;
        this.field_70758_at = this.field_70759_as = rotation;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected void func_175135_B() {
        this.func_82142_c(this.canInteract);
    }

    public void func_82142_c(boolean invisible) {
        this.canInteract = invisible;
        super.func_82142_c(invisible);
    }

    public boolean func_70631_g_() {
        return this.isSmall();
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public boolean func_180427_aV() {
        return this.func_82150_aj();
    }

    public PushReaction func_184192_z() {
        return this.hasMarker() ? PushReaction.IGNORE : super.func_184192_z();
    }

    private void setSmall(boolean small) {
        this.field_70180_af.func_187227_b(STATUS, (Object)this.setBit((Byte)this.field_70180_af.func_187225_a(STATUS), 1, small));
    }

    public boolean isSmall() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 1) != 0;
    }

    private void setMarker(boolean marker) {
        this.field_70180_af.func_187227_b(STATUS, (Object)this.setBit((Byte)this.field_70180_af.func_187225_a(STATUS), 16, marker));
    }

    public boolean hasMarker() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 0x10) != 0;
    }

    private byte setBit(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public boolean func_70067_L() {
        return super.func_70067_L() && !this.hasMarker();
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return SoundEvents.field_187704_k;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187707_l;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187701_j;
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
    }

    public boolean func_184603_cC() {
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (STATUS.equals(key)) {
            this.func_213323_x_();
            this.field_70156_m = !this.hasMarker();
        }
        super.func_184206_a(key);
    }

    public boolean func_190631_cK() {
        return false;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        float f = this.hasMarker() ? 0.0f : (this.func_70631_g_() ? 0.5f : 1.0f);
        return this.func_200600_R().func_220334_j().func_220313_a(f);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return null;
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }
}

