/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.pigman;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.legacy.rediscovered.entity.RediscoveredEntityTypes;
import com.legacy.rediscovered.entity.pigman.MeleePigmanEntity;
import com.legacy.rediscovered.entity.pigman.PigmanTrades;
import com.legacy.rediscovered.entity.pigman.RangedPigmanEntity;
import com.legacy.rediscovered.entity.pigman.tasks.PigmanTasks;
import com.legacy.rediscovered.item.RediscoveredItems;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.LongSerializable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PigmanEntity
extends AbstractVillagerEntity {
    public static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(PigmanEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int xp;
    private int timeUntilReset;
    private boolean customer;
    private BlockPos homePos;
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleType.field_220945_f, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220948_i, (Object)MemoryModuleType.field_220949_j, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleType.field_220952_m, (Object)MemoryModuleType.field_220953_n, (Object)MemoryModuleType.field_220954_o, (Object)MemoryModuleType.field_220955_p, (Object[])new MemoryModuleType[]{MemoryModuleType.field_225462_q, MemoryModuleType.field_220956_q, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220959_t, MemoryModuleType.field_220962_w, MemoryModuleType.field_223021_x, MemoryModuleType.field_223543_y});
    private static final ImmutableList<SensorType<? extends Sensor<? super PigmanEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)SensorType.field_220999_c, (Object)SensorType.field_221000_d, (Object)SensorType.field_221001_e, (Object)SensorType.field_221002_f, (Object)SensorType.field_221003_g);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<PigmanEntity, PointOfInterestType>> VALID_POI = ImmutableMap.of((Object)MemoryModuleType.field_220941_b, (entity, type) -> type == PointOfInterestType.field_221069_q, (Object)MemoryModuleType.field_220943_d, (entity, type) -> type == PointOfInterestType.field_221070_r);

    public PigmanEntity(EntityType<? extends PigmanEntity> type, World world) {
        super(type, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        ((GroundPathNavigator)this.func_70661_as()).func_212239_d(true);
        this.field_213378_br = this.func_213364_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)new CompoundNBT()));
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (this.field_70170_p instanceof ServerWorld) {
            this.resetBrain((ServerWorld)this.field_70170_p);
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.85f : 1.8f;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LEVEL, (Object)1);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Xp", this.xp);
        compound.func_74768_a("Level", this.getLevel());
        if (this.homePos != null) {
            compound.func_218657_a("HomePosition", (INBT)NBTUtil.func_186859_a((BlockPos)this.homePos));
        }
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setLevel(compound.func_74762_e("Level"));
        if (compound.func_150297_b("Offers", 10)) {
            this.field_213724_bz = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        if (compound.func_150297_b("Xp", 3)) {
            this.xp = compound.func_74762_e("Xp");
        }
        if (compound.func_74764_b("HomePosition")) {
            this.homePos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("HomePosition"));
        }
        this.resetBrain((ServerWorld)this.field_70170_p);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("brain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (!this.func_213716_dX() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.customer) {
                    this.populateBuyingList();
                    this.customer = false;
                }
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    protected SoundEvent func_184639_G() {
        return this.func_70608_bn() ? null : SoundEvents.field_187697_dL;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187703_dN;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    public SoundEvent func_213714_ea() {
        this.func_184185_a(SoundEvents.field_187697_dL, this.func_70599_aP(), 1.3f);
        return null;
    }

    protected SoundEvent func_213721_r(boolean positive) {
        if (positive) {
            this.func_184185_a(SoundEvents.field_187697_dL, this.func_70599_aP(), 1.3f);
        } else {
            this.func_184185_a(SoundEvents.field_187697_dL, this.func_70599_aP(), 0.7f);
        }
        return null;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    public PigmanEntity createChild(AgeableEntity ageable) {
        return (PigmanEntity)RediscoveredEntityTypes.PIGMAN.func_200721_a(this.field_70170_p);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemstack.func_111282_a(player, (LivingEntity)this, hand);
            return true;
        }
        if (itemstack.func_77973_b() != RediscoveredItems.pigman_spawn_egg && this.func_70089_S() && !this.func_70608_bn() && !this.func_70631_g_()) {
            if (hand == Hand.MAIN_HAND) {
                player.func_195066_a(Stats.field_188074_H);
            }
            if (this.func_213706_dY().isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), this.getLevel());
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private void populateBuyingList() {
        this.setLevel(this.getLevel() + 1);
        this.func_213712_ef();
    }

    protected void func_213713_b(MerchantOffer offer) {
        int i = 3 + this.field_70146_Z.nextInt(4);
        this.xp += offer.func_222210_n();
        if (this.func_213741_eu()) {
            this.timeUntilReset = 40;
            this.customer = true;
            i += 5;
        }
        if (offer.func_222221_q()) {
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] avillagertrades$itrade = (VillagerTrades.ITrade[])PigmanTrades.pigmanTrades.get(this.getLevel());
        if (avillagertrades$itrade != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, avillagertrades$itrade, 2);
        }
    }

    private boolean func_213741_eu() {
        int i = this.getLevel();
        return VillagerData.func_221128_d((int)i) && this.xp >= VillagerData.func_221127_c((int)i);
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)level);
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(LEVEL);
    }

    public int func_213708_dV() {
        return this.xp;
    }

    public void setXp(int amount) {
        this.xp = amount;
    }

    public void setHomePos(@Nullable BlockPos pos) {
        this.homePos = pos;
    }

    @Nullable
    public BlockPos getHomePos() {
        return this.homePos;
    }

    public void func_70645_a(DamageSource cause) {
        this.removeModule((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220941_b);
        this.removeModule((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220943_d);
        super.func_70645_a(cause);
    }

    public void removeModule(MemoryModuleType<GlobalPos> p_213742_1_) {
        if (this.field_70170_p instanceof ServerWorld) {
            MinecraftServer minecraftserver = ((ServerWorld)this.field_70170_p).func_73046_m();
            this.field_213378_br.func_218207_c(p_213742_1_).ifPresent(p_213752_3_ -> {
                ServerWorld serverworld = minecraftserver.func_71218_a(p_213752_3_.func_218177_a());
                PointOfInterestManager pointofinterestmanager = serverworld.func_217443_B();
                Optional optional = pointofinterestmanager.func_219148_c(p_213752_3_.func_218180_b());
                BiPredicate<PigmanEntity, PointOfInterestType> bipredicate = VALID_POI.get(p_213742_1_);
                if (optional.isPresent() && bipredicate.test(this, (PointOfInterestType)optional.get())) {
                    pointofinterestmanager.func_219142_b(p_213752_3_.func_218180_b());
                    DebugPacketSender.func_218801_c((ServerWorld)serverworld, (BlockPos)p_213752_3_.func_218180_b());
                }
            });
        }
    }

    public float getPosDistance(double x, double y, double z) {
        float f = (float)(this.field_70165_t - x);
        float f1 = (float)(this.field_70163_u - y);
        float f2 = (float)(this.field_70161_v - z);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn instanceof RangedPigmanEntity || entityIn instanceof MeleePigmanEntity || entityIn instanceof PigmanEntity) {
            return true;
        }
        return this.func_184194_a(entityIn.func_96124_cp());
    }

    public boolean canBreed() {
        return this.func_70874_b() == 0;
    }

    public Brain<PigmanEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        Brain brain = new Brain(MEMORY_TYPES, SENSOR_TYPES, dynamicIn);
        this.initBrain((Brain<PigmanEntity>)brain);
        return brain;
    }

    public void resetBrain(ServerWorld p_213770_1_) {
        Brain<PigmanEntity> brain = this.func_213375_cj();
        brain.func_218227_b(p_213770_1_, (LivingEntity)this);
        this.field_213378_br = brain.func_218185_f();
        this.initBrain(this.func_213375_cj());
    }

    private void initBrain(Brain<PigmanEntity> villagerBrain) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        if (this.func_70631_g_()) {
            villagerBrain.func_218203_a(Schedule.field_221385_c);
            villagerBrain.func_218208_a(Activity.field_221368_d, PigmanTasks.play(f));
        } else {
            villagerBrain.func_218203_a(Schedule.field_221386_d);
        }
        villagerBrain.func_218208_a(Activity.field_221365_a, PigmanTasks.core(f));
        villagerBrain.func_218208_a(Activity.field_221369_e, PigmanTasks.rest(f));
        villagerBrain.func_218208_a(Activity.field_221366_b, PigmanTasks.idle(f));
        villagerBrain.func_218208_a(Activity.field_221371_g, PigmanTasks.panic(f));
        villagerBrain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        villagerBrain.func_218200_b(Activity.field_221366_b);
        villagerBrain.func_218202_a(Activity.field_221366_b);
        villagerBrain.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    public void func_213342_e(BlockPos pos) {
        super.func_213342_e(pos);
        this.field_213378_br.func_218205_a(MemoryModuleType.field_223543_y, (Object)LongSerializable.func_223463_a((long)this.field_70170_p.func_82737_E()));
    }
}

