/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.event;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.block.RediscoveredBlocks;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.RedDragonEntity;
import com.legacy.rediscovered.entity.ScarecrowEntity;
import com.legacy.rediscovered.item.RediscoveredItems;
import com.legacy.rediscovered.world.dimension.RediscoveredDimensions;
import java.util.Random;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.GiantEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RediscoveredEvents {
    Random gen = new Random();
    protected static Random itemRand = new Random();

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        PlayerEntity player = event.getPlayer();
        PlayerInventory inv = player.field_71071_by;
        ItemStack itemStack = inv.func_70301_a(inv.field_70461_c);
        World world = event.getEntityLiving().field_70170_p;
        if (!(RediscoveredConfig.disableBedTeleportation || player.field_71093_bK != DimensionType.field_223227_a_ || world.func_72935_r() || itemRand.nextInt(100) > 12 || itemStack != null && itemStack.func_77973_b() == RediscoveredItems.dream_pillow || !(player instanceof ServerPlayerEntity))) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            DimensionType transferDimension = player.field_71093_bK == RediscoveredDimensions.skylandsType() ? DimensionType.field_223227_a_ : RediscoveredDimensions.skylandsType();
            serverPlayer.func_200619_a(player.func_184102_h().func_71218_a(transferDimension), 2.5, 80.0, 2.5, serverPlayer.field_70177_z, serverPlayer.field_70125_A);
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof ServerPlayerEntity && event.getEntityLiving().field_71093_bK == RediscoveredDimensions.skylandsType() && event.getSource() == DamageSource.field_76380_i) {
            ServerWorld world = (ServerWorld)event.getEntityLiving().field_70170_p;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)event.getEntityLiving();
            if (serverPlayer.field_70163_u <= 10.0) {
                event.setCanceled(true);
                IChunk chunk = serverPlayer.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_217349_x(serverPlayer.func_180425_c());
                int transferY = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, serverPlayer.func_180425_c().func_177958_n(), serverPlayer.func_180425_c().func_177952_p()) + 1;
                Vec3d teleportationPos = new Vec3d((double)serverPlayer.func_180425_c().func_177958_n() + 0.5, (double)transferY, (double)serverPlayer.func_180425_c().func_177952_p() + 0.5);
                serverPlayer.func_200619_a(serverPlayer.func_184102_h().func_71218_a(DimensionType.field_223227_a_), teleportationPos.func_82615_a(), teleportationPos.func_82617_b(), teleportationPos.func_82616_c(), serverPlayer.field_70177_z, serverPlayer.field_70125_A);
                BlockPos coordinates = serverPlayer.getBedLocation(DimensionType.field_223227_a_);
                if (coordinates != null) {
                    coordinates = RediscoveredEvents.verifyRespawnCoordinates((World)serverPlayer.func_184102_h().func_71218_a(DimensionType.field_223227_a_), coordinates, true, serverPlayer);
                }
                if (coordinates == null) {
                    coordinates = world.func_175694_M();
                    serverPlayer.func_70634_a((double)coordinates.func_177958_n() + 0.5, (double)coordinates.func_177956_o() + 3.0, (double)coordinates.func_177952_p() + 0.5);
                    serverPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("message.missingbed", new Object[0]), true);
                } else if (coordinates != null) {
                    serverPlayer.func_70634_a((double)coordinates.func_177958_n() + 0.5, (double)coordinates.func_177956_o() + 3.0, (double)coordinates.func_177952_p() + 0.5);
                }
                serverPlayer.field_70143_R = 0.0f;
                serverPlayer.func_213317_d(Vec3d.field_186680_a);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        PlayerInventory inv = player.field_71071_by;
        ItemStack itemStack = inv.func_70301_a(inv.field_70461_c);
        World world = event.getEntityLiving().field_70170_p;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && world.func_180495_p(event.getPos()).func_177230_c() instanceof BedBlock && (itemStack != null && itemStack.func_77973_b() == RediscoveredItems.dream_pillow && (RediscoveredConfig.daytimeDreamPillow || !RediscoveredConfig.daytimeDreamPillow && !world.func_72935_r()) || player.field_71093_bK == RediscoveredDimensions.skylandsType()) && player instanceof ServerPlayerEntity) {
            event.setCanceled(true);
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (player.field_71093_bK == DimensionType.field_223227_a_) {
                player.func_213369_d(event.getPos());
                player.setSpawnPoint(event.getPos(), false, DimensionType.field_223227_a_);
                serverPlayer.func_200619_a(player.func_184102_h().func_71218_a(RediscoveredDimensions.skylandsType()), 2.5, 80.0, 2.5, serverPlayer.field_70177_z, serverPlayer.field_70125_A);
            } else if (player.field_71093_bK == RediscoveredDimensions.skylandsType()) {
                IChunk chunk = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_217349_x(player.func_180425_c());
                int transferY = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, player.func_180425_c().func_177958_n(), player.func_180425_c().func_177952_p()) + 1;
                Vec3d teleportationPos = new Vec3d((double)player.func_180425_c().func_177958_n() + 0.5, (double)transferY, (double)player.func_180425_c().func_177952_p() + 0.5);
                serverPlayer.func_200619_a(player.func_184102_h().func_71218_a(DimensionType.field_223227_a_), teleportationPos.func_82615_a(), teleportationPos.func_82617_b(), teleportationPos.func_82616_c(), serverPlayer.field_70177_z, serverPlayer.field_70125_A);
                BlockPos coordinates = player.getBedLocation(DimensionType.field_223227_a_);
                if (coordinates != null) {
                    coordinates = RediscoveredEvents.verifyRespawnCoordinates((World)player.func_184102_h().func_71218_a(DimensionType.field_223227_a_), coordinates, true, serverPlayer);
                }
                if (coordinates == null) {
                    coordinates = world.func_175694_M();
                    serverPlayer.func_70634_a((double)coordinates.func_177958_n() + 0.5, (double)coordinates.func_177956_o() + 3.0, (double)coordinates.func_177952_p() + 0.5);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.missingbed", new Object[0]), true);
                } else if (coordinates != null) {
                    serverPlayer.func_70634_a((double)coordinates.func_177958_n() + 0.5, (double)coordinates.func_177956_o() + 3.0, (double)coordinates.func_177952_p() + 0.5);
                }
            }
        }
        if (world.func_180495_p(event.getPos()).func_177230_c() instanceof DoublePlantBlock && itemStack != null && itemStack.func_77973_b().equals(Items.field_151097_aZ) && player instanceof ServerPlayerEntity) {
            ItemEntity item;
            ItemStack itemStack2;
            event.setCanceled(true);
            if (world.func_180495_p(event.getPos()) == Blocks.field_196802_gf.func_176223_P() || world.func_180495_p(event.getPos().func_177977_b()) == Blocks.field_196802_gf.func_176223_P()) {
                if (world.func_180495_p(event.getPos()) == Blocks.field_196802_gf.func_176223_P()) {
                    world.func_175655_b(event.getPos(), false);
                    world.func_175655_b(event.getPos().func_177984_a(), false);
                    world.func_175656_a(event.getPos(), (BlockState)RediscoveredBlocks.empty_rose_bush.func_176223_P().func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
                    world.func_175656_a(event.getPos().func_177984_a(), (BlockState)RediscoveredBlocks.empty_rose_bush.func_176223_P().func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER));
                } else if (world.func_180495_p(event.getPos().func_177977_b()) == Blocks.field_196802_gf.func_176223_P()) {
                    world.func_175655_b(event.getPos().func_177977_b(), false);
                    world.func_175655_b(event.getPos(), false);
                    world.func_175656_a(event.getPos().func_177977_b(), (BlockState)RediscoveredBlocks.empty_rose_bush.func_176223_P().func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
                    world.func_175656_a(event.getPos(), (BlockState)RediscoveredBlocks.empty_rose_bush.func_176223_P().func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER));
                }
                itemStack2 = new ItemStack((IItemProvider)RediscoveredBlocks.rose, world.field_73012_v.nextInt(3) + 1);
                item = new ItemEntity(world, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), itemStack2);
                world.func_217376_c((Entity)item);
            }
            if (world.func_180495_p(event.getPos()) == Blocks.field_196803_gg.func_176223_P() || world.func_180495_p(event.getPos().func_177977_b()) == Blocks.field_196803_gg.func_176223_P()) {
                if (world.func_180495_p(event.getPos()) == Blocks.field_196803_gg.func_176223_P()) {
                    world.func_175655_b(event.getPos(), false);
                    world.func_175655_b(event.getPos().func_177984_a(), false);
                    world.func_175656_a(event.getPos(), (BlockState)RediscoveredBlocks.empty_peony_bush.func_176223_P().func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
                    world.func_175656_a(event.getPos().func_177984_a(), (BlockState)RediscoveredBlocks.empty_peony_bush.func_176223_P().func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER));
                    world.func_175656_a(event.getPos(), (BlockState)RediscoveredBlocks.empty_peony_bush.func_176223_P().func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
                } else if (world.func_180495_p(event.getPos().func_177977_b()) == Blocks.field_196803_gg.func_176223_P()) {
                    world.func_175655_b(event.getPos().func_177977_b(), false);
                    world.func_175655_b(event.getPos(), false);
                    world.func_175656_a(event.getPos().func_177977_b(), (BlockState)RediscoveredBlocks.empty_peony_bush.func_176223_P().func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER));
                    world.func_175656_a(event.getPos(), (BlockState)RediscoveredBlocks.empty_peony_bush.func_176223_P().func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER));
                }
                itemStack2 = new ItemStack((IItemProvider)RediscoveredBlocks.paeonia, world.field_73012_v.nextInt(3) + 1);
                item = new ItemEntity(world, (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), itemStack2);
                world.func_217376_c((Entity)item);
            }
            event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        CreatureEntity entity;
        if (event.getEntity() instanceof CreatureEntity) {
            entity = (CreatureEntity)event.getEntity();
            if (event.getEntity() instanceof ZombieEntity) {
                if (RediscoveredConfig.mobsAttackScarecrow) {
                    entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, ScarecrowEntity.class, true));
                } else {
                    entity.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal(entity, ScarecrowEntity.class, 8.0f, 0.6, 0.6));
                }
            }
            if (event.getEntity() instanceof AnimalEntity) {
                entity.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal(entity, ScarecrowEntity.class, 8.0f, 1.0, 1.0));
            }
            if (event.getEntity() instanceof GiantEntity) {
                entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
                entity.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal(entity, 0.5, true));
                entity.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal(entity, 0.5));
                entity.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)entity, PlayerEntity.class, 8.0f));
                entity.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)entity));
                entity.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal(entity, new Class[0]));
                entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, true));
            }
        }
        if (RediscoveredConfig.undeadHorsesAgressive && (event.getEntity() instanceof ZombieHorseEntity || event.getEntity() instanceof SkeletonHorseEntity && !((SkeletonHorseEntity)event.getEntity()).func_190690_dh()) && !((AbstractHorseEntity)event.getEntity()).func_110248_bS() && !((AbstractHorseEntity)event.getEntity()).func_70631_g_()) {
            entity = (AbstractHorseEntity)event.getEntity();
            entity.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
            entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            entity.func_70606_j(30.0f);
            entity.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal(entity, 1.4, true));
            entity.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal(entity, new Class[0]));
            entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, true));
            entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, HorseEntity.class, true));
            entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, DonkeyEntity.class, true));
            entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, MuleEntity.class, true));
            entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, IronGolemEntity.class, true));
        }
    }

    @SubscribeEvent
    public void onPlayerRightClick(PlayerInteractEvent.RightClickItem event) {
        try {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            PlayerInventory inventory = player.field_71071_by;
            if (inventory.func_70448_g().func_77973_b() instanceof BowItem || inventory.func_70448_g().func_77973_b().getClass().getName().equals("mod.torchbowmod.TorchBow")) {
                ItemStack par1ItemStack = inventory.func_70301_a(inventory.field_70461_c);
                boolean flag = player.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)par1ItemStack) > 0;
                ItemStack chestSlot = player.func_184582_a(EquipmentSlotType.CHEST);
                ItemStack ammo = player.func_213356_f(event.getItemStack());
                if (chestSlot != null && chestSlot != ItemStack.field_190927_a && RediscoveredTags.Items.QUIVERS.func_199685_a_((Object)chestSlot.func_77973_b())) {
                    if (player.field_71071_by.func_199712_a(Tags.Items.ARROWS) || flag) {
                        player.field_70170_p.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
                        ArrowEntity entityarrow = new ArrowEntity(player.field_70170_p, (LivingEntity)player);
                        entityarrow.func_70243_d(true);
                        entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.3f, 1.0f);
                        if (!player.field_70170_p.field_72995_K) {
                            if (!flag) {
                                ammo.func_190918_g(1);
                            } else {
                                entityarrow.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                            }
                            player.field_70170_p.func_217376_c((Entity)entityarrow);
                        }
                    }
                    event.setCanceled(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (RediscoveredConfig.undeadHorsesAgressive && (event.getEntity() instanceof ZombieHorseEntity || event.getEntity() instanceof SkeletonHorseEntity && !((SkeletonHorseEntity)event.getEntity()).func_190690_dh()) && !((AbstractHorseEntity)event.getEntity()).func_110248_bS() && !((AbstractHorseEntity)event.getEntity()).func_70631_g_()) {
            AbstractHorseEntity horse = (AbstractHorseEntity)event.getEntityLiving();
            boolean removedPanic = false;
            if (!removedPanic) {
                horse.field_70714_bg.func_85156_a((Goal)new PanicGoal((CreatureEntity)horse, 1.2));
                horse.field_70714_bg.func_85156_a((Goal)new RunAroundLikeCrazyGoal(horse, 1.2));
                removedPanic = true;
            }
            if (horse.field_70170_p.func_72935_r() && !horse.field_70170_p.field_72995_K) {
                BlockPos blockpos;
                float f = horse.func_70013_c();
                BlockPos blockPos = blockpos = horse.func_184187_bx() instanceof BoatEntity ? new BlockPos(horse.field_70165_t, (double)Math.round(horse.field_70163_u), horse.field_70161_v).func_177984_a() : new BlockPos(horse.field_70165_t, (double)Math.round(horse.field_70163_u), horse.field_70161_v);
                if (f > 0.5f && horse.field_70170_p.field_73012_v.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && horse.field_70170_p.func_217337_f(blockpos)) {
                    horse.func_70015_d(8);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickAxe(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().func_77973_b() instanceof AxeItem) {
            BlockRayTraceResult rayTraceResult;
            BlockPos pos;
            PlayerEntity player = event.getPlayer();
            World world = event.getWorld();
            BlockState blockState = world.func_180495_p(pos = (rayTraceResult = (BlockRayTraceResult)RediscoveredEvents.rayTrace(world, player)).func_216350_a());
            if (blockState.func_177230_c() == RediscoveredBlocks.cherry_log) {
                player.func_130014_f_().func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, (BlockState)RediscoveredBlocks.stripped_cherry_log.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockState.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)), 11);
                    if (player != null) {
                        event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
                    }
                }
            }
            if (blockState.func_177230_c() == RediscoveredBlocks.cherry_wood) {
                player.func_130014_f_().func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, (BlockState)RediscoveredBlocks.stripped_cherry_wood.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockState.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)), 11);
                    if (player != null) {
                        event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
                    }
                }
            }
        }
    }

    public void onEntityMounted(EntityMountEvent event) {
        if (event.isMounting() && event.getEntityBeingMounted() instanceof RedDragonEntity && event.getEntityMounting() instanceof PlayerEntity) {
            ((PlayerEntity)event.getEntityMounting()).func_146105_b((ITextComponent)new TranslationTextComponent("Right Click dragon to dismount", new Object[0]), true);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (!RediscoveredConfig.disableGiantAppleDrops && event.getEntityLiving() instanceof GiantEntity && event.getEntityLiving().field_70170_p.field_73012_v.nextInt(5) == 0 && event.getEntityLiving().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack apple = new ItemStack((IItemProvider)Items.field_151153_ao);
            apple.func_190920_e(event.getEntityLiving().field_70170_p.field_73012_v.nextInt(2) + 1);
            event.getEntityLiving().func_199701_a_(apple);
        }
    }

    public static BlockPos verifyRespawnCoordinates(World par0World, BlockPos par1ChunkCoordinates, boolean par2, ServerPlayerEntity player) {
        if (player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_180495_p(par1ChunkCoordinates).func_177230_c() instanceof BedBlock) {
            return par1ChunkCoordinates;
        }
        return null;
    }

    protected static RayTraceResult rayTrace(World worldIn, PlayerEntity player) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vec3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)player));
    }

    @SubscribeEvent
    public void onRegisteredDimension(RegisterDimensionsEvent event) {
        RediscoveredDimensions.initDimensions();
    }
}

