/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.biome.feature.structure;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.world.biome.feature.structure.SmallPigmanVillageConfig;
import com.legacy.rediscovered.world.biome.feature.structure.SmallPigmanVillagePieces;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SmallPigmanVillageStructure
extends Structure<SmallPigmanVillageConfig> {
    public SmallPigmanVillageStructure(Function<Dynamic<?>, ? extends SmallPigmanVillageConfig> config) {
        super(config);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int posX, int posZ, int spacingOffsetsX, int spacingOffsetsZ) {
        int distance = 20;
        int separation = 11;
        int x = posX + distance * spacingOffsetsX;
        int z = posZ + distance * spacingOffsetsZ;
        int x1 = x < 0 ? x - distance + 1 : x;
        int z1 = z < 0 ? z - distance + 1 : z;
        int x2 = x1 / distance;
        int z2 = z1 / distance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), x2, z2, 10387313);
        x2 *= distance;
        z2 *= distance;
        return new ChunkPos(x2 += (random.nextInt(distance - separation) + random.nextInt(distance - separation)) / 2, z2 += (random.nextInt(distance - separation) + random.nextInt(distance - separation)) / 2);
    }

    public boolean func_202372_a(ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ChunkPos chunkPos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkPos.field_77276_a && chunkPosZ == chunkPos.field_77275_b) {
            int y = SmallPigmanVillageStructure.getYValue(chunkGen, chunkPos.field_77276_a, chunkPos.field_77275_b);
            return y >= 50;
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return RediscoveredMod.locate("small_pigman_village").toString();
    }

    public int func_202367_b() {
        return 8;
    }

    public static int getYValue(ChunkGenerator<?> chunkGen, int chunkX, int chunkZ) {
        Random random = new Random();
        return 100 + random.nextInt(50);
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int chunkX, int chunkZ, Biome biome, MutableBoundingBox boundingBox, int referenceIn, long seed) {
            super(structure, chunkX, chunkZ, biome, boundingBox, referenceIn, seed);
        }

        public void func_214625_a(ChunkGenerator<?> chunkGen, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            Rotation rotation = Rotation.NONE;
            int i = SmallPigmanVillageStructure.getYValue(chunkGen, chunkX, chunkZ);
            BlockPos blockpos = new BlockPos(chunkX * 16 + 8, i, chunkZ * 16 + 8);
            SmallPigmanVillagePieces.init(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }
    }
}

