/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.dimension;

import com.legacy.rediscovered.world.dimension.noise.BetaOctavesNoiseGenerator;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class SkyDimensionChunkGenerator
extends ChunkGenerator<OverworldGenSettings> {
    private Random rand;
    private BiomeProvider biomeProvider;
    private Biome[] biomesForGeneration;
    private BetaOctavesNoiseGenerator octaves1;
    private BetaOctavesNoiseGenerator octaves2;
    private BetaOctavesNoiseGenerator octaves3;
    private BetaOctavesNoiseGenerator scaleNoise;
    private BetaOctavesNoiseGenerator octaves7;
    private double[] octaveArr1;
    private double[] octaveArr2;
    private double[] octaveArr3;
    private double[] octaveArr4;
    private double[] octaveArr5;
    private double[] heightNoise;
    private final OverworldGenSettings settings;
    public static final int CHUNK_SIZE = 16;

    public SkyDimensionChunkGenerator(IWorld world, BiomeProvider biomeProvider, OverworldGenSettings settingsIn) {
        super(world, biomeProvider, (GenerationSettings)settingsIn);
        this.rand = new Random(this.field_222541_b);
        this.octaves1 = new BetaOctavesNoiseGenerator(this.rand, 16);
        this.octaves2 = new BetaOctavesNoiseGenerator(this.rand, 16);
        this.octaves3 = new BetaOctavesNoiseGenerator(this.rand, 8);
        this.scaleNoise = new BetaOctavesNoiseGenerator(this.rand, 10);
        this.octaves7 = new BetaOctavesNoiseGenerator(this.rand, 16);
        this.biomeProvider = biomeProvider;
        this.settings = settingsIn;
    }

    public void func_222535_c(IChunk chunk) {
        this.replaceBlocksForBiome(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, chunk, chunk.func_201590_e());
    }

    public void func_202093_c(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        Biome biome = region.func_212866_a_(i, j).func_201590_e()[0];
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202424_a(region.func_72905_C(), i << 4, j << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)i, (int)j, (Random)sharedseedrandom);
    }

    public OverworldGenSettings getSettings() {
        return this.settings;
    }

    public int func_205470_d() {
        return this.field_222540_a.func_181545_F();
    }

    public void func_222537_b(IWorld iWorld, IChunk chunkIn) {
        int x = chunkIn.func_76632_l().field_77276_a;
        int z = chunkIn.func_76632_l().field_77275_b;
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        this.biomesForGeneration = this.biomeProvider.func_201537_a(x * 16, z * 16, 16, 16, false);
        this.setBlocksInChunk(chunkIn);
        chunkIn.func_201577_a(this.biomesForGeneration);
    }

    private void setBlocksInChunk(IChunk chunk) {
        int byte0 = 2;
        int k = byte0 + 1;
        int byte1 = 33;
        int l = byte0 + 1;
        this.heightNoise = this.octaveGenerator(this.heightNoise, chunk.func_76632_l().field_77276_a * byte0, 0, chunk.func_76632_l().field_77275_b * byte0, k, byte1, l);
        for (int i1 = 0; i1 < byte0; ++i1) {
            for (int j1 = 0; j1 < byte0; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d = 0.25;
                    double d1 = this.heightNoise[((i1 + 0) * l + (j1 + 0)) * byte1 + (k1 + 0)];
                    double d2 = this.heightNoise[((i1 + 0) * l + (j1 + 1)) * byte1 + (k1 + 0)];
                    double d3 = this.heightNoise[((i1 + 1) * l + (j1 + 0)) * byte1 + (k1 + 0)];
                    double d4 = this.heightNoise[((i1 + 1) * l + (j1 + 1)) * byte1 + (k1 + 0)];
                    double d5 = (this.heightNoise[((i1 + 0) * l + (j1 + 0)) * byte1 + (k1 + 1)] - d1) * d;
                    double d6 = (this.heightNoise[((i1 + 0) * l + (j1 + 1)) * byte1 + (k1 + 1)] - d2) * d;
                    double d7 = (this.heightNoise[((i1 + 1) * l + (j1 + 0)) * byte1 + (k1 + 1)] - d3) * d;
                    double d8 = (this.heightNoise[((i1 + 1) * l + (j1 + 1)) * byte1 + (k1 + 1)] - d4) * d;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int j2 = 0; j2 < 8; ++j2) {
                                BlockState iblockstate = null;
                                if (d15 > 0.0) {
                                    iblockstate = Blocks.field_150348_b.func_176223_P();
                                }
                                int k2 = i2 + i1 * 8;
                                int l2 = l1 + k1 * 4;
                                int i3 = j2 + j1 * 8;
                                if (iblockstate != null) {
                                    chunk.func_177436_a(new BlockPos(k2, l2, i3), iblockstate, false);
                                }
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
    }

    public BlockPos func_211403_a(World worldIn, String name, BlockPos pos, int radius, boolean p_211403_5_) {
        Structure structure = (Structure)Feature.field_202300_at.get((Object)name.toLowerCase(Locale.ROOT));
        if (structure != null) {
            return structure.func_211405_a(worldIn, (ChunkGenerator)this, pos, radius, p_211403_5_);
        }
        return null;
    }

    private double[] octaveGenerator(double[] values, int xPos, int zPos, int size1, int size2, int size3, int j1) {
        if (values == null) {
            values = new double[size2 * size3 * j1];
        }
        double noiseFactor = 684.412;
        double d1 = 684.412;
        this.octaveArr4 = this.scaleNoise.generateNoiseOctaves(this.octaveArr4, xPos, size1, size2, j1, 1.121, 1.121, 0.5);
        this.octaveArr5 = this.octaves7.generateNoiseOctaves(this.octaveArr5, xPos, size1, size2, j1, 200.0, 200.0, 0.5);
        this.octaveArr1 = this.octaves3.generateNoiseOctaves(this.octaveArr1, xPos, zPos, size1, size2, size3, j1, (noiseFactor *= 2.0) / 80.0, d1 / 160.0, noiseFactor / 80.0);
        this.octaveArr2 = this.octaves1.generateNoiseOctaves(this.octaveArr2, xPos, zPos, size1, size2, size3, j1, noiseFactor, d1, noiseFactor);
        this.octaveArr3 = this.octaves2.generateNoiseOctaves(this.octaveArr3, xPos, zPos, size1, size2, size3, j1, noiseFactor, d1, noiseFactor);
        int k1 = 0;
        int l1 = 0;
        for (int j2 = 0; j2 < size2; ++j2) {
            for (int l2 = 0; l2 < j1; ++l2) {
                double d6;
                double d3 = 0.5;
                double d4 = 1.0 - d3;
                d4 *= d4;
                d4 *= d4;
                d4 = 1.0 - d4;
                double d5 = (this.octaveArr4[l1] + 256.0) / 512.0;
                if ((d5 *= d4) > 1.0) {
                    d5 = 1.0;
                }
                if ((d6 = this.octaveArr5[l1] / 8000.0) < 0.0) {
                    d6 = -d6 * 0.3;
                }
                if ((d6 = d6 * 3.0 - 2.0) > 1.0) {
                    d6 = 1.0;
                }
                d6 /= 8.0;
                d6 = 0.0;
                if (d5 < 0.0) {
                    d5 = 0.0;
                }
                d5 += 0.5;
                d6 = d6 * (double)size3 / 16.0;
                ++l1;
                double d7 = (double)size3 / 2.0;
                for (int j3 = 0; j3 < size3; ++j3) {
                    double d8 = 0.0;
                    double d9 = ((double)j3 - d7) * 8.0 / d5;
                    if (d9 < 0.0) {
                        d9 *= -1.0;
                    }
                    double d10 = this.octaveArr2[k1] / 512.0;
                    double d11 = this.octaveArr3[k1] / 512.0;
                    double d12 = (this.octaveArr1[k1] / 10.0 + 1.0) / 2.0;
                    d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= 8.0;
                    int k3 = 32;
                    if (j3 > size3 - k3) {
                        double d13 = (float)(j3 - (size3 - k3)) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d13) + -30.0 * d13;
                    }
                    if (j3 < (k3 = 8)) {
                        double d14 = (float)(k3 - j3) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d14) + -30.0 * d14;
                    }
                    values[k1] = d8;
                    ++k1;
                }
            }
        }
        return values;
    }

    private void replaceBlocksForBiome(int chunkX, int chunkZ, IChunk chunk, Biome[] biomes) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int b0 = 1;
                int k = -1;
                BlockState iblockstate = Blocks.field_196658_i.func_176223_P();
                BlockState iblockstate1 = Blocks.field_150346_d.func_176223_P();
                for (int l = 127; l >= 0; --l) {
                    BlockState iblockstate2 = chunk.func_180495_p(new BlockPos(i, l, j));
                    if (iblockstate2.func_196958_f()) {
                        k = -1;
                        continue;
                    }
                    if (iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
                    if (k == -1) {
                        if (b0 <= 0) {
                            iblockstate = Blocks.field_196658_i.func_176223_P();
                            iblockstate1 = Blocks.field_150346_d.func_176223_P();
                        }
                        k = b0;
                        if (l >= 0) {
                            chunk.func_177436_a(new BlockPos(i, l, j), iblockstate, false);
                            continue;
                        }
                        chunk.func_177436_a(new BlockPos(i, l, j), iblockstate1, false);
                        continue;
                    }
                    if (k <= 0) continue;
                    --k;
                    chunk.func_177436_a(new BlockPos(i, l, j), iblockstate1, false);
                }
            }
        }
    }

    public int func_222529_a(int p_222529_1_, int p_222529_2_, Heightmap.Type heightmapType) {
        return 0;
    }
}

