/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.render.model.RedDragonModel;
import com.legacy.rediscovered.entity.RedDragonEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RedDragonRenderer
extends EntityRenderer<RedDragonEntity> {
    private static final ResourceLocation DRAGON_TEXTURES = RediscoveredMod.locate("textures/entity/reddragon/red.png");
    private static final ResourceLocation DRAGON_EXPLODING_TEXTURES = new ResourceLocation("textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation EYES = RediscoveredMod.locate("textures/entity/reddragon/red_eyes.png");
    private static final RenderType TEXTURE_CUTOUT = RenderType.func_228640_c_((ResourceLocation)DRAGON_TEXTURES);
    private static final RenderType TEXTURE_DECAL = RenderType.func_228648_g_((ResourceLocation)DRAGON_TEXTURES);
    private static final RenderType EMISSIVE_EYES = RenderType.func_228652_i_((ResourceLocation)EYES);
    private final RedDragonModel model = new RedDragonModel();
    private static final float field_229057_l_ = (float)(Math.sqrt(3.0) / 2.0);

    public RedDragonRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(RedDragonEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        float f = (float)entityIn.getMovementOffsets(7, partialTicks)[0];
        float f1 = (float)(entityIn.getMovementOffsets(5, partialTicks)[1] - entityIn.getMovementOffsets(10, partialTicks)[1]);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f1 * 10.0f));
        matrixStackIn.func_227861_a_(0.0, 0.0, 1.0);
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.func_227861_a_(0.0, (double)-1.501f, 0.0);
        boolean flag = entityIn.field_70737_aN > 0;
        this.model.setLivingAnimations(entityIn, 0.0f, 0.0f, partialTicks);
        if (entityIn.deathTicks > 0) {
            float f2 = (float)entityIn.deathTicks / 200.0f;
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228635_a_((ResourceLocation)DRAGON_EXPLODING_TEXTURES, (float)f2));
            this.model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            IVertexBuilder ivertexbuilder1 = bufferIn.getBuffer(TEXTURE_DECAL);
            this.model.func_225598_a_(matrixStackIn, ivertexbuilder1, packedLightIn, OverlayTexture.func_229200_a_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            IVertexBuilder ivertexbuilder3 = bufferIn.getBuffer(TEXTURE_CUTOUT);
            this.model.func_225598_a_(matrixStackIn, ivertexbuilder3, packedLightIn, OverlayTexture.func_229200_a_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        IVertexBuilder ivertexbuilder4 = bufferIn.getBuffer(EMISSIVE_EYES);
        this.model.func_225598_a_(matrixStackIn, ivertexbuilder4, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (entityIn.deathTicks > 0) {
            float f5 = ((float)entityIn.deathTicks + partialTicks) / 200.0f;
            float f7 = 0.0f;
            if (f5 > 0.8f) {
                f7 = (f5 - 0.8f) / 0.2f;
            }
            Random random = new Random(432L);
            IVertexBuilder ivertexbuilder2 = bufferIn.getBuffer(RenderType.func_228657_l_());
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, -1.0, -2.0);
            int i = 0;
            while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f + f5 * 90.0f));
                float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
                float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
                int j = (int)(255.0f * (1.0f - f7));
                RedDragonRenderer.defaultVertex(ivertexbuilder2, matrix4f, j);
                RedDragonRenderer.func_229060_a_(ivertexbuilder2, matrix4f, f3, f4);
                RedDragonRenderer.func_229062_b_(ivertexbuilder2, matrix4f, f3, f4);
                RedDragonRenderer.defaultVertex(ivertexbuilder2, matrix4f, j);
                RedDragonRenderer.func_229062_b_(ivertexbuilder2, matrix4f, f3, f4);
                RedDragonRenderer.func_229063_c_(ivertexbuilder2, matrix4f, f3, f4);
                RedDragonRenderer.defaultVertex(ivertexbuilder2, matrix4f, j);
                RedDragonRenderer.func_229063_c_(ivertexbuilder2, matrix4f, f3, f4);
                RedDragonRenderer.func_229060_a_(ivertexbuilder2, matrix4f, f3, f4);
                ++i;
            }
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private static void defaultVertex(IVertexBuilder vertexBuilder, Matrix4f matrix, int p_229061_2_) {
        vertexBuilder.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, p_229061_2_).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, p_229061_2_).func_181675_d();
    }

    private static void func_229060_a_(IVertexBuilder vertexBuilder, Matrix4f matrix, float p_229060_2_, float p_229060_3_) {
        vertexBuilder.func_227888_a_(matrix, -field_229057_l_ * p_229060_3_, p_229060_2_, -0.5f * p_229060_3_).func_225586_a_(0, 255, 255, 0).func_181675_d();
    }

    private static void func_229062_b_(IVertexBuilder vertexBuilder, Matrix4f matrix, float p_229062_2_, float p_229062_3_) {
        vertexBuilder.func_227888_a_(matrix, field_229057_l_ * p_229062_3_, p_229062_2_, -0.5f * p_229062_3_).func_225586_a_(0, 255, 255, 0).func_181675_d();
    }

    private static void func_229063_c_(IVertexBuilder vertexBuilder, Matrix4f matrix, float p_229063_2_, float p_229063_3_) {
        vertexBuilder.func_227888_a_(matrix, 0.0f, p_229063_2_, 1.0f * p_229063_3_).func_225586_a_(0, 255, 255, 0).func_181675_d();
    }

    public ResourceLocation getEntityTexture(RedDragonEntity entity) {
        return DRAGON_TEXTURES;
    }
}

