/*
 * Decompiled with CFR 0.152.
 */
package com.stormister.rediscovered;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.stormister.rediscovered.EntityRediscoveredPotion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPotionRediscovered
extends Item {
    private Map effectCache = Maps.newHashMap();
    private static final Map SUB_ITEMS_CACHE = Maps.newLinkedHashMap();
    private final String name = "RediscoveredPotion";

    public ItemPotionRediscovered() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78038_k);
        GameRegistry.registerItem((Item)this, (String)"RediscoveredPotion");
        this.func_77655_b("Rediscovered_RediscoveredPotion");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return true;
    }

    public static String getType(ItemStack itemStack) {
        if (itemStack.func_77952_i() == 0 || itemStack.func_77952_i() == 100) {
            return "Nausea";
        }
        if (itemStack.func_77952_i() == 1 || itemStack.func_77952_i() == 101) {
            return "Blindness";
        }
        if (itemStack.func_77952_i() == 2 || itemStack.func_77952_i() == 102) {
            return "Dullness";
        }
        return "";
    }

    public List getEffects(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CustomPotionEffects", 9)) {
            ArrayList arraylist = Lists.newArrayList();
            NBTTagList nbttaglist = stack.func_77978_p().func_150295_c("CustomPotionEffects", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                PotionEffect potioneffect = PotionEffect.func_82722_b((NBTTagCompound)nbttagcompound);
                if (potioneffect == null) continue;
                arraylist.add(potioneffect);
            }
            return arraylist;
        }
        List list = (List)this.effectCache.get(stack.func_77960_j());
        if (list == null) {
            list = PotionHelper.func_77917_b((int)stack.func_77960_j(), (boolean)false);
            this.effectCache.put(stack.func_77960_j(), list);
        }
        return list;
    }

    public List getEffects(int meta) {
        List list = (List)this.effectCache.get(meta);
        if (list == null) {
            list = PotionHelper.func_77917_b((int)meta, (boolean)false);
            this.effectCache.put(meta, list);
        }
        return list;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (ItemPotionRediscovered.getType(itemStack) == "Nausea") {
            entityPlayer.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 600, 6));
        } else if (ItemPotionRediscovered.getType(itemStack) == "Blindness") {
            entityPlayer.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 600, 6));
        } else if (ItemPotionRediscovered.getType(itemStack) == "Dullness") {
            entityPlayer.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 600, 6));
        }
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            --itemStack.field_77994_a;
            if (itemStack.field_77994_a <= 0) {
                return new ItemStack(Items.field_151069_bo);
            }
            entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
        }
        return itemStack;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.DRINK;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (ItemPotionRediscovered.isSplash(itemStackIn.func_77960_j())) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --itemStackIn.field_77994_a;
            }
            worldIn.func_72956_a((Entity)playerIn, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)new EntityRediscoveredPotion(worldIn, (EntityLivingBase)playerIn, itemStackIn.func_77960_j()));
            }
            return itemStackIn;
        }
        playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        return itemStackIn;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (ItemPotionRediscovered.getType(itemStack) == "Nausea") {
            par3List.add("\u00a77Dizziness (0:30)");
        } else if (ItemPotionRediscovered.getType(itemStack) == "Blindness") {
            par3List.add("\u00a77Blindness (0:30)");
        } else if (ItemPotionRediscovered.getType(itemStack) == "Dullness") {
            par3List.add("\u00a77Slow Mining (0:30)");
        }
    }

    public String getName() {
        return "RediscoveredPotion";
    }

    public static boolean isSplash(int meta) {
        return (meta & 0x64) != 0;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + ItemPotionRediscovered.getType(stack) + (ItemPotionRediscovered.isSplash(stack.func_77960_j()) ? ".Splash" : "");
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List subItems) {
        subItems.add(new ItemStack(itemIn, 1, 0));
        subItems.add(new ItemStack(itemIn, 1, 1));
        subItems.add(new ItemStack(itemIn, 1, 2));
        subItems.add(new ItemStack(itemIn, 1, 100));
        subItems.add(new ItemStack(itemIn, 1, 101));
        subItems.add(new ItemStack(itemIn, 1, 102));
    }
}

