/*
 * Decompiled with CFR 0.152.
 */
package juuxel.vanillaparts.part;

import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.PartDefinition;
import alexiil.mc.lib.multipart.api.event.PartAddedEvent;
import alexiil.mc.lib.multipart.api.event.PartTickEvent;
import alexiil.mc.lib.multipart.api.property.MultipartProperties;
import alexiil.mc.lib.multipart.api.render.PartModelKey;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.NetByteBuf;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DataFixUtils;
import java.util.Locale;
import juuxel.vanillaparts.part.VanillaPart;
import juuxel.vanillaparts.part.model.StaticVanillaModelKey;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2555;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class TorchPart
extends VanillaPart {
    private static final ImmutableMap<Facing, class_265> SHAPES = ImmutableMap.of((Object)((Object)Facing.GROUND), (Object)class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), (Object)((Object)Facing.NORTH), (Object)class_2248.method_9541((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)((Object)Facing.SOUTH), (Object)class_2248.method_9541((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)((Object)Facing.WEST), (Object)class_2248.method_9541((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)((Object)Facing.EAST), (Object)class_2248.method_9541((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5));
    private final Facing facing;

    public TorchPart(PartDefinition definition, MultipartHolder holder, Facing facing) {
        super(definition, holder);
        this.facing = facing;
    }

    public TorchPart(PartDefinition definition, MultipartHolder holder, class_2487 tag) {
        super(definition, holder);
        Facing facing;
        try {
            facing = Facing.valueOf(tag.method_10558("Facing").toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            facing = Facing.GROUND;
        }
        this.facing = facing;
    }

    public TorchPart(PartDefinition definition, MultipartHolder holder, byte facing) {
        super(definition, holder);
        this.facing = Facing.values()[class_3532.method_15340((int)facing, (int)0, (int)4)];
    }

    public class_265 getShape() {
        return (class_265)SHAPES.get((Object)this.facing);
    }

    public class_265 getCollisionShape() {
        return class_259.method_1073();
    }

    public class_265 getDynamicShape(float partialTicks) {
        return this.getShape();
    }

    @Override
    public class_1799 getPickStack() {
        return new class_1799((class_1935)class_2246.field_10336);
    }

    public PartModelKey getModelKey() {
        return new StaticVanillaModelKey(this.getVanillaState());
    }

    @Override
    public void onAdded(MultipartEventBus bus) {
        super.onAdded(bus);
        bus.addListener((Object)this, PartAddedEvent.class, event -> this.holder.getContainer().getProperties().setValue((Object)this, MultipartProperties.LIGHT_VALUE, (Object)15));
        bus.addContextlessListener((Object)this, PartTickEvent.class, () -> {
            class_1937 world = this.getWorld();
            if (world.field_9236 && world.field_9229.nextInt(10) == 0) {
                class_2680 state = this.getVanillaState();
                state.method_11614().method_9496(state, world, this.getPos(), world.field_9229);
            }
        });
    }

    @Override
    public class_2680 getVanillaState() {
        return this.facing == Facing.GROUND ? class_2246.field_10336.method_9564() : (class_2680)class_2246.field_10099.method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)this.facing.getDirection());
    }

    public class_2487 toTag() {
        return (class_2487)DataFixUtils.make((Object)new class_2487(), tag -> tag.method_10582("Facing", this.facing.toString().toLowerCase(Locale.ROOT)));
    }

    public void writeCreationData(NetByteBuf buffer, IMsgWriteCtx ctx) {
        super.writeCreationData(buffer, ctx);
        buffer.writeByte((int)((byte)this.facing.ordinal()));
    }

    public static enum Facing {
        GROUND(class_2350.field_11033),
        NORTH(class_2350.field_11043),
        EAST(class_2350.field_11034),
        SOUTH(class_2350.field_11035),
        WEST(class_2350.field_11039);

        private final class_2350 direction;

        private Facing(class_2350 direction) {
            this.direction = direction;
        }

        public class_2350 getDirection() {
            return this.direction;
        }

        public static Facing of(class_2350 direction) {
            switch (direction) {
                case field_11043: {
                    return NORTH;
                }
                case field_11035: {
                    return SOUTH;
                }
                case field_11039: {
                    return WEST;
                }
                case field_11034: {
                    return EAST;
                }
            }
            return GROUND;
        }
    }
}

