/*
 * Decompiled with CFR 0.152.
 */
package juuxel.vanillaparts.part;

import alexiil.mc.lib.multipart.api.PartDefinition;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import juuxel.vanillaparts.VanillaParts;
import juuxel.vanillaparts.part.ButtonPart;
import juuxel.vanillaparts.part.CarpetPart;
import juuxel.vanillaparts.part.FencePart;
import juuxel.vanillaparts.part.LeverPart;
import juuxel.vanillaparts.part.SlabPart;
import juuxel.vanillaparts.part.StatelessPartFactory;
import juuxel.vanillaparts.part.TorchPart;
import juuxel.vanillaparts.util.Util;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2482;

public final class VPartDefinitions {
    public static final ImmutableMap<class_1767, class_2248> CARPETS;
    public static final ImmutableMap<class_1767, PartDefinition> CARPET_PARTS;
    public static final Map<class_2248, PartDefinition> SLAB_PARTS;
    public static final Map<class_2248, PartDefinition> BUTTON_PARTS;
    public static final Map<class_2248, PartDefinition> FENCE_PARTS;
    public static final PartDefinition TORCH;
    public static final PartDefinition LEVER;

    private VPartDefinitions() {
    }

    private static void register(PartDefinition def) {
        PartDefinition.PARTS.put(def.identifier, def);
    }

    public static void init() {
        for (PartDefinition def : CARPET_PARTS.values()) {
            VPartDefinitions.register(def);
        }
        VPartDefinitions.register(TORCH);
        VPartDefinitions.register(LEVER);
        Util.visitRegistry(class_2378.field_11146, (id, block) -> {
            if (block instanceof class_2482) {
                PartDefinition def = new PartDefinition(VanillaParts.id(id.method_12836() + "/" + id.method_12832()), (definition, holder, tag) -> new SlabPart(definition, holder, (class_2482)block, tag), (definition, holder, buf, ctx) -> new SlabPart(definition, holder, (class_2482)block, buf.readBoolean()));
                VPartDefinitions.register(def);
                SLAB_PARTS.put((class_2248)block, def);
            } else if (block instanceof class_2269) {
                PartDefinition def = new PartDefinition(VanillaParts.id(id.method_12836() + "/" + id.method_12832()), (definition, holder, tag) -> new ButtonPart(definition, holder, (class_2248)block, tag), (definition, holder, buf, ctx) -> new ButtonPart(definition, holder, (class_2248)block, buf));
                VPartDefinitions.register(def);
                BUTTON_PARTS.put((class_2248)block, def);
            } else if (block instanceof class_2354) {
                PartDefinition def = new PartDefinition(VanillaParts.id(id.method_12836() + "/" + id.method_12832()), (definition, holder, tag) -> new FencePart(definition, holder, (class_2248)block, tag.method_10577("North"), tag.method_10577("East"), tag.method_10577("South"), tag.method_10577("West")), (definition, holder, buf, ctx) -> new FencePart(definition, holder, (class_2248)block, buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean()));
                VPartDefinitions.register(def);
                FENCE_PARTS.put((class_2248)block, def);
            }
        });
    }

    static {
        SLAB_PARTS = new HashMap<class_2248, PartDefinition>();
        BUTTON_PARTS = new HashMap<class_2248, PartDefinition>();
        FENCE_PARTS = new HashMap<class_2248, PartDefinition>();
        TORCH = new PartDefinition(VanillaParts.id("torch"), TorchPart::new, (definition, holder, buffer, ctx) -> new TorchPart(definition, holder, buffer.readByte()));
        LEVER = new PartDefinition(VanillaParts.id("lever"), LeverPart::new, (definition, holder, buffer, ctx) -> new LeverPart(definition, holder, buffer));
        ImmutableMap.Builder partMapBuilder = ImmutableMap.builder();
        for (class_1767 color : class_1767.values()) {
            StatelessPartFactory factory = (def, holder) -> new CarpetPart(def, holder, color);
            PartDefinition definition2 = new PartDefinition(VanillaParts.id(color.method_15434() + "_carpet"), (PartDefinition.IPartNbtReader)factory, (PartDefinition.IPartNetLoader)factory);
            partMapBuilder.put((Object)color, (Object)definition2);
        }
        CARPET_PARTS = partMapBuilder.build();
        ImmutableMap.Builder carpetMapBuilder = ImmutableMap.builder();
        carpetMapBuilder.put((Object)class_1767.field_7952, (Object)class_2246.field_10466).put((Object)class_1767.field_7946, (Object)class_2246.field_9977).put((Object)class_1767.field_7958, (Object)class_2246.field_10482).put((Object)class_1767.field_7951, (Object)class_2246.field_10290).put((Object)class_1767.field_7947, (Object)class_2246.field_10512).put((Object)class_1767.field_7961, (Object)class_2246.field_10040).put((Object)class_1767.field_7954, (Object)class_2246.field_10393).put((Object)class_1767.field_7944, (Object)class_2246.field_10591).put((Object)class_1767.field_7967, (Object)class_2246.field_10209).put((Object)class_1767.field_7955, (Object)class_2246.field_10433).put((Object)class_1767.field_7945, (Object)class_2246.field_10510).put((Object)class_1767.field_7966, (Object)class_2246.field_10043).put((Object)class_1767.field_7957, (Object)class_2246.field_10473).put((Object)class_1767.field_7942, (Object)class_2246.field_10338).put((Object)class_1767.field_7964, (Object)class_2246.field_10536).put((Object)class_1767.field_7963, (Object)class_2246.field_10106);
        CARPETS = carpetMapBuilder.build();
    }
}

