/*
 * Decompiled with CFR 0.152.
 */
package juuxel.vanillaparts.part;

import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.PartDefinition;
import alexiil.mc.lib.multipart.api.event.PartEventEntityCollide;
import alexiil.mc.lib.multipart.api.event.PartTickEvent;
import alexiil.mc.lib.multipart.api.property.MultipartProperties;
import alexiil.mc.lib.multipart.api.property.MultipartPropertyContainer;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.NetByteBuf;
import com.mojang.datafixers.DataFixUtils;
import java.util.List;
import juuxel.vanillaparts.mixin.AbstractButtonBlockAccessor;
import juuxel.vanillaparts.part.WallMountedRedstonePart;
import juuxel.vanillaparts.util.Util;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public class ButtonPart
extends WallMountedRedstonePart {
    private final class_2248 block;
    private final AbstractButtonBlockAccessor buttonBlock;
    private int timer = 0;

    public ButtonPart(PartDefinition definition, MultipartHolder holder, class_2248 buttonBlock, class_2738 face, class_2350 facing) {
        super(definition, holder, face, facing, false);
        this.block = buttonBlock;
        this.buttonBlock = (AbstractButtonBlockAccessor)buttonBlock;
    }

    public ButtonPart(PartDefinition definition, MultipartHolder holder, class_2248 buttonBlock, class_2487 tag) {
        this(definition, holder, buttonBlock, ButtonPart.readFace(tag.method_10550("Face")), class_2350.method_10143((int)tag.method_10550("Facing")));
        this.powered = tag.method_10577("Powered");
        this.timer = tag.method_10550("Timer");
    }

    public ButtonPart(PartDefinition definition, MultipartHolder holder, class_2248 buttonBlock, NetByteBuf buf) {
        this(definition, holder, buttonBlock, ButtonPart.readFace(buf.readByte()), class_2350.method_10143((int)buf.readByte()));
    }

    public class_2487 toTag() {
        return (class_2487)DataFixUtils.make((Object)super.toTag(), tag -> {
            tag.method_10569("Face", this.face.ordinal());
            tag.method_10569("Facing", this.facing.method_10146());
            tag.method_10556("Powered", this.powered);
            tag.method_10569("Timer", this.timer);
        });
    }

    public void writeCreationData(NetByteBuf buffer, IMsgWriteCtx ctx) {
        super.writeCreationData(buffer, ctx);
        buffer.writeByte((int)((byte)this.face.ordinal()));
        buffer.writeByte((int)((byte)this.facing.method_10146()));
    }

    @Override
    public class_2680 getVanillaState() {
        return (class_2680)((class_2680)((class_2680)this.block.method_9564().method_11657((class_2769)class_2269.field_11007, (Comparable)this.face)).method_11657((class_2769)class_2269.field_11177, (Comparable)this.facing)).method_11657((class_2769)class_2269.field_10729, (Comparable)Boolean.valueOf(this.powered));
    }

    private void tick() {
        if (this.timer > 0) {
            --this.timer;
        }
        if (this.powered && this.timer <= 0) {
            if (this.buttonBlock.isWooden()) {
                this.tickWooden();
            } else {
                this.powered = false;
                if (!this.getWorld().field_9236) {
                    this.updateRedstoneLevels();
                    this.buttonBlock.callPlayClickSound(null, (class_1936)this.getWorld(), this.getPos(), false);
                }
                this.updateListeners();
            }
        }
    }

    private void tickWooden() {
        boolean hasEntities;
        List entities = this.getWorld().method_18467(class_1665.class, this.getShape().method_1107().method_996(this.getPos()));
        boolean bl = hasEntities = !entities.isEmpty();
        if (hasEntities != this.powered) {
            this.powered = hasEntities;
            if (!this.getWorld().field_9236) {
                this.updateRedstoneLevels();
                this.buttonBlock.callPlayClickSound(null, (class_1936)this.getWorld(), this.getPos(), hasEntities);
            }
            this.updateListeners();
            if (this.powered) {
                this.timer = this.block.method_9563((class_4538)this.getWorld());
            }
        }
    }

    public class_1269 onUse(class_1657 player, class_1268 hand, class_3965 hit) {
        if (!this.powered) {
            this.timer = this.block.method_9563((class_4538)player.field_6002);
            this.powered = true;
            if (!player.field_6002.field_9236) {
                this.updateRedstoneLevels();
            }
            this.buttonBlock.callPlayClickSound(player, (class_1936)player.field_6002, hit.method_17777(), true);
            this.updateListeners();
        }
        return class_1269.field_5812;
    }

    @Override
    public void onAdded(MultipartEventBus bus) {
        super.onAdded(bus);
        this.updateRedstoneLevels();
        MultipartPropertyContainer props = this.holder.getContainer().getProperties();
        props.setValue((Object)this, MultipartProperties.CAN_EMIT_REDSTONE, (Object)true);
        bus.addContextlessListener((Object)this, PartTickEvent.class, this::tick);
        bus.addListener((Object)this, PartEventEntityCollide.class, event -> this.tickWooden());
    }

    private static class_2738 readFace(int i) {
        return Util.safeGet(class_2738.values(), i);
    }
}

