/*
 * Decompiled with CFR 0.152.
 */
package juuxel.vanillaparts.part;

import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.PartDefinition;
import alexiil.mc.lib.multipart.api.event.PartAddedEvent;
import alexiil.mc.lib.multipart.api.event.PartRemovedEvent;
import alexiil.mc.lib.multipart.api.render.PartModelKey;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdDataK;
import alexiil.mc.lib.net.ParentNetIdSingle;
import com.google.common.collect.ImmutableMap;
import juuxel.vanillaparts.part.VanillaPart;
import juuxel.vanillaparts.part.model.DynamicVanillaModelKey;
import juuxel.vanillaparts.util.Util;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2310;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2746;
import net.minecraft.class_2769;

public abstract class HorizontallyConnectedPart
extends VanillaPart {
    public static final ParentNetIdSingle<HorizontallyConnectedPart> NET_HORIZONTALLY_CONNECTED;
    public static final NetIdDataK<HorizontallyConnectedPart> CONNECTION_DATA;
    private static final class_2350[] HORIZONTAL_DIRECTIONS;
    private static final ImmutableMap<class_2350, class_2746> DIRECTION_PROPERTIES;
    private boolean north = false;
    private boolean east = false;
    private boolean south = false;
    private boolean west = false;
    private boolean calculateConnections = false;
    protected final class_2310 block;

    public HorizontallyConnectedPart(PartDefinition definition, MultipartHolder holder, class_2248 block) {
        super(definition, holder);
        this.block = (class_2310)block;
        this.calculateConnections = true;
    }

    public HorizontallyConnectedPart(PartDefinition definition, MultipartHolder holder, class_2248 block, boolean north, boolean east, boolean south, boolean west) {
        this(definition, holder, block);
        this.north = north;
        this.east = east;
        this.south = south;
        this.west = west;
    }

    public class_2310 getBlock() {
        return this.block;
    }

    @Override
    public class_2680 getVanillaState() {
        return (class_2680)((class_2680)((class_2680)((class_2680)this.block.method_9564().method_11657((class_2769)class_2310.field_10905, (Comparable)Boolean.valueOf(this.north))).method_11657((class_2769)class_2310.field_10907, (Comparable)Boolean.valueOf(this.east))).method_11657((class_2769)class_2310.field_10904, (Comparable)Boolean.valueOf(this.south))).method_11657((class_2769)class_2310.field_10903, (Comparable)Boolean.valueOf(this.west));
    }

    public class_265 getOutlineShape() {
        return this.getVanillaState().method_17770((class_1922)class_2682.field_12294, class_2338.field_10980);
    }

    public class_265 getCollisionShape() {
        return this.getVanillaState().method_11628((class_1922)class_2682.field_12294, class_2338.field_10980);
    }

    public PartModelKey getModelKey() {
        return new DynamicVanillaModelKey(this);
    }

    protected abstract boolean canConnectTo(class_2338 var1, class_2350 var2);

    public boolean isBlocked(class_2350 d) {
        class_2746 directionProperty = (class_2746)DIRECTION_PROPERTIES.get((Object)d);
        if (directionProperty == null) {
            throw new IllegalArgumentException("Trying to check vertical connections in isBlocked()!");
        }
        class_265 fenceShape = ((class_2680)this.block.method_9564().method_11657((class_2769)directionProperty, (Comparable)Boolean.valueOf(true))).method_17770((class_1922)class_2682.field_12294, class_2338.field_10980);
        for (AbstractPart part : this.holder.getContainer().getAllParts()) {
            if (part == this || part.canOverlapWith((AbstractPart)this) || !class_259.method_1074((class_265)fenceShape, (class_265)part.getShape(), (class_247)class_247.field_16896)) continue;
            return true;
        }
        return false;
    }

    private boolean getConnection(class_2350 d) {
        switch (d) {
            case field_11043: {
                return this.north;
            }
            case field_11035: {
                return this.south;
            }
            case field_11039: {
                return this.west;
            }
        }
        return this.east;
    }

    private void setConnection(class_2350 d, boolean connected) {
        switch (d) {
            case field_11043: {
                this.north = connected;
                break;
            }
            case field_11035: {
                this.south = connected;
                break;
            }
            case field_11039: {
                this.west = connected;
                break;
            }
            case field_11034: {
                this.east = connected;
            }
        }
    }

    private void updateConnections(NetByteBuf buf, IMsgReadCtx ctx) {
        this.north = buf.readBoolean();
        this.east = buf.readBoolean();
        this.south = buf.readBoolean();
        this.west = buf.readBoolean();
        this.holder.getContainer().redrawIfChanged();
    }

    @Override
    protected void onNeighborUpdate(class_2338 neighborPos) {
        class_2350 side = Util.compare(this.getPos(), neighborPos);
        if (side.method_10166().method_10179()) {
            this.recalculateConnection(side, neighborPos);
        }
    }

    private void recalculateConnections() {
        class_2338 pos = this.getPos();
        class_2338.class_2339 mut = new class_2338.class_2339(pos);
        for (class_2350 direction : HORIZONTAL_DIRECTIONS) {
            mut.method_10098(direction);
            this.recalculateConnection(direction, (class_2338)mut);
            mut.method_10101((class_2382)pos);
        }
    }

    private void recalculateConnection(class_2350 side, class_2338 neighborPos) {
        boolean canConnect;
        boolean bl = canConnect = this.canConnectTo(neighborPos, side) && !this.isBlocked(side);
        if (this.getConnection(side) != canConnect) {
            this.setConnection(side, canConnect);
            this.holder.getContainer().sendNetworkUpdate((Object)this, CONNECTION_DATA, (obj, buf, ctx) -> buf.writeBoolean(this.north).writeBoolean(this.east).writeBoolean(this.south).writeBoolean(this.west));
        }
    }

    @Override
    public void onAdded(MultipartEventBus bus) {
        super.onAdded(bus);
        bus.addListener((Object)this, PartAddedEvent.class, event -> {
            if (event.part != this) {
                this.recalculateConnections();
            } else if (this.calculateConnections) {
                this.recalculateConnections();
                this.calculateConnections = false;
            }
        });
        bus.addListener((Object)this, PartRemovedEvent.class, event -> {
            this.holder.getContainer().recalculateShape();
            this.recalculateConnections();
        });
    }

    public class_2487 toTag() {
        return Util.with(super.toTag(), tag -> {
            tag.method_10556("North", this.north);
            tag.method_10556("East", this.east);
            tag.method_10556("South", this.south);
            tag.method_10556("West", this.west);
        });
    }

    public void writeCreationData(NetByteBuf buf, IMsgWriteCtx ctx) {
        super.writeCreationData(buf, ctx);
        buf.writeBoolean(this.north).writeBoolean(this.east).writeBoolean(this.south).writeBoolean(this.west);
    }

    static {
        HORIZONTAL_DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
        DIRECTION_PROPERTIES = ImmutableMap.of((Object)class_2350.field_11043, (Object)class_2310.field_10905, (Object)class_2350.field_11034, (Object)class_2310.field_10907, (Object)class_2350.field_11035, (Object)class_2310.field_10904, (Object)class_2350.field_11039, (Object)class_2310.field_10903);
        NET_HORIZONTALLY_CONNECTED = NET_ID.subType(HorizontallyConnectedPart.class, "vanilla_parts:horizontally_connected");
        CONNECTION_DATA = NET_HORIZONTALLY_CONNECTED.idData("connection_data").setReceiver(HorizontallyConnectedPart::updateConnections);
    }
}

