/*
 * Decompiled with CFR 0.152.
 */
package juuxel.vanillaparts;

import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartContainer;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.MultipartUtil;
import alexiil.mc.lib.multipart.api.NativeMultipart;
import alexiil.mc.lib.multipart.api.PartDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import juuxel.vanillaparts.part.ButtonPart;
import juuxel.vanillaparts.part.CarpetPart;
import juuxel.vanillaparts.part.FencePart;
import juuxel.vanillaparts.part.LeverPart;
import juuxel.vanillaparts.part.SlabPart;
import juuxel.vanillaparts.part.TorchPart;
import juuxel.vanillaparts.part.VPartDefinitions;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2401;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2577;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public enum MultipartItemTweak implements UseBlockCallback
{
    INSTANCE;

    private final Event<Predicate<class_2248>> checkers = EventFactory.createArrayBacked(Predicate.class, checkers -> block -> {
        for (Predicate checker : checkers) {
            if (!checker.test(block)) continue;
            return true;
        }
        return false;
    });
    private final List<Extension> extensions = new ArrayList<Extension>();

    public void addExtension(Extension extension) {
        this.extensions.add(extension);
    }

    public void addCustomContainerChecker(Predicate<class_2248> checker) {
        this.checkers.register(checker);
    }

    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            class_1747 bi = (class_1747)item;
            class_2248 block = bi.method_7711();
            class_2338 pos = hit.method_17777().method_10093(hit.method_17780());
            MultipartContainer.PartOffer offer = null;
            if (MultipartItemTweak.isMissingContainer(world, pos) && !(block instanceof class_2482) && !(block instanceof class_2354) && !((Predicate)this.checkers.invoker()).test(block)) {
                return class_1269.field_5811;
            }
            if (block instanceof class_2577) {
                offer = this.handleCarpets(world, pos, block);
            } else if (block == class_2246.field_10336) {
                offer = this.handleTorches(player, world, hand, hit, pos);
            } else if (block instanceof class_2482) {
                offer = this.handleSlabs(player, world, hand, hit, pos, block);
            } else if (block == class_2246.field_10363) {
                offer = this.handleWallMounted(player, world, hand, hit, pos, block, (holder, face, facing) -> new LeverPart(VPartDefinitions.LEVER, holder, face, facing, false));
            } else if (block instanceof class_2269) {
                offer = this.handleWallMounted(player, world, hand, hit, pos, block, (holder, face, facing) -> new ButtonPart(VPartDefinitions.BUTTON_PARTS.get(block), holder, block, face, facing));
            } else if (block instanceof class_2354) {
                offer = this.handleFences(world, hit, pos, block);
            } else {
                Extension extension;
                Iterator<Extension> iterator = this.extensions.iterator();
                while (iterator.hasNext() && (offer = (extension = iterator.next()).handle(block, player, world, hand, hit, pos)) == null) {
                }
                if (offer == null) {
                    return class_1269.field_5811;
                }
            }
            if (offer != null) {
                if (!world.field_9236) {
                    offer.apply();
                    if (!player.field_7503.field_7477) {
                        stack.method_7934(1);
                    }
                }
                class_2498 sounds = block.method_9564().method_26231();
                world.method_8396(player, pos, sounds.method_10598(), class_3419.field_15245, (sounds.method_10597() + 1.0f) / 2.0f, sounds.method_10599() * 0.8f);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static boolean isMissingContainer(class_1937 world, class_2338 pos) {
        return !(world.method_8320(pos).method_26204() instanceof NativeMultipart) && MultipartUtil.get((class_1937)world, (class_2338)pos) == null;
    }

    private MultipartContainer.PartOffer handleCarpets(class_1937 world, class_2338 pos, class_2248 block) {
        if (!block.method_9564().method_26184((class_4538)world, pos)) {
            return null;
        }
        class_1767 color = ((class_2577)block).method_10925();
        return MultipartUtil.offerNewPart((class_1937)world, (class_2338)pos, holder -> new CarpetPart((PartDefinition)VPartDefinitions.CARPET_PARTS.get((Object)color), holder, color));
    }

    private MultipartContainer.PartOffer handleTorches(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit, class_2338 pos) {
        class_1750 ctx;
        class_2680 torchState;
        if (hit.method_17780().method_10166().method_10179() ? (torchState = class_2246.field_10099.method_9605(ctx = new class_1750(new class_1838(player, hand, hit)))) == null || !torchState.method_26184((class_4538)world, pos) : !class_2246.field_10336.method_9564().method_26184((class_4538)world, pos)) {
            return null;
        }
        TorchPart.Facing facing = TorchPart.Facing.of(hit.method_17780());
        return MultipartUtil.offerNewPart((class_1937)world, (class_2338)pos, holder -> new TorchPart(VPartDefinitions.TORCH, holder, facing));
    }

    private MultipartContainer.PartOffer handleSlabs(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit, class_2338 pos, class_2248 block) {
        if (!VPartDefinitions.SLAB_PARTS.containsKey(block)) {
            return null;
        }
        return this.handleAnySlabs(player, world, hand, hit, pos, block, (holder, top) -> new SlabPart(VPartDefinitions.SLAB_PARTS.get(block), (MultipartHolder)holder, (class_2482)block, (boolean)top));
    }

    private MultipartContainer.PartOffer handleAnySlabs(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit, class_2338 pos, class_2248 block, BiFunction<MultipartHolder, Boolean, AbstractPart> factory) {
        class_2680 hitState = world.method_8320(hit.method_17777());
        if (block == hitState.method_26204() && hit.method_17780().method_10166().method_10178()) {
            class_2350 side = hit.method_17780();
            if (side == class_2350.field_11036 && hitState.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681) {
                return null;
            }
            if (side == class_2350.field_11033 && hitState.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12679) {
                return null;
            }
        }
        class_2338 originalPos = pos.method_10093(hit.method_17780().method_10153());
        MultipartContainer.PartOffer offer = null;
        if (!MultipartItemTweak.isMissingContainer(world, originalPos) && hit.method_17780().method_10166().method_10178()) {
            offer = MultipartUtil.offerNewPart((class_1937)world, (class_2338)originalPos, holder -> (AbstractPart)factory.apply(holder, hit.method_17780() == class_2350.field_11036));
        }
        if (offer == null && !MultipartItemTweak.isMissingContainer(world, pos)) {
            class_2680 placementState = block.method_9605(new class_1750(new class_1838(player, hand, hit)));
            if (placementState == null || placementState.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12682) {
                return null;
            }
            offer = MultipartUtil.offerNewPart((class_1937)world, (class_2338)pos, holder -> (AbstractPart)factory.apply(holder, placementState.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12679));
        }
        return offer;
    }

    private MultipartContainer.PartOffer handleWallMounted(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit, class_2338 pos, class_2248 block, WallMountedPartFactory factory) {
        class_2350[] directions;
        class_1750 ctx = new class_1750(new class_1838(player, hand, hit));
        for (class_2350 direction : directions = ctx.method_7718()) {
            class_2680 vanillaState = direction.method_10166().method_10178() ? (class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2401.field_11007, (Comparable)(direction == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475))).method_11657((class_2769)class_2401.field_11177, (Comparable)ctx.method_8042()) : (class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_2401.field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)class_2401.field_11177, (Comparable)direction.method_10153());
            if (!vanillaState.method_26184((class_4538)world, pos)) continue;
            return MultipartUtil.offerNewPart((class_1937)world, (class_2338)pos, holder -> factory.create(holder, (class_2738)vanillaState.method_11654((class_2769)class_2401.field_11007), (class_2350)vanillaState.method_11654((class_2769)class_2401.field_11177)));
        }
        return null;
    }

    private MultipartContainer.PartOffer handleFences(class_1937 world, class_3965 hit, class_2338 pos, class_2248 block) {
        if (!block.method_9564().method_26184((class_4538)world, pos)) {
            return null;
        }
        MultipartContainer.PartOffer offer = null;
        MultipartContainer.MultipartCreator creator = holder -> new FencePart(VPartDefinitions.FENCE_PARTS.get(block), holder, block);
        if (!MultipartItemTweak.isMissingContainer(world, hit.method_17777())) {
            offer = MultipartUtil.offerNewPart((class_1937)world, (class_2338)hit.method_17777(), (MultipartContainer.MultipartCreator)creator);
        }
        if (offer == null && !MultipartItemTweak.isMissingContainer(world, pos)) {
            offer = MultipartUtil.offerNewPart((class_1937)world, (class_2338)pos, (MultipartContainer.MultipartCreator)creator);
        }
        return offer;
    }

    @FunctionalInterface
    public static interface Extension {
        public MultipartContainer.PartOffer handle(class_2248 var1, class_1657 var2, class_1937 var3, class_1268 var4, class_3965 var5, class_2338 var6);
    }

    @FunctionalInterface
    private static interface WallMountedPartFactory {
        public AbstractPart create(MultipartHolder var1, class_2738 var2, class_2350 var3);
    }
}

