/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness;

import com.corosus.zombieawareness.ZAUtil;
import com.corosus.zombieawareness.ZombieAwareness;
import com.corosus.zombieawareness.client.SoundProfileEntry;
import com.corosus.zombieawareness.config.ZAConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="zombieawareness", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ZAEventHandler {
    @SubscribeEvent
    public void noteBlockEvent(NoteBlockEvent.Play event) {
        if (event.getWorld() instanceof World) {
            ZAUtil.hookSoundEvent(SoundEvents.field_187679_dF, (World)event.getWorld(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p(), 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void soundEvent(PlaySoundAtEntityEvent event) {
        try {
            if (event.getEntity() != null && !event.getEntity().field_70170_p.func_201670_d()) {
                ZAUtil.hookSoundEvent(event.getSound(), event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), event.getVolume(), event.getPitch());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void setAttackTarget(LivingSetAttackTargetEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (!ZAUtil.isZombieAwarenessActive(event.getEntityLiving().field_70170_p)) {
                return;
            }
            ZAUtil.hookSetAttackTarget(event);
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (!ZAUtil.isZombieAwarenessActive(event.getEntityLiving().field_70170_p)) {
                return;
            }
            if (!ZAConfig.blockHittingEvent_Active) {
                return;
            }
            ZAUtil.hookBlockEvent((PlayerEvent)event, ZAConfig.blockHittingEvent_OddsTo1);
        }
    }

    @SubscribeEvent
    public void harvest(PlayerEvent.HarvestCheck event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (!event.getWorld().func_201670_d() && event.getWorld() instanceof World) {
            if (!ZAUtil.isZombieAwarenessActive((World)event.getWorld())) {
                return;
            }
            if (!ZAConfig.blockBreakEvent_Active) {
                return;
            }
            ZombieAwareness.dbg("HarvestDrops event");
            ZAUtil.handleBlockBasedEvent(event.getPlayer(), (World)event.getWorld(), event.getPos(), 3);
        }
    }

    @SubscribeEvent
    public void interact(PlayerInteractEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K || event.getHand() == Hand.MAIN_HAND) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void tickEntity(LivingEvent.LivingUpdateEvent event) {
        LivingEntity ent = event.getEntityLiving();
        if (ent.field_70170_p.field_72995_K) {
            return;
        }
        if ((ent.field_70170_p.func_82737_E() + (long)ent.func_145782_y()) % (long)ZAConfig.tickRateAILoop == 0L && ZombieAwareness.canProcessEntity((Entity)ent) && ent instanceof MobEntity) {
            ZAUtil.tickAI((MobEntity)ent);
        }
    }

    @SubscribeEvent
    public void tickPlayer(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K || event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.player.field_70170_p.func_82737_E() % (long)ZAConfig.tickRatePlayerLoop == 0L) {
            ZAUtil.tickPlayer(event.player);
        }
    }

    @SubscribeEvent
    public void explosion(ExplosionEvent.Detonate event) {
        SoundProfileEntry entry = ZAUtil.getFirstEntry(SoundEvents.field_187539_bB.field_187506_b.toString());
        if (entry != null) {
            Vector3d pos = event.getExplosion().getPosition();
            PlayerEntity closestPlayer = ZAUtil.getClosestPlayer(event.getWorld(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 128.0);
            if (closestPlayer != null) {
                ZAUtil.handleSoundProfileEvent(event.getWorld(), entry, pos, closestPlayer);
            }
        }
    }
}

