/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness;

import com.corosus.coroutil.util.CoroUtilAttributes;
import com.corosus.coroutil.util.CoroUtilEntity;
import com.corosus.coroutil.util.CoroUtilPath;
import com.corosus.coroutil.util.CoroUtilWorldTime;
import com.corosus.zombieawareness.EntityRegistry;
import com.corosus.zombieawareness.EntityScent;
import com.corosus.zombieawareness.EnumSenseType;
import com.corosus.zombieawareness.WorldData;
import com.corosus.zombieawareness.ZombieAwareness;
import com.corosus.zombieawareness.client.SoundProfileEntry;
import com.corosus.zombieawareness.client.SoundRegistry;
import com.corosus.zombieawareness.config.ZAConfig;
import com.corosus.zombieawareness.config.ZAConfigFeatures;
import com.corosus.zombieawareness.config.ZAConfigPlayerLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.Effects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ZAUtil {
    public static Random rand = new Random();
    public static HashMap<String, Integer> lastHealths = new HashMap();
    public static HashMap<String, Long> lastBleedTimes = new HashMap();
    public static List<SoundProfileEntry> listSoundProfiles = new ArrayList<SoundProfileEntry>();
    public static WeakHashMap<Entity, Long> lookupLastAlertTime = new WeakHashMap();
    public static long alertDelay = 1200L;
    public static WeakHashMap<Entity, Long> lookupLastInvestigateTime = new WeakHashMap();
    public static long investigateDelay = 1200L;
    public static HashMap<String, Long> lookupLastWaypointTime = new HashMap();
    public static HashMap<EntityType, Boolean> lookupTickableEntitiesCache = new HashMap();
    public static HashMap<RegistryKey<World>, WorldData> lookupWorldData = new HashMap();
    public static boolean debug = false;

    public static void addSoundHooks() {
        int noisyInteractRange = 30;
        double noisyInteractBuff = 1.3;
        listSoundProfiles.clear();
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187734_u, 1.1));
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187731_t, 1.1));
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_219609_bA, 1.1));
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187651_T, noisyInteractBuff).setDistanceMax(noisyInteractRange));
        ArrayList<Integer> listDoorSoundEvents = new ArrayList<Integer>();
        listDoorSoundEvents.add(1037);
        listDoorSoundEvents.add(1007);
        listDoorSoundEvents.add(1036);
        listDoorSoundEvents.add(1013);
        listDoorSoundEvents.add(1011);
        listDoorSoundEvents.add(1012);
        listDoorSoundEvents.add(1005);
        listDoorSoundEvents.add(1006);
        listDoorSoundEvents.add(1008);
        listDoorSoundEvents.add(1014);
        listSoundProfiles.add(new SoundProfileEntry("debug-doors", noisyInteractBuff).setListSoundEventTypes(listDoorSoundEvents));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1010);
        listSoundProfiles.add(new SoundProfileEntry("debug-records", 300.0).setListSoundEventTypes(list));
        listSoundProfiles.add(new SoundProfileEntry(".place", noisyInteractBuff));
        listSoundProfiles.add(new SoundProfileEntry("player.burp", 1.1));
        listSoundProfiles.add(new SoundProfileEntry("block.note", noisyInteractBuff).setDistanceMax(64.0));
        listSoundProfiles.add(new SoundProfileEntry("lever.click", noisyInteractBuff).setDistanceMax(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("pressure_plate", noisyInteractBuff).setDistanceMax(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("button.click", noisyInteractBuff).setDistanceMax(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("tripwire", noisyInteractBuff).setDistanceMax(noisyInteractRange));
        listSoundProfiles.add(new SoundProfileEntry("block.barrel", noisyInteractBuff).setDistanceMax(noisyInteractRange));
        if (ZAConfigFeatures.noisyZombies) {
            listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187899_gZ, 0.8, 160).setDistanceMax(48.0));
        }
        if (ZAConfigFeatures.noisyPistons) {
            listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187715_dR, 2.0, 20).setDistanceMax(128.0));
        }
        listSoundProfiles.add(new SoundProfileEntry(SoundEvents.field_187539_bB, 3.0).setDistanceMax(128.0));
    }

    public static SoundProfileEntry getFirstEntry(int soundType) {
        for (SoundProfileEntry entry : listSoundProfiles) {
            if (!entry.isSoundType() || !entry.containsSoundType(soundType)) continue;
            return entry;
        }
        return null;
    }

    public static SoundProfileEntry getFirstEntry(String sound) {
        for (SoundProfileEntry entry : listSoundProfiles) {
            if (entry.getSoundName().equals(sound)) {
                return entry;
            }
            if (!entry.isPartialMatchOnly() || !sound.contains(entry.getSoundName())) continue;
            return entry;
        }
        return null;
    }

    public static void tickPlayer(PlayerEntity player) {
        if (ZAConfigFeatures.wanderingHordes) {
            long lastWaypoint;
            long l = lastWaypoint = lookupLastWaypointTime.containsKey(CoroUtilEntity.getName((Entity)player)) ? lookupLastWaypointTime.get(CoroUtilEntity.getName((Entity)player)) : 0L;
            if (lastWaypoint < System.currentTimeMillis()) {
                lastWaypoint = System.currentTimeMillis() + (long)ZAConfigFeatures.frequencyOfWanderingHordesPerPlayer * 1000L;
                lookupLastWaypointTime.put(CoroUtilEntity.getName((Entity)player), lastWaypoint);
                ZAUtil.spawnWaypoint((Entity)player);
            }
        }
        if (ZAConfigFeatures.awareness_Scent && !player.func_184812_l_()) {
            EntityScent scent;
            int lastHealth = lastHealths.containsKey(CoroUtilEntity.getName((Entity)player)) ? lastHealths.get(CoroUtilEntity.getName((Entity)player)) : 0;
            Long lastBleedTime = lastBleedTimes.containsKey(CoroUtilEntity.getName((Entity)player)) ? lastBleedTimes.get(CoroUtilEntity.getName((Entity)player)) : Long.valueOf(0L);
            Vector3d pos = new Vector3d(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            if ((int)player.func_110143_aJ() != lastHealth) {
                if (player.func_110143_aJ() < (float)lastHealth) {
                    scent = ZAUtil.spawnOrBuffSenseAtPos(player.field_70170_p, pos, EnumSenseType.SCENT_BLOOD, ZAConfig.scentStrength);
                    ZombieAwareness.dbg("spawned or buffed scent sense from damage: " + scent.getStrengthPeak());
                }
                lastHealth = (int)player.func_110143_aJ();
            }
            lastHealths.put(CoroUtilEntity.getName((Entity)player), lastHealth);
            if (player.func_110143_aJ() / player.func_110138_aP() < 0.6f && lastBleedTime < System.currentTimeMillis()) {
                lastBleedTime = System.currentTimeMillis() + 30000L;
                lastBleedTimes.put(CoroUtilEntity.getName((Entity)player), lastBleedTime);
                scent = ZAUtil.spawnOrBuffSenseAtPos(player.field_70170_p, pos, EnumSenseType.SCENT_BLOOD, ZAConfig.scentStrength);
                ZombieAwareness.dbg("spawned or buffed scent sense from bleeding: " + scent.getStrengthPeak());
            }
        }
    }

    public static void giveRandomSpeedBoost(MobEntity ent) {
        if (ZAConfig.zombieRandSpeedBoost > 0.0) {
            double randBoost = ent.field_70170_p.field_73012_v.nextDouble() * ZAConfig.zombieRandSpeedBoost;
            AttributeModifier speedBoostModifier = new AttributeModifier(CoroUtilAttributes.SPEED_BOOST_UUID, "ZA speed boost", randBoost, AttributeModifier.Operation.MULTIPLY_BASE);
            if (!ent.func_110148_a(Attributes.field_233821_d_).func_180374_a(speedBoostModifier)) {
                ent.func_110148_a(Attributes.field_233821_d_).func_233769_c_(speedBoostModifier);
            }
        }
    }

    public static void huntTarget(MobEntity ent, LivingEntity targ, int pri) {
        CoroUtilPath.tryMoveToEntityLivingLongDist((MobEntity)ent, (Entity)targ, (double)1.0);
        if (ent instanceof MobEntity) {
            ent.func_70624_b(targ);
        }
    }

    public static void huntTarget(MobEntity ent, LivingEntity targ) {
        ZAUtil.huntTarget(ent, targ, 0);
    }

    public static boolean isEnemy(Entity ent, Entity targ) {
        return ZAUtil.isEnemy(ent, targ, false);
    }

    public static boolean isEnemy(Entity ent, Entity targ, boolean omniTarget) {
        if (targ instanceof LivingEntity) {
            if (targ instanceof PlayerEntity && !((PlayerEntity)targ).func_184812_l_() && ((PlayerEntity)targ).func_70660_b(Effects.field_76441_p) == null) {
                if (!omniTarget) {
                    return true;
                }
                if (ZAConfigPlayerLists.whiteListUsedOmniscient) {
                    if (ZAConfigPlayerLists.whitelistOmniscientTargettedPlayers.contains(CoroUtilEntity.getName((Entity)((PlayerEntity)targ)))) {
                        if (ZAConfig.debugConsoleOmniscient) {
                            ZombieAwareness.dbg(CoroUtilEntity.getName((Entity)((PlayerEntity)targ)) + " targetting omnisciently by " + ent);
                        }
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean sanityCheck(Entity ent, Entity entity1) {
        return true;
    }

    public static void tickAI(MobEntity ent) {
        PlayerEntity player;
        PathPoint pathTo;
        if (ZAConfig.debugConsoleSuperDetailed) {
            ZombieAwareness.dbg("ZA DBG: Ticking: " + ent);
        }
        if ((ent.field_70170_p.func_82737_E() + (long)ent.func_145782_y()) % 40L == 0L) {
            if (ZAConfig.omniscient && ent.func_70638_az() == null) {
                ZAUtil.ai_FindTarget(ent, true);
            } else {
                ZAUtil.ai_FindTarget(ent, false);
            }
        }
        EntityScent senseTracked = null;
        if (ent.func_70638_az() == null && ent.func_70661_as().func_75500_f()) {
            if (!ZAConfig.awareness_Light_OnlyZombies || ent instanceof ZombieEntity) {
                if (!(ZAConfigFeatures.awareness_Light && ZAUtil.ai_FindLightSource(ent) || ent.field_70170_p.field_73012_v.nextInt(3) != 0)) {
                    senseTracked = ZAUtil.ai_FindSense(ent, true);
                }
            } else {
                senseTracked = ZAUtil.ai_FindSense(ent);
            }
        }
        if (senseTracked != null && ent.func_70661_as().func_75505_d() != null && (pathTo = ent.func_70661_as().func_75505_d().func_75870_c()) != null && (player = ZAUtil.getClosestPlayer(ent.field_70170_p, pathTo.field_75839_a, pathTo.field_75837_b, pathTo.field_75838_c, 6.0)) != null) {
            ZAUtil.tryPlayInvestigateSound(ent, new Vector3d((double)pathTo.field_75839_a, (double)pathTo.field_75837_b, (double)pathTo.field_75838_c));
        }
        ZAUtil.tickCustomMob(ent);
    }

    public static void tickCustomMob(MobEntity ent) {
        if (ZAConfigFeatures.wanderingHordes && ent instanceof SpiderEntity && ent.func_184188_bt().size() > 0 && ent.func_184188_bt().get(0) instanceof SkeletonEntity && ent.field_70170_p.field_73012_v.nextInt(100) == 0) {
            ZAUtil.spawnWaypoint((Entity)ent);
        }
    }

    public static boolean ai_FindLightSource(MobEntity ent) {
        if (ent.field_70170_p.func_72935_r()) {
            return false;
        }
        if (ent.field_70170_p.field_73012_v.nextInt(3) == 0) {
            float lightValueAtEntity = ent.field_70170_p.func_205052_D(ent.func_233580_cy_());
            Random rand = new Random();
            for (int i = 0; i < 4; ++i) {
                boolean canSeePos;
                float lightValue;
                int rZ;
                int rY;
                PlayerEntity entP = ZAUtil.getClosestPlayerToEntity(ent.field_70170_p, (Entity)ent, 999.0);
                if (entP == null) continue;
                int size = 32 * (i + 1);
                int rX = MathHelper.func_76128_c((double)(entP.func_226277_ct_() + (double)(rand.nextInt(size) - size / 2)));
                BlockPos pos = new BlockPos(rX, rY = MathHelper.func_76128_c((double)(entP.func_226278_cu_() + (double)(rand.nextInt(size / 2) - size / 4))), rZ = MathHelper.func_76128_c((double)(entP.func_226281_cx_() + (double)(rand.nextInt(size) - size / 2))));
                if (!ent.field_70170_p.func_195588_v(pos) || !((lightValue = entP.field_70170_p.func_205052_D(pos)) > 0.2f) || !(lightValue >= lightValueAtEntity) || ent.field_70170_p.field_73012_v.nextInt(5) != 0 || !(ent.func_70032_d((Entity)entP) > 64.0f) || !(canSeePos = CoroUtilEntity.canSee((Entity)ent, (BlockPos)new BlockPos(rX, rY, rZ)))) continue;
                if (CoroUtilPath.tryMoveToXYZLongDist((MobEntity)ent, (double)rX, (double)rY, (double)rZ, (double)1.0)) {
                    ZombieAwareness.dbg("pathing to lightsource at " + rX + ", " + rY + ", " + rZ + " - " + ent);
                }
                return true;
            }
        }
        return false;
    }

    public static EntityScent ai_FindSense(MobEntity ent) {
        return ZAUtil.ai_FindSense(ent, true);
    }

    public static EntityScent ai_FindSense(MobEntity ent, boolean includeWaypoints) {
        EntityScent var3 = ZAUtil.getSenseNearEntity((Entity)ent);
        if (var3 != null && (includeWaypoints || var3.field_200606_g != 2) && CoroUtilPath.tryMoveToEntityLivingLongDist((MobEntity)ent, (Entity)var3, (double)1.0)) {
            ZombieAwareness.dbg("ai_FindSense call, type: " + var3.field_200606_g + " - " + ent.func_200200_C_() + " -> " + var3.func_213303_ch());
            return var3;
        }
        return null;
    }

    public static boolean ai_FindTarget(MobEntity ent, boolean omniscient) {
        long huntRange = ZAConfig.sightRange;
        if (omniscient) {
            huntRange = 512L;
        }
        if (ent.func_70638_az() == null || ent.field_70170_p.field_73012_v.nextInt(100) == 0) {
            boolean found = false;
            Entity clEnt = null;
            float closest = 9999.0f;
            List list = ent.field_70170_p.func_72839_b((Entity)ent, ent.func_174813_aQ().func_72314_b((double)huntRange, (double)(huntRange / 2L), (double)huntRange));
            for (int j = 0; j < list.size(); ++j) {
                float dist;
                Entity entity1 = (Entity)list.get(j);
                if (ent.getClass().getSimpleName().equals("EntityZombiePlayer") || !ZAUtil.isEnemy((Entity)ent, entity1, omniscient) || !omniscient && !ZAConfig.seeThroughWalls && !((LivingEntity)entity1).func_70685_l((Entity)ent) || !ZAUtil.sanityCheck((Entity)ent, entity1) || !((dist = (float)ent.func_70068_e(entity1)) < closest)) continue;
                closest = dist;
                clEnt = entity1;
            }
            if (clEnt != null) {
                ZAUtil.huntTarget(ent, (LivingEntity)clEnt);
                ZombieAwareness.dbg(" hunting target " + ent + " " + clEnt);
                return true;
            }
        }
        return false;
    }

    public static EntityScent getSenseNearEntity(Entity entSource) {
        List listEnts = entSource.field_70170_p.func_72839_b(entSource, entSource.func_174813_aQ().func_72314_b((double)ZAConfig.maxPFRangeSense, (double)ZAConfig.maxPFRangeSense, (double)ZAConfig.maxPFRangeSense));
        EntityScent entBest = null;
        for (int i = 0; i < listEnts.size(); ++i) {
            Entity entCheck = (Entity)listEnts.get(i);
            if (!(entCheck instanceof EntityScent)) continue;
            double dist = entSource.func_70032_d(entCheck);
            float rangeToClose = 5.0f;
            int randChance = 20;
            if (((EntityScent)entCheck).field_200606_g == 2) {
                rangeToClose = 10.0f;
                randChance = 2;
            }
            if (!(dist < (double)((EntityScent)entCheck).getRange()) || !(dist > (double)rangeToClose) || entSource.field_70170_p.field_73012_v.nextInt(randChance) != 0) continue;
            entBest = (EntityScent)entCheck;
            return entBest;
        }
        return entBest;
    }

    public static void hookPlayEvent(int type, World world, double pX, double pY, double pZ, int data) {
        PlayerEntity closestPlayer;
        if (world.func_201670_d()) {
            return;
        }
        if (!ZAUtil.canSpawnTrace(world, pX, pY, pZ)) {
            return;
        }
        SoundProfileEntry entry = ZAUtil.getFirstEntry(type);
        if (entry != null && (closestPlayer = ZAUtil.getClosestPlayer(world, pX, pY, pZ, 128.0)) != null) {
            Vector3d pos = new Vector3d(pX, pY, pZ);
            ZAUtil.handleSoundProfileEvent(world, entry, pos, closestPlayer);
        }
    }

    public static void hookSoundEvent(SoundEvent sound, World world, double x, double y, double z, float volume, float pitch) {
        PlayerEntity closestPlayer;
        if (world.func_201670_d() || sound == null) {
            return;
        }
        if (!ZAUtil.canSpawnTrace(world, x, y, z) && !ZAUtil.canSpawnTrace(world, x, y += 1.0, z)) {
            return;
        }
        String soundName = SoundProfileEntry.getSoundEventName(sound);
        SoundProfileEntry entry = ZAUtil.getFirstEntry(soundName);
        if (entry != null && (closestPlayer = ZAUtil.getClosestPlayer(world, x, y, z, 128.0)) != null) {
            Vector3d pos = new Vector3d(x, y, z);
            ZAUtil.handleSoundProfileEvent(world, entry, pos, closestPlayer);
        }
    }

    public static void handleSoundProfileEvent(World world, SoundProfileEntry entry, Vector3d pos, PlayerEntity closestPlayer) {
        double distToPlayer = Math.sqrt(closestPlayer.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c));
        double strength = ZAConfig.soundStrength;
        if (distToPlayer <= entry.getDistanceMax() && (entry.getOddsTo1ToUse() <= 0 || rand.nextInt(entry.getOddsTo1ToUse()) == 0)) {
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(world, pos, EnumSenseType.SOUND, (int)(strength *= entry.getMultiplier()));
            ZombieAwareness.dbg("spawned or buffed sound sense from soundEvent, sound: " + entry.getSoundName() + ", str: " + scent.getStrengthPeak());
        }
    }

    public static void hookBlockEvent(PlayerEvent event, int chance) {
        if (!ZAConfigFeatures.awareness_Sound) {
            return;
        }
        if (ZAConfigFeatures.awareness_Sound_OverworldOnly && event.getEntity().field_70170_p.func_234923_W_() != World.field_234918_g_) {
            return;
        }
        if (event.getPlayer() == null || ZAConfigPlayerLists.whiteListUsedSenses && !ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((Entity)event.getPlayer()))) {
            return;
        }
        if (!event.getEntity().field_70170_p.func_201670_d() && event.getEntity().field_70170_p.field_73012_v.nextInt(chance) == 0) {
            int strength = ZAConfig.soundStrength;
            Vector3d pos = new Vector3d(event.getPlayer().func_226277_ct_(), event.getPlayer().func_226278_cu_(), event.getPlayer().func_226281_cx_());
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(event.getEntity().field_70170_p, pos, EnumSenseType.SOUND, strength);
            ZombieAwareness.dbg("spawned or buffed sound sense from PlayerEvent: " + scent.getStrengthPeak());
        }
    }

    public static void handleBlockBasedEvent(PlayerEntity player, World world, BlockPos pos, int chance) {
        if (player == null && ZAConfig.blockBreakEvent_PlayersOnly) {
            return;
        }
        if (!ZAConfigFeatures.awareness_Sound) {
            return;
        }
        if (ZAConfigFeatures.awareness_Sound_OverworldOnly && world.func_234923_W_() != World.field_234918_g_) {
            return;
        }
        if (player != null && ZAConfigPlayerLists.whiteListUsedSenses && ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((Entity)player))) {
            return;
        }
        if (!world.func_201670_d() && world.field_73012_v.nextInt(chance) == 0) {
            int strength = ZAConfig.soundStrength;
            Vector3d posVec = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            EntityScent scent = ZAUtil.spawnOrBuffSenseAtPos(world, posVec, EnumSenseType.SOUND, strength);
            ZombieAwareness.dbg("spawned or buffed sound sense from BlockBasedEvent: " + scent.getStrengthPeak());
        }
    }

    public static void hookSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof MobEntity) {
            if (event.getTarget() instanceof PlayerEntity) {
                ZAUtil.tryPlayTargetSound((MobEntity)event.getEntityLiving(), event.getTarget(), new Vector3d(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_()));
            } else if (event.getTarget() == null) {
                // empty if block
            }
        }
    }

    public static void spawnWaypoint(Entity entSource) {
        int range = 128;
        double tryX = (int)entSource.func_226277_ct_() - range / 2 + rand.nextInt(range);
        double tryZ = (int)entSource.func_226281_cx_() - range / 2 + rand.nextInt(range);
        double tryY = entSource.field_70170_p.func_201676_a(Heightmap.Type.MOTION_BLOCKING, (int)Math.floor(tryX), (int)Math.floor(tryZ));
        if (!ZAUtil.canSpawnTrace(entSource.field_70170_p, tryX, tryY, tryZ)) {
            return;
        }
        double height = entSource.func_226278_cu_();
        EntityScent var1 = ZAUtil.getSenseNodeAtPos(entSource.field_70170_p, new Vector3d(tryX, tryY, tryZ), EnumSenseType.WAYPOINT);
        boolean newNode = false;
        if (var1 == null) {
            var1 = new EntityScent(EntityRegistry.SCENT, entSource.field_70170_p);
            newNode = true;
        }
        var1.setStrengthPeak(150);
        if (newNode) {
            var1.func_70107_b(tryX, tryY, tryZ);
            var1.field_200606_g = 2;
            entSource.field_70170_p.func_217376_c((Entity)var1);
        }
        if (debug) {
            System.out.println("WP: " + entSource + " - range: " + var1.getRange());
        }
    }

    public static boolean canSpawnTrace(World world, double x, double y, double z) {
        if (!ZAConfigFeatures.awareness_Sound) {
            return false;
        }
        if (ZAConfigFeatures.awareness_Sound_OverworldOnly && world.func_234923_W_() != World.field_234918_g_) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.func_195588_v(pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        return state.func_185904_a() != Material.field_151594_q || state.func_177230_c() instanceof AbstractButtonBlock || state.func_177230_c() instanceof LeverBlock;
    }

    public static PlayerEntity getClosestPlayerToEntity(World world, Entity par1Entity, double par2) {
        return ZAUtil.getClosestPlayer(world, par1Entity.func_226277_ct_(), par1Entity.func_226278_cu_(), par1Entity.func_226281_cx_(), par2);
    }

    public static PlayerEntity getClosestPlayer(World world, double par1, double par3, double par5, double par7) {
        double d4 = -1.0;
        PlayerEntity entityplayer = null;
        for (int i = 0; i < world.func_217369_A().size(); ++i) {
            PlayerEntity entityplayer1 = (PlayerEntity)world.func_217369_A().get(i);
            if (ZAConfigPlayerLists.whiteListUsedSenses && !ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((Entity)entityplayer1))) continue;
            double d5 = entityplayer1.func_70092_e(par1, par3, par5);
            if (!(par7 < 0.0) && !(d5 < par7 * par7) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public static EntityScent getSenseNodeAtPos(World parWorld, Vector3d parPos, EnumSenseType type) {
        if (ZAConfig.extraScentCutoffRange == -1.0) {
            return null;
        }
        AxisAlignedBB aabb = new AxisAlignedBB(parPos.field_72450_a, parPos.field_72448_b, parPos.field_72449_c, parPos.field_72450_a + 1.0, parPos.field_72448_b + 1.0, parPos.field_72449_c + 1.0);
        List list = parWorld.func_217357_a(EntityScent.class, aabb = aabb.func_72314_b(ZAConfig.extraScentCutoffRange, ZAConfig.extraScentCutoffRange, ZAConfig.extraScentCutoffRange));
        if (list.size() > 0) {
            for (int j = 0; j < list.size(); ++j) {
                EntityScent node = (EntityScent)((Object)list.get(j));
                if (node.field_200606_g != type.ordinal()) continue;
                return node;
            }
        }
        return null;
    }

    public static EntityScent spawnOrBuffSenseAtPos(World world, Vector3d parPos, EnumSenseType type, int strength) {
        return ZAUtil.spawnOrBuffSenseAtPos(world, parPos, type, strength, true);
    }

    public static EntityScent spawnOrBuffSenseAtPos(World world, Vector3d parPos, EnumSenseType type, int strength, boolean frequentSoundMultiply) {
        EntityScent sense = ZAUtil.getSenseNodeAtPos(world, parPos, type);
        if (sense == null) {
            sense = new EntityScent(EntityRegistry.SCENT, world);
            sense.field_200606_g = type.ordinal();
            sense.func_70107_b(parPos.field_72450_a, parPos.field_72448_b, parPos.field_72449_c);
            sense.setStrengthPeak(strength);
            world.func_217376_c((Entity)sense);
        } else if (frequentSoundMultiply) {
            float str = sense.getStrengthPeak();
            if (str < (float)strength) {
                str = strength;
            }
            if (sense.lastBuffTime + (long)ZAConfig.frequentSoundThreshold > System.currentTimeMillis()) {
                sense.lastMultiply += 0.1f;
                str *= sense.lastMultiply;
            } else {
                sense.lastMultiply = 1.0f;
            }
            sense.lastBuffTime = System.currentTimeMillis();
            sense.setStrengthPeak((int)str);
        }
        return sense;
    }

    public static void tryPlayTargetSound(MobEntity entAlerted, LivingEntity entTargetted, Vector3d pos) {
        if (!ZAConfigFeatures.soundAlerts) {
            return;
        }
        if (!ZombieAwareness.canProcessEntity((Entity)entAlerted)) {
            return;
        }
        double distMaxCancel = 75.0;
        if ((!lookupLastAlertTime.containsKey(entAlerted) || lookupLastAlertTime.get(entAlerted) + alertDelay < entAlerted.field_70170_p.func_82737_E()) && (double)entAlerted.func_70032_d((Entity)entTargetted) < distMaxCancel && entAlerted.field_70170_p.func_234923_W_() == entTargetted.field_70170_p.func_234923_W_() && entAlerted.field_70170_p.func_195588_v(entAlerted.func_233580_cy_()) && entTargetted.field_70170_p.func_195588_v(entTargetted.func_233580_cy_())) {
            if (entAlerted.func_70685_l((Entity)entTargetted)) {
                entAlerted.field_70170_p.func_184148_a(null, entTargetted.func_226277_ct_(), entTargetted.func_226278_cu_(), entTargetted.func_226281_cx_(), ZAConfigFeatures.soundUseAlternateAlertNoise ? SoundRegistry.get("alert") : SoundRegistry.get("target"), SoundCategory.HOSTILE, (float)ZAConfigFeatures.soundVolumeAlertTarget, ZAConfigFeatures.soundUseAlternateAlertNoise ? 1.0f : 0.8f + entAlerted.field_70170_p.field_73012_v.nextFloat() * 0.2f);
                lookupLastAlertTime.put((Entity)entAlerted, entAlerted.field_70170_p.func_82737_E());
            } else {
                ZAUtil.tryPlayInvestigateSound(entAlerted, pos);
            }
        }
    }

    public static void tryPlayInvestigateSound(MobEntity entAlerted, Vector3d pos) {
        if (!ZAConfigFeatures.soundInvestigates) {
            return;
        }
        if (!ZombieAwareness.canProcessEntity((Entity)entAlerted)) {
            return;
        }
        if (!lookupLastInvestigateTime.containsKey(entAlerted) || lookupLastInvestigateTime.get(entAlerted) + investigateDelay < entAlerted.field_70170_p.func_82737_E()) {
            entAlerted.field_70170_p.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundRegistry.get("investigate"), SoundCategory.HOSTILE, (float)ZAConfigFeatures.soundVolumeInvestigate, 0.7f + entAlerted.field_70170_p.field_73012_v.nextFloat() * 0.3f);
            lookupLastInvestigateTime.put((Entity)entAlerted, entAlerted.field_70170_p.func_82737_E());
            ZombieAwareness.dbg("!!! investigate play for ent: " + entAlerted.func_145782_y() + ", lookupSize: " + lookupLastInvestigateTime.size());
        }
    }

    public static boolean isZombieAwarenessActive(World world) {
        if (world == null) {
            return false;
        }
        if (ZAConfig.daysBeforeFeaturesActivate <= 0.0) {
            return true;
        }
        return (double)world.func_82737_E() / (double)CoroUtilWorldTime.getDayLength() >= ZAConfig.daysBeforeFeaturesActivate;
    }

    public static WorldData getWorldData(RegistryKey<World> dimID) {
        if (!lookupWorldData.containsKey(dimID)) {
            lookupWorldData.put(dimID, new WorldData());
        }
        return lookupWorldData.get(dimID);
    }

    static {
        ZAUtil.addSoundHooks();
    }
}

